########################################################################
#
# $Id: CPconvert.pm,v 1.10 2002/08/26 21:53:50 gosha Exp $
#
# Copyright (C)  Okunev Igor gosha@prv.mts-nn.ru  2001 - 2002 
#
########################################################################
package Cyrillic::CPconvert;

use strict;
use vars qw( @ISA @EXPORT_OK $VERSION );
use Exporter;

($VERSION='$Revision: 1.10 $')=~s/^\S+\s+(\S+)\s+.*/$1/;

@ISA		= qw(Exporter);

@EXPORT_OK	= qw( new list );

my $CHARS = {
	'CP1251'		=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','\xA0','','\xA4','\xA6','\xA7','\xA9','\xAB','\xAC','\xAD','\xAE','\xB0','\xB1','','\xB5','\xB6','\xB7','\xBB','','','\xA8','\x80','\x81','\xAA','\xBD','\xB2','\xAF','\xA3','\x8A','\x8C','\x8E','\x8D','\xA1','\x8F','\xC0','\xC1','\xC2','\xC3','\xC4','\xC5','\xC6','\xC7','\xC8','\xC9','\xCA','\xCB','\xCC','\xCD','\xCE','\xCF','\xD0','\xD1','\xD2','\xD3','\xD4','\xD5','\xD6','\xD7','\xD8','\xD9','\xDA','\xDB','\xDC','\xDD','\xDE','\xDF','\xE0','\xE1','\xE2','\xE3','\xE4','\xE5','\xE6','\xE7','\xE8','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF','\xF0','\xF1','\xF2','\xF3','\xF4','\xF5','\xF6','\xF7','\xF8','\xF9','\xFA','\xFB','\xFC','\xFD','\xFE','\xFF','\xB8','\x90','\x83','\xBA','\xBE','\xB3','\xBF','\xBC','\x9A','\x9C','\x9E','\x9D','\xA2','\x9F','\xA5','\xB4','\x96','\x97','\x91','\x92','\x82','\x93','\x94','\x84','\x86','\x87','\x95','\x85','\x89','\x8B','\x9B','\x88','\xB9','\x99','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','' ],
	'ECMA-CYRILLIC'	=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','\x80','\x81','\x82','\x83','\x84','\x85','\x86','\x87','\x88','\x89','\x8A','\x8B','\x8C','\x8D','\x8E','\x8F','\x90','\x91','\x92','\x93','\x94','\x95','\x96','\x97','\x98','\x99','\x9A','\x9B','\x9C','\x9D','\x9E','\x9F','\xA0','','\xBD','','','','','','\xAD','','','','','','','','','','','\xB3','\xB1','\xB2','\xB4','\xB5','\xB6','\xB7','\xB8','\xB9','\xBA','\xBB','\xBC','\xBE','\xBF','\xE1','\xE2','\xF7','\xE7','\xE4','\xE5','\xF6','\xFA','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF','\xF0','\xF2','\xF3','\xF4','\xF5','\xE6','\xE8','\xE3','\xFE','\xFB','\xFD','\xFF','\xF9','\xF8','\xFC','\xE0','\xF1','\xC1','\xC2','\xD7','\xC7','\xC4','\xC5','\xD6','\xDA','\xC9','\xCA','\xCB','\xCC','\xCD','\xCE','\xCF','\xD0','\xD2','\xD3','\xD4','\xD5','\xC6','\xC8','\xC3','\xDE','\xDB','\xDD','\xDF','\xD9','\xD8','\xDC','\xC0','\xD1','\xA3','\xA1','\xA2','\xA4','\xA5','\xA6','\xA7','\xA8','\xA9','\xAA','\xAB','\xAC','\xAE','\xAF','','','','','','','','','','','','','','','','','','','\xB0','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','' ],
	'IBM855'		=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','\xFF','','\xCF','','\xFD','','\xAE','','\xF0','','','','','','','','\xAF','','','\x85','\x81','\x83','\x87','\x89','\x8B','\x8D','\x8F','\x91','\x93','\x95','\x97','\x99','\x9B','\xA1','\xA3','\xEC','\xAD','\xA7','\xA9','\xEA','\xF4','\xB8','\xBE','\xC7','\xD1','\xD3','\xD5','\xD7','\xDD','\xE2','\xE4','\xE6','\xE8','\xAB','\xB6','\xA5','\xFC','\xF6','\xFA','\x9F','\xF2','\xEE','\xF8','\x9D','\xE0','\xA0','\xA2','\xEB','\xAC','\xA6','\xA8','\xE9','\xF3','\xB7','\xBD','\xC6','\xD0','\xD2','\xD4','\xD6','\xD8','\xE1','\xE3','\xE5','\xE7','\xAA','\xB5','\xA4','\xFB','\xF5','\xF9','\x9E','\xF1','\xED','\xF7','\x9C','\xDE','\x84','\x80','\x82','\x86','\x88','\x8A','\x8C','\x8E','\x90','\x92','\x94','\x96','\x98','\x9A','','','','','','','','','','','','','','','','','','','\xEF','','','','','','','','','','','','\xC4','\xB3','\xDA','\xBF','\xC0','\xD9','\xC3','\xB4','\xC2','\xC1','\xC5','\xCD','\xBA','','','\xC9','','','\xBB','','','\xC8','','','\xBC','','','\xCC','','','\xB9','','','\xCB','','','\xCA','','','\xCE','\xDF','\xDC','\xDB','','','\xB0','\xB1','\xB2','\xFE' ],
	'IBM866'		=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','\xFF','','\xFD','','','','','','','','\xF8','','','','','\xFA','','','','\xF0','','','\xF2','','','\xF4','','','','','','\xF6','','\x80','\x81','\x82','\x83','\x84','\x85','\x86','\x87','\x88','\x89','\x8A','\x8B','\x8C','\x8D','\x8E','\x8F','\x90','\x91','\x92','\x93','\x94','\x95','\x96','\x97','\x98','\x99','\x9A','\x9B','\x9C','\x9D','\x9E','\x9F','\xA0','\xA1','\xA2','\xA3','\xA4','\xA5','\xA6','\xA7','\xA8','\xA9','\xAA','\xAB','\xAC','\xAD','\xAE','\xAF','\xE0','\xE1','\xE2','\xE3','\xE4','\xE5','\xE6','\xE7','\xE8','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF','\xF1','','','\xF3','','','\xF5','','','','','','\xF7','','','','','','','','','','','','','','','','','','','','\xFC','','','\xF9','\xFB','','','','','','','','\xC4','\xB3','\xDA','\xBF','\xC0','\xD9','\xC3','\xB4','\xC2','\xC1','\xC5','\xCD','\xBA','\xD5','\xD6','\xC9','\xB8','\xB7','\xBB','\xD4','\xD3','\xC8','\xBE','\xBD','\xBC','\xC6','\xC7','\xCC','\xB5','\xB6','\xB9','\xD1','\xD2','\xCB','\xCF','\xD0','\xCA','\xD8','\xD7','\xCE','\xDF','\xDC','\xDB','\xDD','\xDE','\xB0','\xB1','\xB2','\xFE' ],
	'IBM880'		=>	[ '\x00','\x37','\x2D','\x2E','\x2F','\x16','\x05','\x25','\x3C','\x3D','\x32','\x26','\x3F','\x27','\x40','\x4F','\x7F','\x7B','\x5B','\x6C','\x50','\x7D','\x4D','\x5D','\x5C','\x4E','\x6B','\x60','\x4B','\x61','\xF0','\xF1','\xF2','\xF3','\xF4','\xF5','\xF6','\xF7','\xF8','\xF9','\x7A','\x5E','\x4C','\x7E','\x6E','\x6F','\x7C','\xC1','\xC2','\xC3','\xC4','\xC5','\xC6','\xC7','\xC8','\xC9','\xD1','\xD2','\xD3','\xD4','\xD5','\xD6','\xD7','\xD8','\xD9','\xE2','\xE3','\xE4','\xE5','\xE6','\xE7','\xE8','\xE9','\x4A','\xE0','\x5A','\x5F','\x6D','\x00','\x81','\x82','\x83','\x84','\x85','\x86','\x87','\x88','\x89','\x91','\x92','\x93','\x94','\x95','\x96','\x97','\x98','\x99','\xA2','\xA3','\xA4','\xA5','\xA6','\xA7','\xA8','\xA9','\x00','\x00','\x00','\x00','\x07','\x20','\x21','\x22','\x23','\x24','\x15','\x06','\x17','\x28','\x29','\x2A','\x2B','\x2C','\x09','\x0A','\x1B','\x30','\x31','\x1A','\x33','\x34','\x35','\x36','\x08','\x38','\x39','\x3A','\x3B','\x04','\x14','\x3E','\xFF','','','\xE1','\x6A','','','','','','','','','','','','','','','','\x63','\x59','\x62','','\x65','\x66','\x67','\x68','\x69','\x70','\x71','\x72','','\x75','\xB9','\xBA','\xED','\xBF','\xBC','\xBD','\xEC','\xFA','\xCB','\xCC','\xCD','\xCE','\xCF','\xDA','\xDB','\xDC','\xDE','\xDF','\xEA','\xEB','\xBE','\xCA','\xBB','\xFE','\xFB','\xFD','\x57','\xEF','\xEE','\xFC','\xB8','\xDD','\x77','\x78','\xAF','\x8D','\x8A','\x8B','\xAE','\xB2','\x8F','\x90','\x9A','\x9B','\x9C','\x9D','\x9E','\x9F','\xAA','\xAB','\xAC','\xAD','\x8C','\x8E','\x80','\xB6','\xB3','\xB5','\xB7','\xB1','\xB0','\xB4','\x76','\xA0','\x44','\x42','\x43','','\x46','\x47','\x48','\x49','\x51','\x52','\x53','\x54','','\x56','','','','','','','','','','','','','','','','','','','\x58','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','' ],
	'ISO-8859-5'	=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','\x80','\x81','\x82','\x83','\x84','\x85','\x86','\x87','\x88','\x89','\x8A','\x8B','\x8C','\x8D','\x8E','\x8F','\x90','\x91','\x92','\x93','\x94','\x95','\x96','\x97','\x98','\x99','\x9A','\x9B','\x9C','\x9D','\x9E','\x9F','\xA0','','','','\xFD','','','','\xAD','','','','','','','','','','','\xA1','\xA2','\xA3','\xA4','\xA5','\xA6','\xA7','\xA8','\xA9','\xAA','\xAB','\xAC','\xAE','\xAF','\xB0','\xB1','\xB2','\xB3','\xB4','\xB5','\xB6','\xB7','\xB8','\xB9','\xBA','\xBB','\xBC','\xBD','\xBE','\xBF','\xC0','\xC1','\xC2','\xC3','\xC4','\xC5','\xC6','\xC7','\xC8','\xC9','\xCA','\xCB','\xCC','\xCD','\xCE','\xCF','\xD0','\xD1','\xD2','\xD3','\xD4','\xD5','\xD6','\xD7','\xD8','\xD9','\xDA','\xDB','\xDC','\xDD','\xDE','\xDF','\xE0','\xE1','\xE2','\xE3','\xE4','\xE5','\xE6','\xE7','\xE8','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF','\xF1','\xF2','\xF3','\xF4','\xF5','\xF6','\xF7','\xF8','\xF9','\xFA','\xFB','\xFC','\xFE','\xFF','','','','','','','','','','','','','','','','','','','\xF0','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','' ],
	'KOI-8'			=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','\xE1','\xE2','\xF7','\xE7','\xE4','\xE5','\xF6','\xFA','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF','\xF0','\xF2','\xF3','\xF4','\xF5','\xE6','\xE8','\xE3','\xFE','\xFB','\xFD','','\xF9','\xF8','\xFC','\xE0','\xF1','\xC1','\xC2','\xD7','\xC7','\xC4','\xC5','\xD6','\xDA','\xC9','\xCA','\xCB','\xCC','\xCD','\xCE','\xCF','\xD0','\xD2','\xD3','\xD4','\xD5','\xC6','\xC8','\xC3','\xDE','\xDB','\xDD','\xDF','\xD9','\xD8','\xDC','\xC0','\xD1','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','' ],
	'KOI8-R'		=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','\x9A','','','','','\xBF','','','','','\x9C','','\x9D','','','\x9E','','\x9F','','\xB3','','','','','','','','','','','','','','\xE1','\xE2','\xF7','\xE7','\xE4','\xE5','\xF6','\xFA','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF','\xF0','\xF2','\xF3','\xF4','\xF5','\xE6','\xE8','\xE3','\xFE','\xFB','\xFD','\xFF','\xF9','\xF8','\xFC','\xE0','\xF1','\xC1','\xC2','\xD7','\xC7','\xC4','\xC5','\xD6','\xDA','\xC9','\xCA','\xCB','\xCC','\xCD','\xCE','\xCF','\xD0','\xD2','\xD3','\xD4','\xD5','\xC6','\xC8','\xC3','\xDE','\xDB','\xDD','\xDF','\xD9','\xD8','\xDC','\xC0','\xD1','\xA3','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','\x95','\x96','','\x97','','\x98','\x99','\x93','\x9B','\x80','\x81','\x82','\x83','\x84','\x85','\x86','\x87','\x88','\x89','\x8A','\xA0','\xA1','\xA2','\xA4','\xA5','\xA6','\xA7','\xA8','\xA9','\xAA','\xAB','\xAC','\xAD','\xAE','\xAF','\xB0','\xB1','\xB2','\xB4','\xB5','\xB6','\xB7','\xB8','\xB9','\xBA','\xBB','\xBC','\xBD','\xBE','\x8B','\x8C','\x8D','\x8E','\x8F','\x90','\x91','\x92','\x94' ],
	'KOI8-U'		=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','\x9A','','','','','\xBF','','','','','\x9C','','\x9D','','','\x9E','','\x9F','','\xB3','','','\xB4','','\xB6','\xB7','','','','','','','','\xE1','\xE2','\xF7','\xE7','\xE4','\xE5','\xF6','\xFA','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF','\xF0','\xF2','\xF3','\xF4','\xF5','\xE6','\xE8','\xE3','\xFE','\xFB','\xFD','\xFF','\xF9','\xF8','\xFC','\xE0','\xF1','\xC1','\xC2','\xD7','\xC7','\xC4','\xC5','\xD6','\xDA','\xC9','\xCA','\xCB','\xCC','\xCD','\xCE','\xCF','\xD0','\xD2','\xD3','\xD4','\xD5','\xC6','\xC8','\xC3','\xDE','\xDB','\xDD','\xDF','\xD9','\xD8','\xDC','\xC0','\xD1','\xA3','','','\xA4','','\xA6','\xA7','','','','','','','','\xBD','\xAD','','','','','','','','','','','','','','','','','','','','\x95','\x96','','\x97','','\x98','\x99','\x93','\x9B','\x80','\x81','\x82','\x83','\x84','\x85','\x86','\x87','\x88','\x89','\x8A','\xA0','\xA1','\xA2','','\xA5','','','\xA8','\xA9','\xAA','\xAB','\xAC','','\xAE','\xAF','\xB0','\xB1','\xB2','','\xB5','','','\xB8','\xB9','\xBA','\xBB','\xBC','','\xBE','\x8B','\x8C','\x8D','\x8E','\x8F','\x90','\x91','\x92','\x94' ],
	'MAC-UK'		=>	[ '\x00','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','\xCA','\xA3','\xFF','','\xA4','\xA9','\xC7','\xC2','','\xA8','\xA1','\xB1','','\xB5','\xA6','','\xC8','\xD6','\xC4','\xDD','\xAB','\xAE','\xB8','\xC1','\xA7','\xBA','\xB7','\xBC','\xBE','\xCB','\xCD','\xD8','\xDA','\x80','\x81','\x82','\x83','\x84','\x85','\x86','\x87','\x88','\x89','\x8A','\x8B','\x8C','\x8D','\x8E','\x8F','\x90','\x91','\x92','\x93','\x94','\x95','\x96','\x97','\x98','\x99','\x9A','\x9B','\x9C','\x9D','\x9E','\x9F','\xE0','\xE1','\xE2','\xE3','\xE4','\xE5','\xE6','\xE7','\xE8','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF','\xF0','\xF1','\xF2','\xF3','\xF4','\xF5','\xF6','\xF7','\xF8','\xF9','\xFA','\xFB','\xFC','\xFD','\xFE','\xDF','\xDE','\xAC','\xAF','\xB9','\xCF','\xB4','\xBB','\xC0','\xBD','\xBF','\xCC','\xCE','\xD9','\xDB','\xA2','\xB6','\xD0','\xD1','\xD4','\xD5','','\xD2','\xD3','\xD7','\xA0','','\xA5','\xC9','','','','','\xDC','\xAA','\xC6','','\xC3','\xB0','\xC5','\xAD','\xB2','\xB3','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','' ],
	'UTF8'			=>	[ '','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x14','\x15','\x16','\x17','\x1A','\x1B','\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F','\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F','\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F','\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F','\x60','\x61','\x62','\x63','\x64','\x65','\x66','\x67','\x68','\x69','\x6A','\x6B','\x6C','\x6D','\x6E','\x6F','\x70','\x71','\x72','\x73','\x74','\x75','\x76','\x77','\x78','\x79','\x7A','\x7B','\x7C','\x7D','\x7E','\x7F','\xC2\x80','\xC2\x81','\xC2\x82','\xC2\x83','\xC2\x84','\xC2\x85','\xC2\x86','\xC2\x87','\xC2\x88','\xC2\x89','\xC2\x8A','\xC2\x8B','\xC2\x8C','\xC2\x8D','\xC2\x8E','\xC2\x8F','\xC2\x90','\xC2\x91','\xC2\x92','\xC2\x93','\xC2\x94','\xC2\x95','\xC2\x96','\xC2\x97','\xC2\x98','\xC2\x99','\xC2\x9A','\xC2\x9B','\xC2\x9C','\xC2\x9D','\xC2\x9E','\xC2\x9F','\xC2\xA0','\xC2\xA3','\xC2\xA4','\xC2\xA6','\xC2\xA7','\xC2\xA9','\xC2\xAB','\xC2\xAC','\xC2\xAD','\xC2\xAE','\xC2\xB0','\xC2\xB1','\xC2\xB2','\xC2\xB5','\xC2\xB6','\xC2\xB7','\xC2\xBB','\xC3\xB7','\xC6\x92','\xD0\x81','\xD0\x82','\xD0\x83','\xD0\x84','\xD0\x85','\xD0\x86','\xD0\x87','\xD0\x88','\xD0\x89','\xD0\x8A','\xD0\x8B','\xD0\x8C','\xD0\x8E','\xD0\x8F','\xD0\x90','\xD0\x91','\xD0\x92','\xD0\x93','\xD0\x94','\xD0\x95','\xD0\x96','\xD0\x97','\xD0\x98','\xD0\x99','\xD0\x9A','\xD0\x9B','\xD0\x9C','\xD0\x9D','\xD0\x9E','\xD0\x9F','\xD0\xA0','\xD0\xA1','\xD0\xA2','\xD0\xA3','\xD0\xA4','\xD0\xA5','\xD0\xA6','\xD0\xA7','\xD0\xA8','\xD0\xA9','\xD0\xAA','\xD0\xAB','\xD0\xAC','\xD0\xAD','\xD0\xAE','\xD0\xAF','\xD0\xB0','\xD0\xB1','\xD0\xB2','\xD0\xB3','\xD0\xB4','\xD0\xB5','\xD0\xB6','\xD0\xB7','\xD0\xB8','\xD0\xB9','\xD0\xBA','\xD0\xBB','\xD0\xBC','\xD0\xBD','\xD0\xBE','\xD0\xBF','\xD1\x80','\xD1\x81','\xD1\x82','\xD1\x83','\xD1\x84','\xD1\x85','\xD1\x86','\xD1\x87','\xD1\x88','\xD1\x89','\xD1\x8A','\xD1\x8B','\xD1\x8C','\xD1\x8D','\xD1\x8E','\xD1\x8F','\xD1\x91','\xD1\x92','\xD1\x93','\xD1\x94','\xD1\x95','\xD1\x96','\xD1\x97','\xD1\x98','\xD1\x99','\xD1\x9A','\xD1\x9B','\xD1\x9C','\xD1\x9E','\xD1\x9F','\xD2\x90','\xD2\x91','\xE2\x80\x93','\xE2\x80\x94','\xE2\x80\x98','\xE2\x80\x99','\xE2\x80\x9A','\xE2\x80\x9C','\xE2\x80\x9D','\xE2\x80\x9E','\xE2\x80\xA0','\xE2\x80\xA1','\xE2\x80\xA2','\xE2\x80\xA6','\xE2\x80\xB0','\xE2\x80\xB9','\xE2\x80\xBA','\xE2\x82\xAC','\xE2\x84\x96','\xE2\x84\xA2','\xE2\x88\x86','\xE2\x88\x99','\xE2\x88\x9A','\xE2\x88\x9E','\xE2\x89\x88','\xE2\x89\xA0','\xE2\x89\xA4','\xE2\x89\xA5','\xE2\x8C\xA0','\xE2\x8C\xA1','\xE2\x94\x80','\xE2\x94\x82','\xE2\x94\x8C','\xE2\x94\x90','\xE2\x94\x94','\xE2\x94\x98','\xE2\x94\x9C','\xE2\x94\xA4','\xE2\x94\xAC','\xE2\x94\xB4','\xE2\x94\xBC','\xE2\x95\x90','\xE2\x95\x91','\xE2\x95\x92','\xE2\x95\x93','\xE2\x95\x94','\xE2\x95\x95','\xE2\x95\x96','\xE2\x95\x97','\xE2\x95\x98','\xE2\x95\x99','\xE2\x95\x9A','\xE2\x95\x9B','\xE2\x95\x9C','\xE2\x95\x9D','\xE2\x95\x9E','\xE2\x95\x9F','\xE2\x95\xA0','\xE2\x95\xA1','\xE2\x95\xA2','\xE2\x95\xA3','\xE2\x95\xA4','\xE2\x95\xA5','\xE2\x95\xA6','\xE2\x95\xA7','\xE2\x95\xA8','\xE2\x95\xA9','\xE2\x95\xAA','\xE2\x95\xAB','\xE2\x95\xAC','\xE2\x96\x80','\xE2\x96\x84','\xE2\x96\x88','\xE2\x96\x8C','\xE2\x96\x90','\xE2\x96\x91','\xE2\x96\x92','\xE2\x96\x93','\xE2\x96\xA0' ]
};

sub new {
	my ( $class, $from, $to ) = @_;
	my ( $ptr, $from_str, $to_str, $ind );
	local $_;

	unless ( $^W ) {
		if ( not defined $from or not defined $to ) {
			return undef;
		}
	} else {
		if ( not defined $from ) {
			warn "Source codepage not defined";
			return undef;
		} elsif ( not defined $to ) {
			warn "Destination codepage not defined";
			return undef;
		}
	}
	
	if ( exists $CHARS->{$from} and exists $CHARS->{$to} ) {
		$from_str	= '';
		$to_str		= '';
		if ( $from ne 'UTF8' and $to ne 'UTF8' ) {
			for $ind ( 0 .. scalar @{$CHARS->{$from}} ) {
				if (	defined $CHARS->{$from}->[$ind]	and
						defined $CHARS->{$to}->[$ind]	and
						$CHARS->{$from}->[$ind] ne ''	and
				 		$CHARS->{$to}->[$ind]   ne ''	and
						$CHARS->{$from}->[$ind] ne $CHARS->{$to}->[$ind] ) {
								
					$from_str .= $CHARS->{$from}->[$ind];
					$to_str   .= $CHARS->{$to}->[$ind];
				}
			}
			if ( $from_str eq $to_str ) {
				unless ( defined eval ( '$ptr = sub{ 1 }' ) ) {
					die $@;
				}
			} else {
				unless ( defined eval ("\$ptr = sub{ \$_[0] =~ tr/$from_str/$to_str/ }" ) ) {
					die $@;
				}
			}
		} else {
			for $ind ( 0 .. scalar @{$CHARS->{$from}} ) {
				if (	defined $CHARS->{$from}->[$ind]	and
						defined $CHARS->{$to}->[$ind]	and
						$CHARS->{$from}->[$ind] ne ''	and
				 		$CHARS->{$to}->[$ind]   ne ''	and
						$CHARS->{$from}->[$ind] ne $CHARS->{$to}->[$ind] ) {
						
					$from_str .= $CHARS->{$from}->[$ind] . '|';
					$to_str   .= '"' . $CHARS->{$from}->[$ind] . '","' . $CHARS->{$to}->[$ind] . '",';
				}
			}

			chop $from_str;
			chop $to_str;
			
			if ( $from_str eq $to_str ) {
				unless ( defined eval ( '$ptr = sub{ 1 }' ) ) {
					die $@;
				}
			} else {
				unless ( defined eval ("\$ptr = sub{ my \%H = ($to_str); \$_[0] =~ s/($from_str)/\$H{\$1}/gs }") ) {
					die $@;
				}
			}
		}
	} else {
		if ( $^W ) {
			if ( not exists $CHARS->{$from} ) {
				warn "Source codepage `$from' not found...";
			} elsif ( not exists $CHARS->{$to} ) {
				warn "Destination codepage `$to' not found...";
			}
		}
		return undef;
	}

	return $ptr;
}

sub list {
	return keys %$CHARS;
}

1;

=pod

=head1 NAME

 

Cyrillic::CPconvert -         .

=head1 SYNOPSIS

 

 use strict;
 use Cyrillic::CPconvert;

 my @CODEPAGES = Cyrillic::CPconvert->list();
 my $string    = '';
 my $new_string;
 my $ptr;

 foreach my $cp ( @CODEPAGES ) {
    $ptr = Cyrillic::CPconvert->new('KOI8-R',$cp);
    next unless defined $ptr;
    $new_string = $string;
    $ptr->($new_string);
    print "String[ $string ] => $cp = '$new_string'\n";
    undef &$ptr;
 }

=head1 DESCRIPTION

 

=over 2

=item *

list -    .

=item *

$ptr = $new($from,$to) -     .

=over 10

=item $from 

 ..

=item $to

 ...

=back

=item *

$ptr->($sting) -   $string

=back

=head1 AUTHOR

 
 Okunev Igor V.  mailto:igor@prv.mts-nn.ru
                 http://www.mts-nn.ru/~gosha


=head1 REVISION

 

$Id: CPconvert.pm,v 1.10 2002/08/26 21:53:50 gosha Exp $

=cut

