#!/usr/bin/perl
#
# $Id: create_geo_info_db.pl,v 1.18 2025/11/21 18:10:53 gosha Exp $
#
use strict;

chdir('/tmp');

if ( $ARGV[0] eq 'rossvyaz' ) {
	system 'wget --no-check-certificate -w 240 https://rossvyaz.ru/docs/articles/Kody_ABC-3kh.csv -O krs-3.csv';
	system 'wget --no-check-certificate -w 240 https://rossvyaz.ru/docs/articles/Kody_ABC-4kh.csv -O krs-4.csv';
	system 'wget --no-check-certificate -w 240 https://rossvyaz.ru/docs/articles/Kody_ABC-8kh.csv -O krs-8.csv';
	system 'wget --no-check-certificate -w 240 https://rossvyaz.ru/docs/articles/Kody_DEF-9kh.csv -O krs-9.csv';

	die "Missing file Kody_ABC-3kh.csv" unless -s 'krs-3.csv';
	die "Missing file Kody_ABC-4kh.csv" unless -s 'krs-4.csv';
	die "Missing file Kody_ABC-8kh.csv" unless -s 'krs-8.csv';
	die "Missing file Kody_DEF-9kh.csv" unless -s 'krs-9.csv';

	system "perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/win2utf8 < krs-3.csv > k3.txt";
	system "perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/win2utf8 < krs-4.csv > k4.txt";
	system "perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/win2utf8 < krs-8.csv > k8.txt";
	system "perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/win2utf8 < krs-9.csv > k9.txt";
} else {
	system 'wget --no-check-certificate -w 240 https://opendata.digital.gov.ru/downloads/ABC-3xx.csv?'.time.' -O k3.txt';
	system 'wget --no-check-certificate -w 240 https://opendata.digital.gov.ru/downloads/ABC-4xx.csv?'.time.' -O k4.txt';
	system 'wget --no-check-certificate -w 240 https://opendata.digital.gov.ru/downloads/ABC-8xx.csv?'.time.' -O k8.txt';
	system 'wget --no-check-certificate -w 240 https://opendata.digital.gov.ru/downloads/DEF-9xx.csv?'.time.' -O k9.txt';
	
}

die "Missing file k3.txt" unless -s 'k3.txt';
die "Missing file k4.txt" unless -s 'k4.txt';
die "Missing file k8.txt" unless -s 'k8.txt';
die "Missing file k9.txt" unless -s 'k9.txt';

system("rm -f krs-3.csv krs-4.csv krs-8.csv krs-9.csv");

foreach my $k ( qw( 3 4 8 9 )  ) {
	my $str = `head -2 k$k.txt | tail -1`;
	unless ( $str =~ /^\d+\s*;\s*\d+\s*;\s*\d+\s*;/ ) {
		die "Invalid file format k$k.txt: $str";
	}
}

open(IN, 'cat k3.txt k4.txt k8.txt k9.txt |') || die "Can't open result file: $!";

open(OUT,">/tmp/krs-$$.sql") || die "Can't open sql file: $!";

print OUT "
drop table if exists VPBX_GEO_INFO_N;

create	table VPBX_GEO_INFO_N
(
	F_N 		BIGINT(64),
	L_N 		BIGINT(64),
	RNG 		int(10),
	OP 			VARCHAR(255),
	DSC 		VARCHAR(255)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
";

my $coma = '';

my $cnt = 0;

while (<IN>) {
	next unless /^\d\d\d/;

	s#[\r\n]##gs;
	s#область#обл#;
	s#"##gs;

	#999 ;   9400000 ;   9409999 ;   10000   ;   ОАО "Основа Телеком"    ;   г. Санкт - Петербург и Ленинградская область
	my @chunks = split(/\s*;\s*/,$_);

	$chunks[4] =~ s#^\s*ПАО\s*##;
	$chunks[4] =~ s#^\s*ЗАО\s*##;
	$chunks[4] =~ s#^\s*ООО\s*##;
	$chunks[4] =~ s#^\s*ОАО\s*##;
	$chunks[4] =~ s#\s*Мобильные\s*Теле\s*Системы\s*#МТС#;
	$chunks[4] =~ s#\s*Вымпел-Коммуникации#Билайн#;
	$chunks[4] =~ s#\s*ВЫМПЕЛКОМ#Билайн#;
	$chunks[4] =~ s#\s*Т2\s*Мобайл\s*#Теле2#;
	$chunks[4] =~ s#\s*Т2\s*МОБАЙЛ\s*#Теле2#;

	$chunks[5] =~ s#г\.\s+##;
	$chunks[5] =~ s#город\s+##;
	$chunks[5] =~ s#г\.о\.\s+##;

	$chunks[5] =~ s#\|# / #gs;
	$chunks[5] =~ s#\s*-\s*#-#gs;

	$chunks[4] =~ s#^\s+##;
	$chunks[4] =~ s#\s+$##;
	$chunks[4] =~ s#ГОСУДАРСТВЕННОЕ УНИТАРНОЕ ПРЕДПРИЯТИЕ ДОНЕЦКОЙ НАРОДНОЙ РЕСПУБЛИКИ##;
	$chunks[4] =~ s#ГОСУДАРСТВЕННОЕ УНИТАРНОЕ ПРЕДПРИЯТИЕ ЛУГАНСКОЙ НАРОДНОЙ РЕСПУБЛИКИ##;

	if ( $chunks[0] =~ /^9/ ) {
	#	unless( $chunks[4] =~ /\s/ ) {
			$chunks[5] = $chunks[4] .' / '. $chunks[5];
	#	}
	}

	$chunks[5] =~ s#\s*/\s*$##g;

	unless( $cnt % 1000 ) {
		print OUT "\n;\ninsert into VPBX_GEO_INFO_N (F_N,L_N,RNG,OP,DSC) VALUES";
		$coma = '';
	}
	print OUT "$coma\n\t(". $chunks[0] . $chunks[1] .',' . $chunks[0] . $chunks[2] .','. $chunks[3]. ',"'. $chunks[4]. '","'. $chunks[5]. '")';
	$coma = ',';
	$cnt++;
}

print OUT ";\n\n";

while (<DATA>) {
	chomp;
	my ( $desc, $code ) = split(/\s*;\s*/,$_);

	print OUT "insert into VPBX_GEO_INFO_N (F_N,L_N,RNG,OP,DSC) VALUES($code,0,0,'','$desc');\n";
}

print OUT "ALTER table VPBX_GEO_INFO_N add INDEX F_IN (F_N);\n";
print OUT "ALTER table VPBX_GEO_INFO_N add INDEX L_IN (L_N);\n";
print OUT "ALTER table VPBX_GEO_INFO_N add INDEX FL_IN (F_N,L_N);\n";
print OUT "CREATE table IF not exists VPBX_GEO_INFO(ID int(1));\n";
print OUT "RENAME table VPBX_GEO_INFO to VPBX_GEO_INFO_O, VPBX_GEO_INFO_N to VPBX_GEO_INFO, VPBX_GEO_INFO_O to VPBX_GEO_INFO_N;\n";

close(OUT);

my $charset = `grep NO_CHARSET /opt/VirtualPBX/etc/xvb.cfg`;

if ( $charset =~ /NO_CHARSET\s*=\s*1/ ) {
	system "mysql xvb < /tmp/krs-$$.sql";
} else {
	system "mysql xvb --default-character-set=latin1 < /tmp/krs-$$.sql";
}


__DATA__
Афганистан;93
Албания;355
Алжир;21
Американское Самоа;684
Андорра;376
Ангола;244
Ангуилла;1264
Антигуа и Барбуда;1268
Аргентина;54
Армения;374
Аруба;297
Асеньон;247
Австралия;61
Австралийские внеш. террит-и;672
Австрия;43
Азербайджан;994
Азорские о-ва;351
Багамы;1242
Бахрейн;973
Бангладеш;880
Барбадос;1246
Белоруссия;375
Бельгия;32
Белиз;501
Бенин;229
Бермудские о-ва;1441
Бутан;975
Боливия;591
Босния и Герцеговина;387
Ботсвана;267
Бразилия;55
Британские Вирджинские о-ва;1284
Бруней;673
Болгария;359
Буркина Фасо;226
Бурунди;257
Камбоджа;855
Камерун;237
Капе Верде;238
Каймановы о-ва;1345
ЦАР;236
Чад;235
Чили;56
Китай;86
Рождественсткие о-ва;672
Кокосовые о-ва;672
Колумбия;57
Содружество северных Марианских о-вов;1670
Коморские о-ва;269
Конго;242
Дем. респ. Конго (бывш. Заир);243
О-ва Кука;682
Коста Рика;506
Хорватия;385
Куба;53
Кипр;357
Чехия;420
Дания;45
Диего Гарсиа;246
Джибути;253
Доминика;1767
Доминиканская республика;1809
Восточный Тимор;62
Эквадор;593
Египет;20
Сальвадор;503
Экваториальная Гвинея;240
Эритрия;291
Эстония;372
Эфиопия;251
Фарерские о-ва;298
Фолклендские о-ва;500
Фиджи;679
Финляндия;358
Франция;33
Французские Антиллы;590
Французская Гвиана;594
Французская полинезия;689
Габон;241
Гамбия;220
Грузия;995
Германия;49
Гана;233
Гибралтар;350
Греция;30
Гренландия;299
Гренада;1473
Гуам;671
Гватемала;502
Гвинея;224
Гвинея Биссау;245
Гайана;592
Гаити;509
Гондурас;504
Гонконг;852
Венгрия;36
Исландия;354
Индия;91
Индонезия;62
Иран;98
Ирак;964
Ирландия;353
Израиль;972
Италия;39
Берег слоновой кости;225
Ямайка;1876
Япония;81
Иордания;962
Кения;254
Кирибати;686
Северная Корея;850
Южная Корея;82
Кувейт;965
Киргизстан;996
Лаос;856
Латвия;371
Ливан;961
Лессото;266
Либерия;231
Ливия;21
Лихтенштейн;41
Литва;370
Люксембург;352
Макао;853
Македония;389
Мадагаскар;261
Малави;265
Малайзия;60
Мальдивские о-ва;960
Мали;223
Мальта;356
Маршалловы о-ва;692
Мартиника;596
Мавритания;222
Маврикий;230
Мексика;52
Микронезия;691
Монако;377
Монголия;976
Монсеррат;1664
Молдавия;373
Марокко;212
Мозамбик;258
Мьянма;95
Намибия;264
Науру;674
Непал;977
Нидерланды;31
Нидерландские Антиллы;599
Новая Каледония;687
Новая Зеландия;64
Никарагуа;505
Нигер;227
Нигерия;234
Норфолкские о-ва;672
Северо-Марианские о-ва;670
Норвегия;47
Оман;968
Пакистан;92
Палау;680
Панама;507
Папуа Новая Гвинея;675
Парагвай;595
Перу;51
Филипины;63
Польша;48
Португалия;351
Пуэрто Рико;1787
Катар;974
Сан Марино;378
Реюнион;262
Румыния;40
Россия;7
Казахстан;76
Казахстан;77
Руанда;250
О-ва Святой Елены;247
Сент Пьер;508
Сент Том и Принцип;239
Саудовская Аравия;966
Сенегал;221
Сейшельские о-ва;248
Сьерра Леоне;232
Сингапур;65
Словакия;421
Словения;386
Соломоновы о-ва;677
Сомали;252
ЮАР;27
Испания;34
Шри Ланка;94
Сент-Китс и Невис;1869
Санта Лючия;1758
Сент Винцент и Гренадины;1784
Судан;249
Суринам;597
Свалбард;47
Свазиленд;268
Швеция;46
Швейцария;41
Сирия;963
Тайвань;886
Таджикистан;992
Танзания;255
Тайланд;66
Тоголезе;228
Токелау;690
Тонго;676
Тринидад и Тобаго;1868
Тунис;21
Турция;90
Туркменистан;993
Тувалу;688
Уганда;256
Украина;380
ОАЭ;971
Великобритания;44
Уругвай;598
Вирджинские о-ва;1340
США;1
Узбекистан;998
Вануату;678
Венесуэла;58
Вьетнам;84
Западная Сахара;21
Западное Самоа;685
Северный Йемен;967
Южный Йемен;969
Сербия;381
Заир;243
Замбия;260
Занзибар;259
Зимбабве;263
Черногория;382
