#!/usr/bin/perl
########################################################################
#
# $Id: cfg_update.pl,v 1.168 2025/10/30 18:23:23 gosha Exp $
#
#		(c) Okunev Igor <igor[at]prv.mts-nn.ru>
#					2008 - 2025
#
########################################################################
package VirtualPBX;

open STDERR, '>>/var/log/VirtualPBX/XVB.stderr';

use strict;

use vars qw( $VERSION );

($VERSION='$Revision: 1.168 $')=~s/^\S+\s+\d+\.(\d+)\s+.*/$1/;

########################################################################
my %update_data = (
	# top release :)
	"1000000"	=>	[
						'#'x50 . "\n# CFG-VERSION=$VERSION, DATE=". scalar(localtime(time)) ."\n"
	],

	"$VERSION"	=>	[
"[TABLES]
VBOX_PARAMS_33			= VPBX_VBOXES_WEBSOCKET
"
],
	"167"	=>	[
"[PATH]
GEARMAND_DIR		= /opt/VirtualPBX/spool/gearmand
"
],
	"166"	=>	[
"[CGI]
ADMIN_STATUS_CMD = 'tail -75 /var/log/VirtualPBX/XVB.stderr; tail -75 /var/log/asterisk/messages'
ADMIN_REPORT_CMD = 'uname -a; uptime; hostname; ifconfig || ip a; curl ifconfig.me; iptables-save; ss -n | netstat -n; top -n 1 -b -c -w 512; last | head -10; rpm -qa | grep virtual-pbx; rpm -qi virtual-pbx; asterisk -rx 'sip show channels'; df -h; cat /etc/*release; dmesg -T | tail -100'
"
],

	"163"	=>	[
"[TABLES]
ROUTES_AI				= VPBX_ROUTES_AI
"
],

	"162"	=>	[
"[TABLES]
VBOX_PARAMS_32			= VPBX_VBOXES_PAUSE
"
],

	"161"	=>	[
"[CALLBLAST]
AMD_DEFAULTS = 4500,2000,500,7200
"
],

	"160"	=>	[
"[CGI]
STAT_WITH_ASR = 1
"
],
	"158"	=>	[
"[DB]
# default limits for from_time
FROM_TIME_AI				= 5
FROM_TIME_UI				= 7
"
],

	"156"	=>	[
"[TIMEOUT]
MEM_CACHED_LAST_DIALED		= 864000
"
],

	"155"	=>	[
"
[TABLES]
ROLE			= VPBX_ROLES
"
],

	"153"	=>	[
"
[CALLBLAST]
CALLBACK_TTL		= 180
"
],

	"153"	=>	[
"####################################################
# GEARMAN 
[GEARMAN]
FUNC=radius_acct,notify_twitter,notify_email,notify_ga,gearman_cdr,gearman_db_do,notify_http,notify_tg,notify_sms
"
],

	"152"	=>	[
"
[TABLES]
PARTNER_GROUP			= VPBX_PARTNERS_GROUP
"
],
	"151"	=>	[
"####################################################
# GEARMAN 
[GEARMAN]
FUNC=radius_acct,notify_twitter,notify_email,notify_ga,gearman_cdr,gearman_db_do,notify_http,notify_tg
"
],

"149"	=>	[
"[DB]
#
# dashboard limit
DASHBOARD_LIMIT				= 15
#
# cdr user default limit
CDR_DEF_LIMIT				= 15
"
],

"148"	=>	[
"[TABLES]
CDRS_A_ALL				= VPBX_CDRS_ACTIVITY
CDRS_ALL				= VPBX_CDRS
"
],

"147"	=>	[
"[TABLES]
CDRS_A_ALL				= VPBX_CDRS_ACTIVITY_ALL
CDRS_A_ARCH				= VPBX_CDRS_ACTIVITY_ARCHIVE
"
],

"146"	=>	[
"[TABLES]
CDRS_ALL				= VPBX_CDRS_ALL
CDRS_ARCH				= VPBX_CDRS_ARCHIVE

[COMMON]
CDR_STORE_ARCH	= 1825
"
],

"145"	=>	[
"
[CGI]
INTEGRTAIONS_LIST = AlfaCRM,AmoCRM,Bitrix24,Bitrix24New,CommonCRM,EnvyCRM,PFCRM,RetatilCRM,UNFCRM,YClients,UOn,Roistat,MailRuCloud
"
],

"142"	=>	[
"
[PATH]
DB_BACKUP_DIR		= /opt/VirtualPBX/spool/backups/db/
UI_BACKUP_DIR		= /opt/VirtualPBX/spool/backups/ui/
SYS_BACKUP_DIR		= /opt/VirtualPBX/spool/backups/sys/
"
],

"141"	=>	[
"
[GEARMAN]
RETRIES_MAX=4
RETRIES_INTERVAL=120,300,1800,3600
RETRIES_MAX_db_do=10
RETRIES_INTERVAL_db_do=60,60,180,300,600,900,1800,3600
RETRIES_MAX_cdr=20
RETRIES_INTERVAL_cdr=60,60,180,300,600,900,1800,3600
"
],

"139"	=>	[
"
[CGI]
# pls note, these commands runs with root privileges
ADMIN_STATUS_CMD = 'ifconfig; tail -100 /var/log/VirtualPBX/XVB.stderr; tail -100 /var/log/asterisk/messages; tail -300 /var/log/VirtualPBX/XVB.log'
"
],

"138"	=>	[
"[SIP]
CHECK4LOCAL_DID					= 0
"
],

"137"	=>	[
"[SIP]
PHONE_OPT					= DND,FWD_NUM,FWD_AFTER
"
],

"136"	=>	[
"[CGI]
#ADMIN_DEF_C2C=
"
],

"135"	=>	[
"[TIMEOUT]
UAC_REG_EXPIRE				= 3600
"
],

"134"	=>	[
"
[COMMON]
#
# use phone number to determinate caller/called location
#
#GEO_INFO			= RU
#
[TABLES]
GEO_INFO				= VPBX_GEO_INFO
"
],

"133"	=>	[
"
[CGI]
#
# allow web login for locked accounts
#
IGNORE_LOCK = 0
"
],

"132"	=>	[
"
[SIP]
CALL_OUT_LIMIT					= 2
"
],

"131"	=>	[
"
[SIP]
REG_STRIPDID				= 0
"
],

"129"	=>	[
"
[SIP]
FIX_TO_HDR = 1
"
],

"128"	=>	[
"
[CGI]
#JOURNAL_ALIASES = support:127.0.0.1:127.0.0.2;support2:8.8.8.8:9.9.9.9
JOURNAL_ALIASES = 
ALIASES_WO_IP = 0
"
],

"127"	=>	[
"####################################################
# BILL_EVENTS 
[BILLING]
EXT_TYPES=,Dialout,CallBlast,DISA,Intercom,MultiDialout,Queue,Transfer,
"
],

"126"	=>	[
"####################################################
# Asterisk FEATURES 
[FEATURES]
MULTIDIALOUT        = 'x-hang#x-t-bg-uf'
"
],

"125"	=>	[
"[TABLES]
CRM_CUSTOMERS           = VPBX_CRM_CUSTOMERS
CRM_NOTES  		        = VPBX_CRM_NOTES"
],

"123"	=>	[
"[PATH]
#
UI_BACKUP_DIR		= /opt/VirtualPBX/spool/backups/

[COMMON]
UI_BACKUP_DAYS		= 0
"
],

"121"	=>	[
"[DB]
#
# enable post-processing data filters: 0 - disabled / xxx - limit
PPDF_LIMIT					= 5000
#
# CSV dumps limit
CSV_LIMIT					= 10000"
],

"119"	=>	[
"[TABLES]
ROUTES_TEMPLATES			= VPBX_ROUTES_TEMPLATES"
],

"118"	=>	[
"[CGI]
FIX_DOWNLOAD_FILE_NAME=yes
"
],

"117"	=>	[
"####################################################
# ASR FEATURES
[ASR]
INPUT_DURATION=3
# https://console.developers.google.com
GOOGLE_KEY=
GOOGLE_REFER=
GOOGLE_MIN_CONFIDENCE=0.50
# https://developer.tech.yandex.ru/
YANDEX_KEY=
YANDEX_MIN_CONFIDENCE=
"
],

"115"	=>	[
"[CUSTOM]
EXTRA_USER_FIELDS_4_AI=CUSTOM_RULES:CUSTOM_RULES,CUSTOM_1:CUSTOM_1:Custom field
"
],

"114"	=>	[
"[CGI]
ADMIN_KEY=". rand(time)
],

"113"	=>	[
"[DB]
NOINDEX_LIMIT               = 14
"
],

"112"	=>	[
"[TIMEOUT]
ONLINE_CALLS_REFRESH        = 5
"
],

"111"	=>	[
"[TABLES]
CALLS			= VPBX_ONLINE_CALLS
"
],

"110"	=>	[
"
[CUSTOM]
EXTRA_USER_FIELDS_4_AI=CUSTOM_RULES:CUSTOM_RULES
"
],

"109"	=>	[
"
[TIMEOUT]
DEFAULT_CALL_DURATION		= 10800
HTTP_DOWNLOAD				= 5
"
],

"108"	=>	[
"
[CGI]
ADMIN_TENANTS_TEMPLATES = -----:-----;/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/ru-office.xml:RU-office
"
],

"107"	=>	[
"
[SIP]
PHONE_OPT					= DND,FWD_NUM
"
],

"106"	=>	[
"
[COMMON]
#
# TTS cache store ( days ) 0 - always
TTS_STORE				= 180
"
],

"105"	=>	[
"[TTS]
SPEED_GTranslate_RU = 1.1
"
],

"103"	=>	[
"####################################################
[PATH]
TTS_DIR				= /opt/VirtualPBX/tts
"
],

"102"	=>	[
"####################################################
[CGI]
ADMIN_STATUS_CMD = 'free; df -h; uptime; tail -100 /var/log/VirtualPBX/XVB.stderr; tail -100 /var/log/asterisk/messages'
"
],

"101"	=>	[
"####################################################
[BILLING]
ROUNDING_4GUI=2
"
],

"100"	=>	[
"
[DB]
CACHE_WEB_AUTH              = 1
CACHE_AGI_AUTH              = 0

[COMMON]
MEM_CACHED_NODES        = '127.0.0.1:11211'
"
],

"97"	=>	[
"
[TABLES]
DID_SIPDOMAIN			= VPBX_DIDS_SIPDOMAINS
"
],

"95"	=>	[
"
[TIMEOUT]
TTS_GET                     = 4
"
],

"94"	=>	[
"####################################################
# Asterisk FEATURES 
[FEATURES]
MULTIDIALOUT		= 'xvb-hangup'
"
],

"93"	=>	[
"
[TABLES]
VBOX_PARAMS_31			= VPBX_VBOXES_MULTIDIALOUT
VBOX_MULTIDIALOUT_DATA  = VPBX_VBOXES_MULTIDIALOUT_DATA
"
],

"92"	=>	[
"####################################################
# BILL_EVENTS 
[BILLING]
#EVENT_DISA=DURATION
#EVENT_Queue=DURATION
#EVENT_Dialout=DURATION
#EVENT_FaxRX=PAGES
"
],

"91"	=>	[
"####################################################
# CUSTOM DATA 
[CUSTOM]
#ACC_FIELDS=CUSTOM_1,LANG,TZ_NAME,SOUND_FORMAT,FIRST_NAME,LAST_NAME,EMAIL,LOGO_HREF,CSS_HREF,MSG_IN_PAGE,STATEMENTS,MSG_STORE_PERIOD,DATE_FORMAT,GA_ACCOUNT,I_DIGIT_TIMEOUT,PHONE,MOBILE,ADDRESS,CITY,STATE,ZIP,COUNTRY,PASSWORD
ACC_FIELDS=CUSTOM_1,LANG,TZ_NAME,SOUND_FORMAT,FIRST_NAME,LAST_NAME,EMAIL,LOGO_HREF,CSS_HREF,MSG_IN_PAGE,STATEMENTS,MSG_STORE_PERIOD,DATE_FORMAT,GA_ACCOUNT,I_DIGIT_TIMEOUT
"
],

"90"	=>	[
"[TIMEOUT]
LOG_REOPEN					= 3600
"
],

"89"	=>	[
"[COMMON]
USE_BILLING_4EVENTS     = 1
"
],

"88"	=>	[
"
[TIMEOUT]
MEM_CACHED_CLICK2CALL		= 3600
"
],

"87"	=>	[
"
[TABLES]
CLICK2CALL				= VPBX_CLICK2CALL
"
],

"86"	=>	[
"
[TIMEOUT]
HANGUP_DELAY				= 2
"
],

"85"	=>	[
"
####################################################
[TIMEOUT]
MEM_CACHED_PBOOK			= 3600
"
],

"84"	=>	[
"
####################################################
# CGI options
[CGI]
CSV_DELIMITER					= ,
"
],

"83"	=>	[
"
[TABLES]
PHONE_BOOK				= VPBX_PHONE_BOOK
"
],

"82"	=>	[
"
[TABLES]
PARTNER					= VPBX_PARTNERS
"
],

"81"	=>	[
"
####################################################
# Asterisk FEATURES 
[FEATURES]
CALL_REC			= 'xvb-t-record'
CALL_TRANSIT		= 'xvb-t-bg-music-moh#xvb-t-bg-music-play'
CALL_PHONE			= 'xvb-t-bg-music-moh#xvb-t-bg-music-play#xvb-transfer'
"
],

"80"	=>	[
"
####################################################
# timeout options
[TIMEOUT]
DIALOUT						= 40
"
],

"79"	=>	[
"
[SIP]
REGISTRAR_TYPE				= ASTERISK

[TIMEOUT]
MEM_CACHED_SIP_PEERS		= 60
"
],

"78"	=>	[
"
[TIMEOUT]
MEM_CACHED_REMEMBER_AGENT	= 2591999
"
],

"77"	=>	[
"[TABLES]
VBOX_PARAMS_30			= VPBX_VBOXES_DTMFTX
"
],

"76"	=>	[
"
[TIMEOUT]
MEM_CACHED_PB_POS		= 864000
"
],

"75"	=>	[
"
[ASTERISK]
#
AMI_MODE				= direct
AMI_PORT				= 5038
AMI_USERNAME			= xvb
AMI_SECRET				= sec4xvb
"
],

	"74"	=>	[
"[TTS]
SPEED_GTranslate_RU = 1.22
"
],

	"73"	=>	[
"[COMMON]
#
# Enabled hooks
#
HOOKS					=
"
],
	
	"72"	=>	[
"[ASTERISK]
#
AGI_MODE				= perl-worker
#
CONFERENCE_SERVER		= 
"
],
	
	"71"	=>	[
"[COMMON]
#
# default lang ( only for cgi-login page now )
#
DEFAULT_LANG			= xvb.EN-Female
"
],

	"70"	=>	[
"####################################################
# sip options
[SIP]
#
# REGISTRAR
REGISTRAR_IP				= 
REGISTRAR_NAME				= 
"
],
	"67"	=>	[
"####################################################
# TTS FEATURES 
[TTS]
# see http://msdn.microsoft.com/en-us/library/dd251020.aspx for more detail
MSTRANSLATOR_BINGID=
"
],
	"65"	=>	[
"####################################################
[TIMEOUT]
# UAC
MEM_CACHED_UAC_REG			= 7200
UAC_DEFAULT_EXPIRES			= 3600
UAC_REG_RETRY				= 90
UAC_REG_TTL					= 60

####################################################
[SIP]
# UAC
UAC_REG_RETRY_CNT			= 30
UAC_GW_IN					= 127.0.0.1
UAC_GW_OUT					= 10.1.1.1,192.168.6.1
UAC_TYPE					= ASTERISK
"
],

	"64"	=>	[
"####################################################
[TIMEOUT]
MEM_CACHED_CONNECT			= 0.25
MEM_CACHED_CONNECT_SHARED	= 0.4
"
],
	"62"	=>	[
"####################################################
# FILE formats
[FILE]
All_Sound_Formats		= wav|ul|al|ulaw|alaw|g722|gsm|wav16
"
],

	"61"	=>	[
"####################################################
# TTS FEATURES 
[TTS]
#SPEED_Festival_msu_ru_nsh_clunits = 1.05
#SPEED_Festival = 1.03
SPEED_GTranslate_RU = 1.08
#SPEED_GTranslate = 1.05
"
],

	"60"	=>	[
"####################################################
[TABLES]
DID_ATTR				= VPBX_DIDS_ATTR
"
],
	"59"	=>	[
"####################################################
[ASTERISK]
#
USE_CURL				= 0"
],
	"58"	=>	[
"####################################################
[TIMEOUT]
DB_TTL						= 3600
"
],
	"57"	=>	[
"####################################################
# GEARMAN 
#[GEARMAN]
#HOST=127.0.0.1:4730
#FUNC=radius_acct,notify_twitter,notify_email,notify_ga,gearman_cdr
"
],

	"56"	=>	[
"####################################################
[TABLES]
VBOX_PARAMS_29			= VPBX_VBOXES_INTERCOM
"
],

	"55"	=>	[
"####################################################
# sip options
[SIP]
#
# REGISTRAR
REGISTRAR					= "
],

	"54"	=>	[
"####################################################
# sip options
[SIP]
#REGISTRAR_TYPE             = SER / ASTERISK
REGISTRAR_TYPE              = SER"
],

	"53"	=>	[
"####################################################
[COMMON]
MEM_CACHED_SHARED		= '127.0.0.1:11211'"
],

	"52"	=>	[
"####################################################
[TABLES]
SIPPEERS_TEMPLATES		= VPBX_SIPPEERS_TEMPLATES
"
],

	"51"	=>	[
"####################################################
[TIMEOUT]
GOOGLE_DATA_TTL				= 300
GOOGLE_DATA					= 43200
GOOGLE_AUTH					= 864000"
],

	"49"	=>	[
"####################################################
[TABLES]
VBOX_PARAMS_28			= VPBX_VBOXES_GC_EXPLORER
"
],

	"48"	=>	[
"####################################################
[FEATURES]
TRANSIT_CALL		= 'xvb-t-record#xvb-t-bg-music-moh#xvb-t-bg-music-play'"
],

	"46"	=>	[
"####################################################
[TIMEOUT]
ICECAST_LEASE                         = 86400
ICECAST_NOLEASE                       = 600

[ASTERISK]
#                                     ices2 [ ogg ] / ezstream [ mp3 ]
ICECAST_FORMAT							= ices2

[PATH]
#ICECAST_DIR						= /opt/Virtual/etc/icecast/

[TABLES]
ICECAST_POOL                  = VPBX_ICECAST_POOL
"
],

	"45"	=>	[
"####################################################
#
# Asterisk options
#
[ASTERISK]
#
# VERISON 16 /18 ( 1.6 / 1.8 )
#
VERSION					= 18
USE_VOICECHANGER		= 0"
],
	
	"43"	=>	[
"####################################################
# CGI options
[CGI]
URL				= /ui"
],

	"42"	=>	[
"####################################################
# PATH description
[PATH]
SOUND_DIR			= /usr/share/asterisk/sounds/"
],

	"41"	=>	[
"####################################################
# TTS FEATURES 
[TTS]
USE_WAV_IF_POSIBLE = 1"
],

	"39"	=>	[
"####################################################
# FILE formats
[FILE]
All_Sound_Formats		= wav|ul|al|ulaw|alaw|g722|gsm"
],

	"38"	=>	[
"####################################################
[FEATURES]
DIALOUT				= 'xvb-transfer#xvb-record#xvb-hangup#xvb-bg-music-moh#xvb-bg-music-play#xvb-pitch'
QUEUES				= 'xvb-transfer#xvb-record#xvb-hangup#xvb-bg-music-moh#xvb-bg-music-play#xvb-pitch'"
],

	"35"	=>	[
"####################################################
[TIMEOUT]
GA_REQUEST			= 1"
],

	"34"	=>	[
"####################################################
#
[DEBUG]
#SEND_TO             = FILE,SYSLOG
SEND_TO             = FILE
FILE                = /var/log/VirtualPBX/XVB.log
HOST                = 127.0.0.1

####################################################
[TIMEOUT]
LOG_REOPEN			= 60"
],

	"33"	=>	[
"####################################################
#
[TABLES]
DIR_LANG				= VPBX_DIRECTORY_LANG"
],
	
	"32"	=>	[
"####################################################
#
# Asterisk options
#
[ASTERISK]
#
# allow Voice Changer. don't work with asterisk 1.6.2
#
USE_VOICECHANGER		= 1"
],

	"31"	=>	[
"####################################################
#
[TABLES]
CDRS_A					= VPBX_CDRS_ACTIVITY"
],

	"30"	=>	[
"####################################################
# Asterisk FEATURES 
[FEATURES]
DIALOUT				= 'xvb-transfer#xvb-record#xvb-hangup'
QUEUES				= 'xvb-transfer#xvb-record#xvb-hangup'
PARKING				= 'xvb-parking'"
],

	"29"	=>	[
"####################################################
# Asterisk FEATURES 
[FEATURES]
DIALOUT				= 'xvb-transfer#xvb-record#xvb-hangup'
QUEUES				= 'xvb-transfer#xvb-record#xvb-hangup'
PARKING				= 'xvb-parking'

####################################################
#
[TABLES]
VBOX_PARAMS_27			= VPBX_VBOXES_PARKING"
],

	"28"	=>	[
"####################################################
# Radius options
[RADIUS]
## accounting
#ACCT_HOST=127.0.0.1
#ACCT_SECRET=testing123
# send accounting events
##ACCT_SEND_EVENTS=1"
],

	"27"	=>	[
"####################################################
[TIMEOUT]
MEM_CACHED_PING				= 60"
],

	"26"	=>	[
"####################################################
# watchdogs th
[WATCHDOG]
TH					= 20
TH_VB				= 8
TH_VB_TIME			= 1"
],

	"25"	=>	[
"####################################################
#
[TABLES]
VBOX_PARAMS_1			= VPBX_VBOXES_PLAYBACK
VBOX_PARAMS_2			= VPBX_VBOXES_RECORD
VBOX_PARAMS_3			= VPBX_VBOXES_DIALOUT
VBOX_PARAMS_4			= VPBX_VBOXES_DIRECTORY
VBOX_PARAMS_5			= VPBX_VBOXES_SCHEDULE
VBOX_PARAMS_6			= VPBX_VBOXES_TTS
VBOX_PARAMS_7			= VPBX_VBOXES_CONFERENCE
VBOX_PARAMS_8			= VPBX_VBOXES_FAXRX
VBOX_PARAMS_9			= VPBX_VBOXES_DTMFRX
VBOX_PARAMS_10			= VPBX_VBOXES_VOTING
VBOX_PARAMS_11			= VPBX_VBOXES_DISA
VBOX_PARAMS_12			= VPBX_VBOXES_PODCAST
VBOX_PARAMS_13			= VPBX_VBOXES_QUEUES
VBOX_PARAMS_14			= VPBX_VBOXES_CALLBACK
VBOX_PARAMS_15			= VPBX_VBOXES_DATETIME
VBOX_PARAMS_16			= VPBX_VBOXES_FAXTX
VBOX_PARAMS_17			= VPBX_VBOXES_BBS
VBOX_PARAMS_18			= VPBX_VBOXES_CALLBLAST
VBOX_PARAMS_19			= VPBX_VBOXES_USERVAR
VBOX_PARAMS_20			= VPBX_VBOXES_WEBVAR
VBOX_PARAMS_21			= VPBX_VBOXES_GOTOIF
VBOX_PARAMS_22			= VPBX_VBOXES_DBVAR
VBOX_PARAMS_23			= VPBX_VBOXES_ALARMCLOCK
VBOX_PARAMS_24			= VPBX_VBOXES_GC_SCHEDULE
VBOX_PARAMS_25			= VPBX_VBOXES_ROBOTEXT
VBOX_PARAMS_26			= VPBX_VBOXES_STREAMING"
],

	"23"	=>	[
"####################################################
#
[TABLES]
VBOX_PARAMS_33554432    = VPBX_VBOXES_STREAMING"
],

	"22"	=>	[
"####################################################
#
# Asterisk options
#
[ASTERISK]
#
# Streaming method: Multi / Single / MultiServer
#
STREAMING_METHOD		= Multi"
],

	"21"	=>	[
"####################################################
#
# Asterisk options
#
[ASTERISK]
#
# PEER IP Function
#		CHANNEL(peerip) // SIPCHANINFO(peerip)
#
PEER_IP					= 'SIPCHANINFO(peerip)'
#
# Asterisk [TR]xFaxAPP: [RT]xFax, ReceiveFax, PIKARxFax
#
RxFax_App				= ReceiveFax
TxFax_App				= SendFax

#
# Dial Method dial/macro
#
DIAL_METHOD				= Macro"
],

	"20"	=>	[
"####################################################
#
# Asterisk options
#
[ASTERISK]
#
# Asterisk Version 1.4 == 14 / 1.6 == 16
#
VERSION					= 16
#
# Asterisk realtime for MOH
#
USE_REALTIME			= 1
#
# DELIMITER: '|' - for 1.4 ( and 1.6 in compat mode=1.4 ), ',' - for 1.6
#
PARAM_DELIMITER			= '|'"
],
	"19"	=>	[
"####################################################
[TABLES]
NOTIFY_TYPE				= VPBX_NOTIFY_TYPE"
],
	"18"	=>	[
"####################################################
[TABLES]
SAY_PATTERN				= VPBX_SAY_PATTERN
VBOX_PARAMS_16777216	= VPBX_VBOXES_ROBOTEXT"
],
	"17"	=>	[
"####################################################
[TABLES]
VBOX_PARAMS_8388608     = VPBX_VBOXES_GC_SCHEDULE"
],

	"16"	=>	[
"####################################################
[TABLES]
VBOX_PARAMS_4194304		= VPBX_VBOXES_ALARMCLOCK"
],

	"15"	=>	[
"####################################################
[TABLES]
VBOX_PARAMS_2097152     = VPBX_VBOXES_DBVAR"
],

	"13"	=>	[
"####################################################
[TABLES]
DID			= VPBX_DIDS

[TIMEOUT]
MEM_CACHED_PREAUTH	= 21600"
],

	"12"	=>	[
"####################################################
[TABLES]
VBOX_PARAMS_1048576		= VPBX_VBOXES_GOTOIF
VBOX_GOTOIF_DATA		= VPBX_VBOXES_GOTOIF_DATA"
],
	"11"	=>	[
"####################################################
[TABLES]
VBOX_PARAMS_524288		= VPBX_VBOXES_WEBVAR"
],
	"10"	=>	[
"####################################################
[TABLES]
VBOX_PARAMS_262144		= VPBX_VBOXES_USERVAR"
],
	"9"	=>	[
"####################################################
# CallBlast optinos
[CALLBLAST]
MAX_PHONES			= 3"
],

	"8"	=>	[
"####################################################
# timeout options
[TIMEOUT]
STAT						= 120"
],

	"7"	=>	[
"####################################################
# common options
[SIP]
#
# REGISTRAR
REGISTRAR					= 127.0.0.1"
],

	"6"	=>	[
"####################################################
# CallBlast optinos
[CALLBLAST]
CHECK_AMD			= 1
MAX_CALLS			= 150
LOAD_THRESHOLD		= 0.90
SLEEP				= 1.5
ATTEMPTS			= 3
CID					= 8478825729
RETRY_TIME			= 30
WAIT_TIME			= 30
RETRIES				= 3

[TIMEOUT]
MEM_CACHED_CALLBLAST		= 300"
],

	"4"	=>	[
"[TABLES]
VBOX_PARAMS_131072		= VPBX_VBOXES_CALLBLAST
VBOX_CALLBLAST_DATA		= VPBX_VBOXES_CALLBLAST_DATA"
],
	"3"	=>	[
"[TABLES]
CUSTOM_MOH				= VPBX_CUSTOM_MOH"
],
	"2"	=>	[
"[TABLES]
VBOX_BBS_DATA			= VPBX_VBOXES_BBS_DATA"	
	]
);

########################################################################
							main();
########################################################################

########################################################################
#
sub main {
	my $cur_version = '0';

	open( IN, '</opt/VirtualPBX/etc/xvb.cfg' ) || die "Can't open config file for read: $!";
	while ( <IN> ) {
		$cur_version = $1 if /CFG-VERSION=(\d+)/;
	}
	close(IN);

	my $start_time = localtime;

	print "Start update config ( from $cur_version to $VERSION ): $start_time...\n";

	if ( $cur_version ne $VERSION ) {
		system "cp /opt/VirtualPBX/etc/xvb.cfg /opt/VirtualPBX/etc/xvb.cfg-$cur_version";
		open( OUT, '>>/opt/VirtualPBX/etc/xvb.cfg' ) || die "Can't open config file for write: $!";
		foreach my $key ( sort { $a <=> $b } keys %update_data ) {
			next if $key <= $cur_version;
			foreach my $conf ( @{ $update_data{$key} } ) {
				print "Add=>: $conf\n\n";
				print OUT "\n$conf\n";
			}
		}
		close OUT;
	}

	my $stop_time = localtime;
	print "Complite update config: $stop_time...\n";
}

