-- drop database xvb;
create user 'xvb'@'localhost' identified by 'pass1xvb';

create database xvb CHARACTER SET utf8;
use xvb;

-- Reference books
create  table VPBX_DB_INFO
(
	VERSION	VARCHAR(100) not null,
	TIME	INT(16)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_SIPPEERS_TEMPLATES (
	ID					INT(16)  not null AUTO_INCREMENT,
	HOST				VARCHAR(255),
	NAME				VARCHAR(255),
	DATA				TEXT(8192),
	HIDE				INT(1) default 0,
    CONSTRAINT PK_VPBX_SIPPEERS_TEMPLATES PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_ICECAST_POOL (
	ID					INT(16)  not null AUTO_INCREMENT,

	LEASE_TIMESTAMP		INT(16),
	EXT_ID				INT(16),
	CONF_FILE			VARCHAR(255),
	URL					VARCHAR(255),

    unique (CONF_FILE),
    CONSTRAINT PK_VPBX_ICECAST PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_REPORTS (
	ID		INT(16)  not null AUTO_INCREMENT,
    
	NAME				VARCHAR(100),
	TYPE				INT(1) not null default 1,
	CREATE_TIMESTAMP	INT(16),
	QUERY				TEXT,
	TTL					INT(10) not null default 60,
	ACCESS_GROUPS		TEXT,
	ACCESS_ACCOUNTS		TEXT,

	DATE_START			VARCHAR(255),
	DATE_STOP			VARCHAR(255),

	POST_FILTER			TEXT,
	EXTRA_PARAMS		TEXT,

    CONSTRAINT PK_VPBX_REPORTS PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_DIRECTORY_LANG (
	ID					INT(16) NOT NULL,

	DESCRIPTION         VARCHAR(100),

	CH_2				VARCHAR(255),
	CH_3				VARCHAR(255),
	CH_4				VARCHAR(255),
	CH_5				VARCHAR(255),
	CH_6				VARCHAR(255),
	CH_7				VARCHAR(255),
	CH_8				VARCHAR(255),
	CH_9				VARCHAR(255),

    CONSTRAINT PK_SERVICE_DIR_LANG PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_DATE_FORMAT (
	ID					INT(16) NOT NULL,
	
	DATE_FORMAT_STR		VARCHAR(100),
	DESCRIPTION         VARCHAR(100),

    CONSTRAINT PK_SERVICE_DATE_FORMAT PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_NOTIFY_TYPE (
	NOTIFY_ID			INT(3) NOT NULL,
    
	NAME		        VARCHAR(100),
	DESCRIPTION         VARCHAR(100),

    CONSTRAINT PK_SERVICE_VBOX_NOTIFY PRIMARY KEY (NOTIFY_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_CURRENCY (
	CUR_ID				INT(16) NOT NULL,
    
	DESCRIPTION         VARCHAR(100),

	CONVERSION_RATE		FLOAT,

    CONSTRAINT PK_SERVICE_VBOX_CURRENCY PRIMARY KEY (CUR_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_TARIFF (
	ID INT(16) NOT NULL,
    
	NAME					 VARCHAR(100),

	MONTHLY_PRICE			FLOAT default 0,
	DAILY_PRICE				FLOAT default 0,
	
	BILLING_URL				VARCHAR(1024),

	MINUTE_PRICE_INCOMING	FLOAT default 0,
	MINUTE_PRICE_LOCAL		FLOAT default 0,
	MINUTE_PRICE_TRANSIT	FLOAT default 0,
	MINUTE_PRICE_INTERNAL	FLOAT default 0,
	MINUTE_PRICE_CALLBACK	FLOAT default 0,
	MINUTE_PRICE_CALLBLAST	FLOAT default 0,
	MINUTE_PRICE_CLICK2CALL	FLOAT default 0,
	MINUTE_PRICE_ALARMCLOCK FLOAT default 0,
	MINUTE_PRICE_SERVICE	FLOAT default 0,

	CALL_PRICE_INCOMING		FLOAT default 0,
	CALL_PRICE_LOCAL		FLOAT default 0,
	CALL_PRICE_TRANSIT 		FLOAT default 0,
	CALL_PRICE_INTERNAL		FLOAT default 0,
	CALL_PRICE_CALLBACK		FLOAT default 0,
	CALL_PRICE_CALLBLAST	FLOAT default 0,
	CALL_PRICE_CLICK2CALL	FLOAT default 0,
	CALL_PRICE_ALARMCLOCK	FLOAT default 0,
	CALL_PRICE_SERVICE		FLOAT default 0,

	MINUTE_PRICE_E_PLAYBACK		FLOAT default 0,
	MINUTE_PRICE_E_RECORDVMMESSAGES		FLOAT default 0,
	MINUTE_PRICE_E_DBVAR		FLOAT default 0,
	MINUTE_PRICE_E_FAXRX		FLOAT default 0,
	MINUTE_PRICE_E_USERVAR		FLOAT default 0,
	MINUTE_PRICE_E_ROBOTEXT		FLOAT default 0,
	MINUTE_PRICE_E_WEBREQUEST	FLOAT default 0,
	MINUTE_PRICE_E_INTERCOM		FLOAT default 0,
	MINUTE_PRICE_E_RECORD		FLOAT default 0,
	MINUTE_PRICE_E_DIALOUT		FLOAT default 0,
	MINUTE_PRICE_E_MULTIDIALOUT	FLOAT default 0,
	MINUTE_PRICE_E_PODCAST		FLOAT default 0,
	MINUTE_PRICE_E_VOTING		FLOAT default 0,
	MINUTE_PRICE_E_WEBVAR		FLOAT default 0,
	MINUTE_PRICE_E_FAXTX		FLOAT default 0,
	MINUTE_PRICE_E_STREAMING	FLOAT default 0,
	MINUTE_PRICE_E_BBS			FLOAT default 0,
	MINUTE_PRICE_E_CONFERENCE	FLOAT default 0,
	MINUTE_PRICE_E_GOOGLECALENDAREXPLORER		FLOAT default 0,
	MINUTE_PRICE_E_DATETIME		FLOAT default 0,
	MINUTE_PRICE_E_DISA			FLOAT default 0,
	MINUTE_PRICE_E_QUEUE		FLOAT default 0,
	MINUTE_PRICE_E_DTMFRX		FLOAT default 0,
	MINUTE_PRICE_E_DTMFTX		FLOAT default 0,
	MINUTE_PRICE_E_PAUSE		FLOAT default 0,
	
	CALL_PRICE_E_PLAYBACK		FLOAT default 0,
	CALL_PRICE_E_RECORDVMMESSAGES		FLOAT default 0,
	CALL_PRICE_E_DBVAR			FLOAT default 0,
	CALL_PRICE_E_FAXRX			FLOAT default 0,
	CALL_PRICE_E_USERVAR		FLOAT default 0,
	CALL_PRICE_E_ROBOTEXT		FLOAT default 0,
	CALL_PRICE_E_WEBREQUEST		FLOAT default 0,
	CALL_PRICE_E_INTERCOM		FLOAT default 0,
	CALL_PRICE_E_RECORD			FLOAT default 0,
	CALL_PRICE_E_DIALOUT		FLOAT default 0,
	CALL_PRICE_E_MULTIDIALOUT	FLOAT default 0,
	CALL_PRICE_E_PODCAST		FLOAT default 0,
	CALL_PRICE_E_VOTING			FLOAT default 0,
	CALL_PRICE_E_WEBVAR			FLOAT default 0,
	CALL_PRICE_E_CALLBACK		FLOAT default 0,
	CALL_PRICE_E_FAXTX			FLOAT default 0,
	CALL_PRICE_E_STREAMING		FLOAT default 0,
	CALL_PRICE_E_ALARMCLOCK		FLOAT default 0,
	CALL_PRICE_E_BBS			FLOAT default 0,
	CALL_PRICE_E_CONFERENCE		FLOAT default 0,
	CALL_PRICE_E_GOOGLECALENDAREXPLORER		FLOAT default 0,
	CALL_PRICE_E_DATETIME		FLOAT default 0,
	CALL_PRICE_E_DISA			FLOAT default 0,
	CALL_PRICE_E_QUEUE			FLOAT default 0,
	CALL_PRICE_E_DTMFRX			FLOAT default 0,
	CALL_PRICE_E_DTMFTX			FLOAT default 0,
	CALL_PRICE_E_PAUSE			FLOAT default 0,

	CURRENCY_ID			INT(16)	not null default 1,

    CONSTRAINT FK_VPBX_TARIFF_CURR FOREIGN KEY (CURRENCY_ID) REFERENCES VPBX_CURRENCY(CUR_ID) ON UPDATE CASCADE,
    CONSTRAINT PK_SERVICE_VBOX_TARIFF PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_DTMF_PATTERN
(
	ID 					INT(16) not null,
	DTMF_PATTERN        VARCHAR(32) not null,
    DESCRIPTION         VARCHAR(100),

    CONSTRAINT PK_SERVICE_VBOX_DTMF_PATTERN PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_SAY_PATTERN
(
	ID 					INT(16) not null,
	SAY_PATTERN	        VARCHAR(32) not null,
    DESCRIPTION         VARCHAR(100),

    CONSTRAINT PK_SERVICE_VBOX_SAY_PATTERN PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_TZ
(
	ID			        INT(16)		  not null,
	TZ_NAME             VARCHAR(100) not null,

    unique (ID),
    CONSTRAINT PK_SERVICE_VBOX_TZ PRIMARY KEY (TZ_NAME)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_LANG
(
	ID			        INT(16)		  not null,
	LANG_NAME           VARCHAR(100) not null,
	LANG_VOICE			VARCHAR(100) not null default 'NO-VOICE',
	LANG_LOCALE			VARCHAR(100),
    DESCRIPTION         VARCHAR(100),
	LANG_TTS_ENGINE		VARCHAR(50) not null default 'Festival',
	STATUS				INT(1) not null default 1,

    CONSTRAINT PK_SERVICE_VBOX_LANG PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOX_TYPE
(
	ID			        INT(16)		  not null,
	NAME                VARCHAR(100) not null,
    DESCRIPTION         VARCHAR(100),

    CONSTRAINT PK_SERVICE_VBOX_TYPE PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_RECORD_FTYPE
(
	ID				INT(16)		    not null,
	NAME                VARCHAR(100) not null,
    DESCRIPTION     VARCHAR(100),

    CONSTRAINT PK_VPBX_VBOXES_RECORD_FTYPE PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DIALOUT_TYPE
(
	ID			        INT(2)		  not null,
	NAME                VARCHAR(100) not null,
    DESCRIPTION         VARCHAR(100),

    CONSTRAINT PK_SERVICE_DIALOUT_TYPE PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_CID_TYPE
(
	ID				INT(4)		    not null,
    DESCRIPTION     VARCHAR(100),

    CONSTRAINT PK_VPBX_CID_TYPE PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_CID_ACTIONS
(
	ID				INT(4)		    not null,
    DESCRIPTION     VARCHAR(100),

    CONSTRAINT PK_VPBX_CID_ACTIONS PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- SEQUENCES
create table VPBX_SEQUENCES
(
	SEC_NAME		CHAR(50)		not null,
	SEC_VAL			INT(16)			UNSIGNED NOT NULL,

    CONSTRAINT PK_VPBX_SEQ PRIMARY KEY (SEC_NAME)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

delimiter //
CREATE 
DEFINER='xvb'@'localhost'
FUNCTION seq(seq_name char (50)) returns int
begin
	UPDATE VPBX_SEQUENCES SET SEC_VAL=last_insert_id(SEC_VAL+1) WHERE SEC_NAME=seq_name;
	RETURN last_insert_id();
end
//
delimiter ;

-- Sys tables
create	table VPBX_NODES
(
	NODE_ID					VARCHAR(100),
	NODE_IP					VARCHAR(255),
	DOWNLOAD_IP				VARCHAR(255),
	AMI_CREDS				VARCHAR(255),
	NODE_DESC				VARCHAR(255),
	NODE_LIMITS				VARCHAR(255),
	NODE_STAT_URL			VARCHAR(255),

    CONSTRAINT PK_VPBX_NODES PRIMARY KEY (NODE_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_GROUPS
(
	GROUP_ID	   				INT(16)  not null AUTO_INCREMENT,

	GROUP_NAME					VARCHAR(100),

	CONFERENCE_CONTEXT			VARCHAR(255) default 'xvb-conf-def',
	DIALOUT_CONTEXT				VARCHAR(255) default 'xvb-dialout-def',
	
	DIALOUT_DIRECT				INT(1) default 1,
	CUSTOM_ROUTE				INT(1) default 1,
	CUSTOM_REGS					INT(1) default 0,
	CUSTOM_FILES				INT(1) default 1,
	TTS_GREETING				INT(1) default 1,
	ALLOW_MACROS				INT(1) default 1,
	ALLOW_PHONES				INT(1) default 1,
	ALLOW_GA					INT(1) default 0,
	ALLOW_CTR					INT(1) default 0,
	ALLOW_API					INT(1) default 1,
	ALLOW_ICECAST				INT(1) default 1,
	ALLOW_EXTSTAT				INT(1) default 1,
	ADVANCED_CALLBLAST			INT(1) default 1,

	MAX_SIZE_MSGS				BIGINT(16) default 0,
	MAX_ALL_MSGS				INT(10) default 1000,
	MAX_EXTENSIONS				INT(10) default 100,
	MAX_EXT_CIDS				INT(10) default 200,
	MAX_ROUTES					INT(10) default 200,
	MAX_PEERS					INT(10) default 5,
	MAX_REGS					INT(10) default 5,
	MAX_PHONES					INT(10) default 10,
	MAX_MACROS					INT(10) default 100,
	MAX_TTS_LENGTH				INT(10) default 300,
	MAX_DIRECTORY_ITEMS			INT(10) default 150,
	MAX_SCHEDULE_ITEMS			INT(10) default 20,
	MAX_CALLBLAST_ITEMS			INT(10) default 30,
	MAX_GOTOIF_ITEMS			INT(10) default 20,
	MAX_PBOOK_ITEMS				INT(10) default 200,
	MAX_C2C_ITEMS				INT(5) default 5,
	MAX_EXT_CB_CALLS			INT(10) default 10,

	MAX_EXT_PHONES				INT(4) default 20,
	MAX_CB_PHONES				INT(4) default 3,

	MAX_CALLS_IN				INT(10) default 0,

	MAX_EXT_PODCAST				INT(4) default 10,
	MAX_GC_EVENTS				INT(5) default 30,

	MAX_MESSAGE_DURATION		INT(10) default 14400,
	MAX_GREET_DURATION			INT(10) default 14400,
	MAX_NAME_DURATION			INT(10) default 120,
	MAX_ANNOUNCEMENT_DURATION	INT(10) default 300,
	MAX_ANNOUNCEMENT_CALLER_DURATION	INT(10) default 300,
	MAX_RETRYDIAL_DURATION		INT(10) default 300,
	MAX_MOH_DURATION			INT(10) default 600,

	MAX_ATTACH_SIZE				INT(10) default 1000000,
	MAX_DOWNLOAD_SIZE			INT(10) default 300000,
	MAX_ROLES 					INT(10) default 3,

	SERVER_ID					VARCHAR(100) not null,

	TARIFF_ID					INT(16) not null default 1,

	SUB_TEMPLATE_DIR			VARCHAR(255),
	SUB_SOUND_DIR				VARCHAR(255),

	PREF_CODEC					VARCHAR(16),

	PREF_LANG					INT(16)	not null default 0,

	MAX_CALL_DURATION			INT(10)	not null default 0,

	PH_FEATURES					VARCHAR(255) not null default '*',

	HOOKS						VARCHAR(255) not null default '',

	ASR_ENGINE					VARCHAR(16),

	VBL_1 INT(10) not NULL default -1,
	VBL_2 INT(10) not NULL default -1,
	VBL_3 INT(10) not NULL default -1,
	VBL_4 INT(10) not NULL default -1,
	VBL_5 INT(10) not NULL default -1,
	VBL_6 INT(10) not NULL default -1,
	VBL_7 INT(10) not NULL default -1,
	VBL_8 INT(10) not NULL default -1,
	VBL_9 INT(10) not NULL default -1,
	VBL_10 INT(10) not NULL default -1,
	VBL_11 INT(10) not NULL default -1,
	VBL_12 INT(10) not NULL default -1,
	VBL_13 INT(10) not NULL default -1,
	VBL_14 INT(10) not NULL default -1,
	VBL_15 INT(10) not NULL default -1,
	VBL_16 INT(10) not NULL default -1,
	VBL_17 INT(10) not NULL default -1,
	VBL_18 INT(10) not NULL default -1,
	VBL_19 INT(10) not NULL default -1,
	VBL_20 INT(10) not NULL default -1,
	VBL_21 INT(10) not NULL default -1,
	VBL_22 INT(10) not NULL default -1,
	VBL_23 INT(10) not NULL default -1,
	VBL_24 INT(10) not NULL default 0,
	VBL_25 INT(10) not NULL default -1,
	VBL_26 INT(10) not NULL default -1,
	VBL_27 INT(10) not NULL default -1,
	VBL_28 INT(10) not NULL default 0,
	VBL_29 INT(10) not NULL default -1,
	VBL_30 INT(10) not NULL default -1,
	VBL_31 INT(10) not NULL default -1,
	VBL_32 INT(10) not NULL default -1,

    unique (GROUP_NAME),
    CONSTRAINT FK_VPBX_PREF_LANG FOREIGN KEY (PREF_LANG) REFERENCES VPBX_LANG(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_NODES FOREIGN KEY (SERVER_ID) REFERENCES VPBX_NODES(NODE_ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_TARIFF FOREIGN KEY (TARIFF_ID) REFERENCES VPBX_TARIFF(ID) ON UPDATE CASCADE,
    CONSTRAINT PK_VPBX_GROUPS PRIMARY KEY (GROUP_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_PARTNERS
(
	ID	            INT(16)		    not null AUTO_INCREMENT,
	NAME			VARCHAR(100)	not null,
	PASSWORD		VARCHAR(100)	not null,
	DESCRIPTION		VARCHAR(255),
	READ_ONLY		INT(1) 			default 0,
	DID_MNG			INT(1) 			default 0,
	TAG				VARCHAR(100)	unique,
	OPTIONS			TEXT(1024),

    unique			(NAME),
    CONSTRAINT PK_VPBX_PARTNER PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_PARTNERS_GROUP
(
	ID	            INT(16)		    not null AUTO_INCREMENT,
	GROUP_ID		INT(16)			not null,
	PARTNER_ID		INT(16)			not null,

    unique			(GROUP_ID,PARTNER_ID),
    CONSTRAINT PK_VPBX_PARTNER_GRID PRIMARY KEY (ID),
    CONSTRAINT FK_VPBX_PARTNER_GR_N FOREIGN KEY (GROUP_ID) REFERENCES VPBX_GROUPS(GROUP_ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_PARTNER_N FOREIGN KEY (PARTNER_ID) REFERENCES VPBX_PARTNERS(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_ACCOUNTS
(
	ID	            INT(16)		    not null AUTO_INCREMENT,
	GROUP_ID		INT(16)			not null,
	ACCESS_CODE		VARCHAR(100)		not null,
	VOICENUMBER		VARCHAR(100)		not null,
    STATUS		    INT(1)		    default 1,

	LANG			INT(16)			not null default 0,
	TZ_NAME         VARCHAR(100)	not null default 'GMT',
	FIRST_NAME		VARCHAR(255),
	LAST_NAME		VARCHAR(255),
	EMAIL			VARCHAR(255),

	LOGO_HREF		VARCHAR(255),
	CSS_HREF		VARCHAR(255),
	MSG_IN_PAGE		INT(10)			default 20,
    STATEMENTS	    VARCHAR(50),
	DEMO_MODE		INT(1) 			default 0,
	MSG_STORE_PERIOD VARCHAR(255)	not null default '0',
	
	SOUND_FORMAT	VARCHAR(5)		default 'wav',
	DATE_FORMAT		INT(16)			default 1,
	
	GA_ACCOUNT		VARCHAR(50),
	CID_URL			VARCHAR(255),
	
	CUSTOM_1		VARCHAR(100),

	I_DIGIT_TIMEOUT	FLOAT(4,2) not null default 1,

	CUSTOM_RULES	TEXT(4096),
	CUSTOM_VARS		TEXT(4096),

	DESCRIPTION		TEXT(1024),
	CREATE_TIME		TIMESTAMP default CURRENT_TIMESTAMP(),
	
	PARTNER_TAG		VARCHAR(100),
	PERMIT_WEB		VARCHAR(100)	default '',
    
	unique			(ACCESS_CODE),
    CONSTRAINT PK_VPBX_SUBSCRIPTION PRIMARY KEY (ID),
    CONSTRAINT FK_VPBX_LANG FOREIGN KEY (LANG) REFERENCES VPBX_LANG(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_TZ FOREIGN KEY (TZ_NAME) REFERENCES VPBX_TZ(TZ_NAME) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_DATE_FORMAT FOREIGN KEY (DATE_FORMAT) REFERENCES VPBX_DATE_FORMAT(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_GROUPS FOREIGN KEY (GROUP_ID) REFERENCES VPBX_GROUPS(GROUP_ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_MOH
(
	ID			        INT(16)	  not null,
	MOH_CLASS           VARCHAR(100) not null,
    DESCRIPTION         VARCHAR(100),
	GROUP_ID			INT(16) null,
    SUBSCR_ID			INT(16) null,

    CONSTRAINT FK_VPBX_MOH_GR FOREIGN KEY (GROUP_ID) REFERENCES VPBX_GROUPS(GROUP_ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_MOH_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
    CONSTRAINT PK_SERVICE_VBOX_MOH PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_DIDS_ATTR
(
	DID				VARCHAR(100)	not null,
	LANG_ID			INT(16)			not null default 0,

    unique			    (DID),
    CONSTRAINT FK_VPBX_DIDS_ATTR_LANG FOREIGN KEY (LANG_ID) REFERENCES VPBX_LANG(ID) ON UPDATE CASCADE,
    CONSTRAINT PK_VPBX_DIDS_ATTR PRIMARY KEY (DID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_DIDS
(
	ID	            INT(16)		    not null AUTO_INCREMENT,

    SUBSCR_ID		INT(16)     	not null,
	DID				VARCHAR(100)	not null,
	CHANNELS		INT(16)			not null default -1,
	CNAM			VARCHAR(255),

    unique			    (DID),
    CONSTRAINT FK_VPBX_DIDS_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
    CONSTRAINT PK_VPBX_DIDS PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_DIDS_SIPDOMAINS
(
	ID	            INT(16)		    not null AUTO_INCREMENT,

    SUBSCR_ID		INT(16)     	not null,
	DOMAIN			VARCHAR(255)	not null,

    unique			    (DOMAIN),
    CONSTRAINT FK_VPBX_DOMAINS_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
    CONSTRAINT PK_VPBX_DOMAINS PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_MACROS (
	ID		INT(16)  not null AUTO_INCREMENT,
    
	MACRO_NAME		VARCHAR(100),
	DATA			TEXT(4096),
	DESCRIPTION		VARCHAR(255),
    SUBSCR_ID		INT(16)     not null,

	unique(SUBSCR_ID,MACRO_NAME),

    CONSTRAINT FK_VPBX_MACRO_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
    CONSTRAINT PK_VPBX_REPORTS PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_BALANCE
(
    SUBSCR_ID		INT(16)     not null,

	BALANCE			FLOAT		default 0,

    CONSTRAINT FK_VPBX_BALANCE_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_AST_CONFIG (
	id INT(16) NOT NULL AUTO_INCREMENT,
	cat_metric int(4) NOT NULL DEFAULT 0,
	var_metric int(4) NOT NULL DEFAULT 0,
	filename varchar(128) NOT NULL DEFAULT '',
	category varchar(128) NOT NULL DEFAULT 'default',
	var_name varchar(128) NOT NULL DEFAULT '',
	var_val varchar(128) NOT NULL DEFAULT '',
	commented int(2) NOT NULL DEFAULT 0,
	
	PRIMARY KEY (id),
	INDEX I_AST_CONFIG (filename(128),category(128))
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_CUSTOM_MOH
(
    SUBSCR_ID			INT(16)     not null,

    name				VARCHAR(50)		not null,
	mode				VARCHAR(20) 	not null default 'files',
	directory			VARCHAR(255)	not null,

    CONSTRAINT FK_VPBX_C_MOH_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
	INDEX I_MOH_CUSTOM (name)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_CLICK2CALL (
	ID					INT(16) not null AUTO_INCREMENT,
    
	SUBSCR_ID			INT(16) not null,
	EXTENSION			VARCHAR(255) default '0',
	SECRET				VARCHAR(100) not null,
	CALL_LIMIT			INT(10) default 0,

    unique (SUBSCR_ID,SECRET),
    CONSTRAINT FK_VPBX_CLICK2CALL_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
    CONSTRAINT PK_VPBX_CLICK2CALL PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_SIPPEERS (
	DATA_ID INT(16) NOT NULL AUTO_INCREMENT,

	name VARCHAR(100) NOT NULL,

	deny varchar(95) DEFAULT NULL,
	permit varchar(95) DEFAULT NULL,

	host VARCHAR(255) NOT NULL DEFAULT '',
	port VARCHAR(5) NOT NULL DEFAULT '5060',
	username VARCHAR(80) NOT NULL DEFAULT '',
	secret VARCHAR(80) DEFAULT NULL,

	fromuser VARCHAR(255) DEFAULT NULL,
	fromdomain VARCHAR(255) DEFAULT NULL,
	
	insecure VARCHAR(255) DEFAULT NULL,
	ipaddr VARCHAR(45) NOT NULL DEFAULT '',
	regseconds INT(11) NOT NULL default '0',
	type VARCHAR(6) NOT NULL DEFAULT 'peer',
	lastms VARCHAR(20) DEFAULT NULL,

	transport ENUM('udp','tcp') not null default 'udp',
	dtmfmode  ENUM('rfc2833','info','shortinfo','inband','auto') not null DEFAULT 'auto',

	context VARCHAR(50) NOT NULL DEFAULT 'xvb-phones',
	setvar  VARCHAR(1024) DEFAULT NULL,

	defaultuser varchar(80) NOT NULL default '',
	fullcontact varchar(160) NOT NULL DEFAULT '',
	regserver varchar(100) default NULL,
	useragent varchar(60) default NULL,
	qualify   varchar(5) default NULL,

	videosupport		enum('yes','no','always') DEFAULT 'yes',
	nat					varchar(5) DEFAULT NULL,
	rtptimeout			char(5) DEFAULT NULL,
	disallow			varchar(100) DEFAULT NULL,
 	allow				varchar(100) DEFAULT NULL, 
	progressinband		enum('never','yes','no') DEFAULT NULL,
	promiscredir		enum('yes','no') DEFAULT NULL,
	`session-timers`	enum('originate','accept','refuse') DEFAULT 'accept',
	`session-expires`	int(5) unsigned DEFAULT '1800',
	`session-minse`		int(5) unsigned DEFAULT '90',
	`session-refresher`	enum('uac','uas') DEFAULT 'uas', 
 	callbackextension	varchar(100) DEFAULT NULL, 

	callerid		VARCHAR(80) 	NOT NULL DEFAULT '',
    SUBSCR_ID		INT(16)			not null,
    DESCRIPTION     VARCHAR(100)	not null,

	REC_MODE		INT(1)			not null default 0,
	DND				INT(11)			default 0,
	REC_EXT			VARCHAR(255)	not null default '0',
	EMAIL			VARCHAR(255)	default '',
	FWD_NUM			VARCHAR(50)		default '',
	EXTERNAL_NUM	VARCHAR(50)		default '',
	FWD_AFTER		INT(6)			default 0,
	WEB_SECRET		VARCHAR(50)		default '',
	MANAGER_FOR		VARCHAR(512)	default '',
	LD_TTL			INT(6)			default 0,

	HOTDESK_PIN		VARCHAR(50)		default '',
	HOTDESK_CID		VARCHAR(80)		default '',

	NEED_REG		INT(1)			not null default 0,
	REG_EXPIRE		INT(6)			not null default 0,
	REG_USERNAME	VARCHAR(80)		NOT NULL DEFAULT '',
	REG_AUTHNAME	VARCHAR(80)		NOT NULL DEFAULT '',
	REG_TIME		INT(11)			NOT NULL default 0,
	REG_NODE		VARCHAR(255)	default '',
	INC_EXT			VARCHAR(255)	not null default '0',
	PICKUP_GROUPS	VARCHAR(255)	not null default '',
	PEER_TYPE		INT(1)			not null default 0,

	DEFCID			VARCHAR(80) 	default '',
	CO_LIMIT		INT(5)			not null default 0,
	LANG_ID			INT(16)			not null default 0,
	PERMIT_WEB		VARCHAR(100)	default '',
	CUSTOM_VARS		VARCHAR(255)	default '',
	EXT				VARCHAR(80) 	NOT NULL DEFAULT '',

	unique(name),
    CONSTRAINT FK_VPBX_PHONES_LANG FOREIGN KEY (LANG_ID) REFERENCES VPBX_LANG(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_SIPPPERS_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,

	PRIMARY KEY (DATA_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_PHONE_BOOK
(
    SUBSCR_ID		INT(16)			not null,
	DATA_ID			INT(16)			not null AUTO_INCREMENT,
	SHORTCUT		VARCHAR(50),
	PHONE			VARCHAR(255)	not null,
	FIRST_NAME		VARCHAR(100)	not null,
	LAST_NAME		VARCHAR(100)	not null,
	DESCRIPTION		VARCHAR(255),
	
	CRM_CUSTOMER_ID	INT(16),
	RESPONSIBLE		VARCHAR(255),
	
	PHONE_OWNER		INT(16),
    
	CONSTRAINT FK_VPBX_PBOOK_PHONE FOREIGN KEY (PHONE_OWNER) REFERENCES VPBX_SIPPEERS(DATA_ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_PBOOK_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
	CONSTRAINT PK_VPBX_PBOOK_DATA PRIMARY KEY (DATA_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

CREATE OR replace view VPBX_SIPPEERS_PHONES 
	as
select
	*
from
	VPBX_SIPPEERS
where PEER_TYPE = 0;

CREATE OR replace view VPBX_SIPPEERS_PEERS
	as
select
	*
from
	VPBX_SIPPEERS
where PEER_TYPE = 1;

create table VPBX_ROUTES (
	DATA_ID			INT(16) NOT NULL AUTO_INCREMENT,
    SUBSCR_ID		INT(16)   not null,
    PEER_ID			INT(16)   not null,
	
	PRIORITY		INT(6)    default 5,
	PATTERN         VARCHAR(100) not null,
	SUBSTR          VARCHAR(100),
    DESCRIPTION     VARCHAR(100),
	EXT_NUMBER		VARCHAR(255),
	TLIMIT			INT(6) default 0,
	DEFCID			VARCHAR(80) default '',
	SCHEDULE_EXT	VARCHAR(255) default '',
	LAST_ROUTE		INT(1) default 0,
	
    CONSTRAINT FK_VPBX_ROUTES_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_ROUTES_PEER FOREIGN KEY (PEER_ID) REFERENCES VPBX_SIPPEERS(DATA_ID) ON DELETE CASCADE,

	PRIMARY KEY (DATA_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_ROUTES_AI (
	DATA_ID			INT(16) NOT NULL AUTO_INCREMENT,
	
	PRIORITY		INT(6)    default 5,
    PEER			VARCHAR(100),
	PATTERN         VARCHAR(100) not null,
	SUBSTR          VARCHAR(100),
    DESCRIPTION     VARCHAR(100),
	EXT_NUMBER		VARCHAR(255),
	DEFCID			VARCHAR(80) default '',
	LAST_ROUTE		INT(1) default 0,
	
	PRIMARY KEY (DATA_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_ROUTES_TEMPLATES (
	ID					INT(16) NOT NULL AUTO_INCREMENT,
	
	PATTERN				VARCHAR(255),
	NAME				VARCHAR(255),

	PRIMARY KEY (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- VB data tables
create	table VPBX_VBOXES_CORE
(
	ID				INT(16)		    not null AUTO_INCREMENT,
    SUBSCR_ID		INT(16)          not null,

	PIN_CODE		VARCHAR(100),
	PIN_CODE2		VARCHAR(100),
	EXT_NUMBER		VARCHAR(255)	not null,
	TYPE            INT(16),
	CID				INT(4)	not null default 0,
	CID_ACTION		INT(4)	not null default 0,
	NAME            VARCHAR(255),
	GREETING        TEXT(1024),

	NEXTEXTENSION   VARCHAR(255) default 'hangup',
	WAITEXTENSION   INT(1) default 0,
	HIDDEN		    INT(1) default 0,
	DIRECT		    INT(1) default 0,
	PROTECT		    INT(1) default 0,
	GLOBAL		    INT(1) default 0,
	GREETING_CONTROL INT(1) default 1,
	LANG_ID			INT(16)	not null default 0,
	
	VOLUME_RX		INT(4)	not null default 0,
	VOLUME_TX		INT(4)	not null default 0,
	
	PITCH_TX		FLOAT(3,2)	not null default 1,
	PITCH_RX		FLOAT(3,2)	not null default 1,

	SENDNOTIFYEMAIL	INT(3) not null default 0,
	NOTIFYEMAIL	    VARCHAR(255),

	GREET_REPEAT_CNT	INT(4) not null default 1,
	GREET_REPEAT_DELAY	FLOAT(5,2) not null default 0,

	unique(SUBSCR_ID,EXT_NUMBER),
    CONSTRAINT PK_VPBX_VBOXES PRIMARY KEY (ID),
    CONSTRAINT FK_VPBX_VBOXES_LANG FOREIGN KEY (LANG_ID) REFERENCES VPBX_LANG(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_CID FOREIGN KEY (CID) REFERENCES VPBX_CID_TYPE(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_CID_A FOREIGN KEY (CID_ACTION) REFERENCES VPBX_CID_ACTIONS(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_TYPE FOREIGN KEY (TYPE) REFERENCES VPBX_VBOX_TYPE(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VBOX_VBOXES_NOTIFY FOREIGN KEY (SENDNOTIFYEMAIL) REFERENCES VPBX_NOTIFY_TYPE(NOTIFY_ID) ON UPDATE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_PLAYBACK
(
	ID			INT(16)		    not null,

	GREETING_TAGS	VARCHAR(255),

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_PLAYBACK FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_RECORD
(
	ID					INT(16)		    not null,

	MAX_MSG_DURATION	INT(10)			not null default -1,
	MIN_MSG_DURATION	INT(10)			not null default -1,
	KEEP_MSG			INT(1)			not null default 1,
	SEND_ATTACH			INT(1)			not null default 1,
	WO_CONFIRM			INT(1)			not null default 0,
	REC_SESSION			INT(1)			not null default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_RECORD FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_RECORD_FILES
(
	ID				INT(16)		    not null,
	FILE_ID			INT(16)		    not null AUTO_INCREMENT,
	FILE_TYPE		INT(3)			not null,

	FILE_NAME		VARCHAR(100)	not null,
	FILE_SIZE		INT(16)			not null,
	DURATION		INT(16),
	CALLERID		VARCHAR(100),
	CALLEDID		VARCHAR(255),
	CREATE_TIME		INT(16),
	CHANGE_TIME		INT(16),
	CALL_ID			VARCHAR(32),

	SERVER_ID		VARCHAR(100) not null,

	IS_VOICE		INT(1) not null default 0,

	unique(ID,FILE_NAME),

    CONSTRAINT PK_VPBX_VBOXES_RECORD_FILES PRIMARY KEY (FILE_ID),
    CONSTRAINT FK_VPBX_VBOXES_RECORD_FNODE FOREIGN KEY (SERVER_ID) REFERENCES VPBX_NODES(NODE_ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_RECORD_FILES FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_RECORD_FTYPE FOREIGN KEY (FILE_TYPE) REFERENCES VPBX_VBOXES_RECORD_FTYPE(ID) ON UPDATE CASCADE,
	
	INDEX I_RECORD_FILE_CALLERID (CALLERID),
	INDEX I_RECORD_FILE_CALLEDID (CALLEDID),
	INDEX I_RECORD_FILE_CALL_ID (CALL_ID),
	INDEX I_RECORD_FILE_START_T (CREATE_TIME,ID),
	INDEX I_RECORD_FILE_ID_START_T (ID,CREATE_TIME),
	INDEX I_RECORD_FILE_IDT (ID,FILE_TYPE),
	INDEX I_RECORD_FILES_ID (ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DIALOUT
(
	ID				INT(16)		    not null,
	CALL_NUMBER		VARCHAR(1024)	not null default 'OOS',
	RECORD_IF_FAIL	INT(1)			default 1,
	RECORD_CALL		INT(1)			default 0,
	KEEP_MSG		INT(1)			default 1,
	SEND_ATTACH		INT(1)			default 0,
	CALL_TYPE		INT(2)			default 1,
	CONFIRM_CALL	INT(1)			default 0,
	SCREENING_MODE	INT(1)			default 0,
	SAY_CALLERID	INT(1)			default 0,
	RING_TIMEOUT	INT(3)			default 30,
	TRANSFER_PREF	VARCHAR(255),
	SEND_DIGITS		VARCHAR(255),
	GOTO_IF_FAIL	VARCHAR(255),
	
	GOTO_IF_CALL_STATUS				VARCHAR(255),
	
	PARKING_EXT		VARCHAR(255),

	RETRYDIAL_INTERVAL INT(3)		default 0,
	RETRYDIAL_LOOPS INT(6)			default -1,

	MOH_ID			INT(16)			not null default 0,
	FMC				VARCHAR(255),

	MISS_CALL_ALERT	INT(1)			default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_DIALOUT FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_DIALOUT_MOH FOREIGN KEY (MOH_ID) REFERENCES VPBX_MOH(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_DIALOUT_TYPE FOREIGN KEY (CALL_TYPE) REFERENCES VPBX_VBOXES_DIALOUT_TYPE(ID) ON UPDATE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DIALOUT_DATA
(
	ID			        INT(16)		not null,
	PHONE_NUMBER		VARCHAR(255)	not null,

	TIMESTAMP			INT(16),
	CALLS				INT(16),
	ANSWERED			INT(16),
	DURATION			INT(16),
	RING_TIME			INT(16),
	
	CREATE_TIMESTAMP	INT(16),

	unique(ID,PHONE_NUMBER),
    CONSTRAINT FK_VPBX_VBOXES_DIALOUT_DATA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_QUEUES
(
	ID					INT(16)		    not null,
	CALL_NUMBER			VARCHAR(1024)	not null default 'OOS',
	CALL_TYPE			INT(2)			default 1,
	Q_TIMEOUT			INT(3)			default 120,
	ANNOUNCE_HOLDTIME	INT(1)			default 0,
	ANNOUNCE_POSITION	INT(1)			default 0,
	ANNOUNCE_FREQUENCY	INT(6)			default -1,
	RING_TIMEOUT		INT(3)			default 10,
	GOTO_IF_FAIL		VARCHAR(255),
	MOH_ID				INT(16)			not null default 0,
	RECORD_CALL			INT(1)			default 0,
	RECORD_RINGS		INT(1)			default 0,
	KEEP_MSG			INT(1)			default 1,
	SEND_ATTACH			INT(1)			default 0,
	WAIT_BUSY_ONLY		INT(1)			default 1,
	TRANSFER_PREF		VARCHAR(255),
	CALLERID_NAME		VARCHAR(100),
	CALLERID_NUM		VARCHAR(100),
	Q_URL				TEXT(1024),
	Q_INIT_URL			TEXT(1024),
	Q_ANSWERED_URL		TEXT(1024),
	MISS_CALL_URL		TEXT(1024),
	ANSW_CALL_URL		TEXT(1024),
	PARKING_EXT			VARCHAR(255),
	Q_MAX_W_CALLS		INT(3)			default 0,
	WRAPUPTIME			INT(6)			default 0,
	JOINEMPTY			INT(1)			default 0,
	REMEMBER_AGENT		INT(1)			default 0,
	MISS_CALL_ALERT		INT(1)			default 0,
	WAIT_NOTES			INT(1)			default 0,
	DEVICE_STATE		INT(1)			default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_QUEUES FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_QUEUES_MOH FOREIGN KEY (MOH_ID) REFERENCES VPBX_MOH(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_QUEUES_TYPE FOREIGN KEY (CALL_TYPE) REFERENCES VPBX_VBOXES_DIALOUT_TYPE(ID) ON UPDATE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_CALLBACK
(
	ID					INT(16)		    not null,
	CB_NUMBER			VARCHAR(255),
	CB_EXT				VARCHAR(255),
	CB_USE_TIMEOFFSET	INT(1)			default 0,
	CB_DYNAMIC_EXT		INT(1)			default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_CB FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_ALARMCLOCK
(
	ID					INT(16)		    not null,
	AC_CB_NUMBER		VARCHAR(255),
	AC_AUTO_REMOVE		INT(1)			default 1,
	
	RING_TIMEOUT		INT(3)			default 30,
	RETRYDIAL_INTERVAL	INT(3)			default 0,
	RETRYDIAL_LOOPS		INT(6)			default 1,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_ALARMCLOCK FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_GC_SCHEDULE
(
	ID					INT(16)		    not null,

	GOTO_IF_OK			VARCHAR(255)	not null default '0',
	GOTO_IF_BUSY		VARCHAR(255)	not null default '0',

	GOOGLE_CALENDAR		VARCHAR(255),
	GOOGLE_USER			VARCHAR(255),
	GOOGLE_PSWD			VARCHAR(255),
	
	GOOGLE_E_Q			VARCHAR(255),
	GOOGLE_E_CATEGORY	VARCHAR(255),
	GOOGLE_E_AUTHOR		VARCHAR(255),

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_GC_SCHEDULE FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_GC_EXPLORER
(
	ID					INT(16)		    not null,

	GOOGLE_CALENDAR			VARCHAR(255),
	GOOGLE_USER				VARCHAR(255),
	GOOGLE_PSWD				VARCHAR(255),
	
	GOOGLE_E_Q				VARCHAR(255),
	GOOGLE_E_CATEGORY		VARCHAR(255),
	GOOGLE_E_AUTHOR			VARCHAR(255),
	
	GOOGLE_START_DAYS_OFFSET	INT(4) not null default 0,
	GOOGLE_STOP_DAYS_OFFSET		INT(4) not null default 1,
	
	TIME_FORMAT					INT(1) not null default 0,
	ACCESS_MODE					INT(1) not null default 0,
	GOOGLE_MAX_EVENTS			INT(5) not null default 30,
	

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_GC_EXPLORER FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DIRECTORY
(
	ID					INT(16)		    not null,
	USE_FIRSTNAME		INT(1)			default 0,
	USE_TTS_NAME		INT(1)			default 0,
	USE_VOICE_SEARCH	INT(1)			default 0,
	KEY_LEN				INT(4)			not null default 3,

	DIR_LANG			INT(16)			not null default 0,
	DIR_HELPEXT			VARCHAR(255),

	unique(ID),
 
	CONSTRAINT FK_VPBX_DIR_LANG FOREIGN KEY (DIR_LANG) REFERENCES VPBX_DIRECTORY_LANG(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_DIRECTORY FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DIRECTORY_DATA
(
	ID			        INT(16)		  not null,

	DATA_ID				INT(16)		  not null AUTO_INCREMENT,
	NAME                VARCHAR(255) not null,
    REDIRECT_TO         VARCHAR(255) not null,

	unique(DATA_ID),
    CONSTRAINT FK_VPBX_VBOXES_DIRECTORY_DATA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DATETIME
(
	ID				INT(16)		    not null,
	
	TZ_NAME         VARCHAR(100)	not null default 'Default',
	TIME_FORMAT		INT(1)			default 0,
	
	unique(ID),
    CONSTRAINT FK_VPBX_DT_TZ FOREIGN KEY (TZ_NAME) REFERENCES VPBX_TZ(TZ_NAME) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_DT FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_SCHEDULE
(
	ID				INT(16)		    not null,
	
	TZ_NAME         VARCHAR(100)	not null default 'Default',
	
	unique(ID),
    CONSTRAINT FK_VPBX_SC_TZ FOREIGN KEY (TZ_NAME) REFERENCES VPBX_TZ(TZ_NAME) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_SCHEDULE FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_SCHEDULE_DATA
(
	ID			        INT(16)			not null,

	DATA_ID				INT(16)			not null AUTO_INCREMENT,

	PRIORITY			INT(6)			default 5,

	CALLERID			VARCHAR(100)	default '*',
	TIME_H				VARCHAR(100)	default '*',
	DAYOFWEEK			VARCHAR(100)	default '*',
	DAYOFMONTH			VARCHAR(100)	default '*',
	MONTH				VARCHAR(100)	default '*',
	YEAR				VARCHAR(100)	default '*',

	REDIRECT_TO         VARCHAR(255)	not null,

	unique(DATA_ID),
    CONSTRAINT FK_VPBX_VBOXES_SCHEDULE_DATA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_TTS
(
	ID				INT(16)		    not null,

	MOH_ID			INT(16)			not null default 0,
	TTS_URL			VARCHAR(1024)	not null default '',
	TTS_METHOD		VARCHAR(10)	default 'GET',
	TTS_POST_PARAMS	TEXT(2048),

	TTS_REQ_HEADERS	TEXT(1024),
	TTS_REQ_UA		TEXT(1024),

	GOTO_IF_FAIL	VARCHAR(255),
	NEED_PARAMS		INT(1) not null default 0,
	NO_WAIT			INT(1) not null default 0,
	TTS_REPEAT_CNT	INT(8) not null default 1,
	TTS_C_TYPE		VARCHAR(255)	default '',

	unique(ID),

	CONSTRAINT FK_VPBX_VBOXES_TTS_MOH FOREIGN KEY (MOH_ID) REFERENCES VPBX_MOH(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_TTS FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_CONFERENCE
(
	ID					INT(16)		    not null,
	SHARE_VIA_ICECAST	INT(1)			not null default 0,
	RECORD_CALL			INT(1)			default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_CONFERENCE FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_INTERCOM
(
	ID				INT(16)		    not null,
	CALL_NUMBER		VARCHAR(1024)	not null default 'OOS',
	PAGING			INT(1)			default 0,
	TIME_LIMIT		INT(8)			default 30,
	ALERT_INFO		VARCHAR(50),
	CALL_INFO		VARCHAR(255),
	RECORD_CALL		INT(1)			default 0,
	KEEP_MSG		INT(1)			default 1,
	SEND_ATTACH		INT(1)			default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_INTERCOM FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DTMFRX
(
	ID					INT(16)		    not null,

	MAX_DIGITS			INT(10)			not null default -1,
	KEEP_MSG			INT(1)			not null default 1,
	SEND_ATTACH			INT(1)			not null default 1,
	DTMF_PATTERN_ID		INT(16) 		not null default 0,
	NEED_FORMATED		INT(1) 			not null default 1,
	VAR_NAME            VARCHAR(255) 	not null,
	OTHER_VARS          VARCHAR(1024) 	not null,

	unique(ID),

	CONSTRAINT FK_VPBX_VBOXES_DTMF_PTRN FOREIGN KEY (DTMF_PATTERN_ID) REFERENCES VPBX_DTMF_PATTERN(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_DTMFRX FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DTMFTX
(
	ID					INT(16)		    not null,

	DIGITS				VARCHAR(255)	not null,
	TIMEOUT				INT(5)			not null default 250,
	DURATION			INT(5)			not null default 150,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_DTMFTX FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_FAXRX
(
	ID					INT(16)		    not null,

	KEEP_MSG			INT(1)			not null default 1,
	SEND_ATTACH			INT(1)			not null default 1,
	HEADERINFO			VARCHAR(255),

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_FAXRX FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_FAXTX
(
	ID			INT(16)		    not null,

	HEADERINFO			VARCHAR(255),
	FAX_URL				TEXT(1024),

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_FAXTX FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_BBS
(
	ID			INT(16)		    		not null,

	MAX_MSG_DURATION	INT(10)			not null default -1,
	MIN_MSG_DURATION	INT(10)			not null default -1,
	SECRET_KEY			VARCHAR(50),
	MSG_LIMITS			INT(16)			not null default 0,	
	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_BBS FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_BBS_DATA
(
	ID					INT(16)		    not null,
	CALLER_ID			VARCHAR(100),

	CREATE_TIMESTAMP	INT(16),

    CONSTRAINT FK_VPBX_VBOXES_BBS_DATA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE,

	INDEX I_BBS_CALLER_ID (ID,CALLER_ID)

) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_VOTING
(
	ID					INT(16)	not null,

	ALLOW_DIGITS		VARCHAR(255)	not null,
	UNIQ_CIDS			INT(1)			not null default 1,
	VAR_NAME            VARCHAR(255),
	
	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_VOTING FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_VOTING_DATA
(
	ID					INT(16)		    not null,
	DIGITS				INT(10),
	CALLER_ID			VARCHAR(100),

	CREATE_TIMESTAMP	INT(16),

    CONSTRAINT FK_VPBX_VBOXES_VOTING_DATA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE,

	INDEX I_VOTING_CALLER_ID (ID,CALLER_ID)

) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_DISA
(
	ID				INT(16)		    not null,
	MOH_ID			INT(16)			not null default 0,
	RECORD_CALL		INT(1)			default 0,
	KEEP_MSG		INT(1)			default 1,
	SEND_ATTACH		INT(1)			default 0,
	PHONE_PATTERN	VARCHAR(255),	
	PHONE_NUMBER	VARCHAR(255),	
	MAX_DIGITS		INT(10)			not null default -1,
	RING_TIMEOUT	INT(3)			default 30,
	PHONE_MODE		INT(1)			default 0,
	CALLERID_NUM	VARCHAR(100),
	GOTO_IF_FAIL	VARCHAR(255),

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_DISA_MOH FOREIGN KEY (MOH_ID) REFERENCES VPBX_MOH(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_DISA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_PODCAST
(
	ID						INT(16)	    not null,
	PODCAST_ANNOUNCEMENT	INT(1)		not null default 1,
	PODCAST_URL				VARCHAR(512)	not null default '',
	ONLY_LATEST				INT(1)		not null default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_PODCAST FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_PODCAST_DATA
(
	ID			        INT(16)		not null AUTO_INCREMENT,
	PODCAST_URL			VARCHAR(512)	not null default '',
	FILE_NAME			VARCHAR(255)	not null,
	FILE_SIZE			INT(16)		not null,
	DURATION			INT(16),
	CREATE_TIMESTAMP	INT(16),
	DOWNLOAD_TIMESTAMP	INT(16),
	DROP_TIMESTAMP		INT(16),
	SERVER_ID			VARCHAR(100) not null,
	TITLE				TEXT(2048),
	FILE_URL			TEXT(512),
    
	CONSTRAINT PK_PODCAST_DATA PRIMARY KEY (ID),
    CONSTRAINT FK_VPBX_VBOXES_PODCAST_NODES FOREIGN KEY (SERVER_ID) REFERENCES VPBX_NODES(NODE_ID) ON UPDATE CASCADE,
	INDEX P_FILES (PODCAST_URL(512))
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_CALLBLAST
(
	ID				INT(16)		    not null,

	START_TIMESTAMP	INT(16),
	START_DATE		VARCHAR(50),
	STOP_TIMESTAMP	INT(16),
	STOP_DATE		VARCHAR(50),
	TZ_NAME         VARCHAR(100)	not null default 'Default',
	ACTIVE			INT(1)			not null default 0,
	
	START_AFTER_CHANGE	INT(1)			not null default 0,
	
	RING_TIMEOUT		INT(3)			default 30,
	RETRYDIAL_INTERVAL	INT(3)			default 1,
	RETRYDIAL_LOOPS		INT(6)			default 0,
	CALL_LIMIT			INT(3)			default 0,
	MIN_CALL_DURATION	INT(16)			default 0,
	RECORD_CALL			INT(1)			default 0,
	USE_AMD				INT(1)			default 0,
	FA_DETECT			INT(3)			default 0,
	
	AMD_OPT					VARCHAR(100),
	DEPEND_QUEUE			VARCHAR(255),
	DEPEND_QUEUE_CAPACITY	FLOAT(4,2) default 1,

	WAIT_NOTES			INT(1)		default 0,
	DTMF_LOG			INT(1)		default 0,
	URL_SUCCESS			TEXT(1024),
	
	CALLBACK_EXT		VARCHAR(255),
	CALLBACK_TTL		INT(6),

	URL_STATE			TEXT(1024),
	STATE				INT(1)		default 0,

	unique(ID),

	INDEX I_CB_START_T (START_TIMESTAMP),
	INDEX I_CB_STATUS (ACTIVE),

	CONSTRAINT FK_VPBX_CB_TZ FOREIGN KEY (TZ_NAME) REFERENCES VPBX_TZ(TZ_NAME) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_CALLBLAST FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_CALLBLAST_DATA
(
	ID			        INT(16)		 not null,

	DATA_ID				INT(16)		 not null AUTO_INCREMENT,
	NAME                VARCHAR(255) not null,
    PHONE_NUMBER		VARCHAR(255) not null,
	USER_VARS			VARCHAR(255),

	CREATE_TIMESTAMP	INT(16) not null,
	PROCESS_TIMESTAMP	INT(16) not null default 0,

	CALL_STATUS			CHAR(22) not null default 'wait',
	ATTEMPT				INT(4) not null default 0,

	CALL_ID				VARCHAR(32),
	DURATION			INT(16) not null default 0,
	CALL_NOTE			VARCHAR(20),
	DTMF_LOG			VARCHAR(20),

	unique(DATA_ID),
	unique(ID,PHONE_NUMBER),

	INDEX I_CB_DATA_PROCESS_T (PROCESS_TIMESTAMP),
	INDEX I_CB_DATA_CREATE_T (CREATE_TIMESTAMP),
	INDEX I_CB_DATA_STATUS (CALL_STATUS),
	INDEX I_CB_DATA_NAME (NAME),

	CONSTRAINT FK_VPBX_VBOXES_CALLBLAST_DATA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_USERVAR
(
	ID					INT(16)		    not null,

	MAX_DIGITS			INT(10)			not null default -1,
	DTMF_PATTERN_ID		INT(16) 		not null default 0,
	NEED_FORMATED		INT(1) 			not null default 1,
	VAR_NAME            VARCHAR(255) 	not null,

	unique(ID),

	CONSTRAINT FK_VPBX_VBOXES_USERVAR_PTRN FOREIGN KEY (DTMF_PATTERN_ID) REFERENCES VPBX_DTMF_PATTERN(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_USEVAR FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_WEBVAR
(
	ID				INT(16)		    not null,

	WEBVAR_URL			VARCHAR(1024)	not null default '',
	GOTO_IF_FAIL		VARCHAR(255),
	DEFAULT_VAR			VARCHAR(255),
	NEED_PARAMS			INT(1) not null default 0,
	MAX_MSG_DURATION	INT(10) not null default -1,
	NEED_VOICE			INT(1) not null default 0,
	MAX_SILENCE			INT(3) not null default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_WEBVAR FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_GOTOIF
(
	ID				INT(16)		    not null,
	
	unique(ID),
    CONSTRAINT FK_VPBX_VBOXES_GOTOIF FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_GOTOIF_DATA
(
	ID			        INT(16)			not null,

	DATA_ID				INT(16)			not null AUTO_INCREMENT,

	PRIORITY			INT(6)			default 5,
	
	FUNC	 			VARCHAR(50)		not null,
	COND	 			VARCHAR(50)		not null,
	VAR_NAME 			VARCHAR(255)	not null,
	VAR_VALUE			VARCHAR(255)	not null,
	
	REDIRECT_TO         VARCHAR(255)	not null,

	unique(DATA_ID),
    CONSTRAINT FK_VPBX_VBOXES_GOTOIF_DATA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;


create	table VPBX_VBOXES_DBVAR
(
	ID				INT(16)		    not null,

	VAR_VALUE		VARCHAR(255)	not null default '0',

	unique(ID),
    CONSTRAINT FK_VPBX_VBOXES_DBVAR FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;


create	table VPBX_VBOXES_ROBOTEXT
(
	ID					INT(16)		    not null,

	SAY_PATTERN_ID		INT(16) 		not null default 0,
	TEXT_STR			VARCHAR(255),

	unique(ID),

	CONSTRAINT FK_VPBX_VBOXES_ROBOTEXT_PTRN FOREIGN KEY (SAY_PATTERN_ID) REFERENCES VPBX_SAY_PATTERN(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_ROBOTEXT FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;


create	table VPBX_VBOXES_STREAMING
(
	ID				INT(16)		    not null,

	STREAM_URL		VARCHAR(255),

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_STREAMING FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_PARKING
(
	ID				INT(16)		    not null,
	RING_TIMEOUT	INT(3)			default 180,
	GOTO_IF_FAIL	VARCHAR(255),
	MOH_ID			INT(16)			not null default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_PARKING FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_PARKING_MOH FOREIGN KEY (MOH_ID) REFERENCES VPBX_MOH(ID) ON UPDATE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_MULTIDIALOUT
(
	ID				INT(16)		    not null,

	MOH_ID				INT(16)		not null default 0,
	RING_TIMEOUT		INT(3)		default 30,
	RETRYDIAL_INTERVAL	INT(3)		default 0,
	RETRYDIAL_LOOPS		INT(3)		default 0,
	SAY_CALLEDID		INT(1)		default 0,
	CONFIRM_CALL		INT(1)		default 0,
	RECORD_CALL			INT(1)		default 0,
	KEEP_MSG			INT(1)		default 1,
	SEND_ATTACH			INT(1)		default 0,
	WAIT_NOTES			INT(1)		default 0,
	DYNAMIC_CID			INT(1)		default 0,
	CPS					INT(3)		default 0,
	URL					TEXT(1024),
	URL_STAT			TEXT(1024),
	unique(ID),
    CONSTRAINT FK_VPBX_VBOXES_MULTIDIALOUT_MOH FOREIGN KEY (MOH_ID) REFERENCES VPBX_MOH(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_VBOXES_MULTIDIALOUT FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_MULTIDIALOUT_DATA
(
	ID			        INT(16)		 not null,

	DATA_ID				INT(16)		 not null AUTO_INCREMENT,
	NAME                VARCHAR(255) not null,
    PHONE_NUMBER		VARCHAR(255) not null,
	USER_VARS			VARCHAR(255),

	CREATE_TIMESTAMP	INT(16) not null,
	PROCESS_TIMESTAMP	INT(16) not null default 0,

	CALL_STATUS			CHAR(20) not null default 'wait',
	ATTEMPT				INT(4) not null default 0,

	CALL_ID				VARCHAR(32),
	DURATION			INT(16) not null default 0,

	CALL_NOTE			VARCHAR(255),

	unique(DATA_ID),
	unique(ID,PHONE_NUMBER),

	INDEX I_CB_DATA_PROCESS_T (PROCESS_TIMESTAMP),
	INDEX I_CB_DATA_CREATE_T (CREATE_TIMESTAMP),
	INDEX I_CB_DATA_STATUS (CALL_STATUS),

	CONSTRAINT FK_VPBX_VBOXES_MULTIDIALOUT_DATA FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_VBOXES_PAUSE
(
	ID					INT(16)		    not null,

	TIMEOUT				INT(1)			not null default 5,
	DURATION			INT(1)			not null default 0,
	MODE				INT(1)			not null default 0,
	NOANSWER			INT(1)			not null default 0,

	unique(ID),

    CONSTRAINT FK_VPBX_VBOXES_PAUSE FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_CDRS
(
	SERVER_ID			VARCHAR(100) not null,
	CALL_ID				VARCHAR(32),
	CALL_TYPE			VARCHAR(15),
    
    SUBSCR_ID			INT(16)     not null,
	CALLER_ID			VARCHAR(100),
	CALLED_ID			VARCHAR(255),
	CNAM				VARCHAR(255),
	CALL_ID_SIP			VARCHAR(255),

	START_TIMESTAMP		DECIMAL(15,5),
	STOP_TIMESTAMP		DECIMAL(15,5),
	CREATE_TIMESTAMP	DECIMAL(15,5),

	COST				FLOAT	not null default 0,

	SYS_COST			FLOAT	not null default 0,
	CURRENCY_ID			INT(16)	not null default 1,
	PROCESS_TIMESTAMP	DECIMAL(15,5),

	DATA				TEXT(2048),

	unique(CALL_ID,START_TIMESTAMP),

    CONSTRAINT FK_VPBX_CDRS_C_NODES FOREIGN KEY (SERVER_ID) REFERENCES VPBX_NODES(NODE_ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_CDRS_C_CURR FOREIGN KEY (CURRENCY_ID) REFERENCES VPBX_CURRENCY(CUR_ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_CDRS_C_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID),

	INDEX I_CDR_C_CALL_ID (CALL_ID),
	INDEX I_CDR_C_CALL_TYPE (CALL_TYPE),
	INDEX I_CDR_C_CALLER_ID (CALLER_ID),
	INDEX I_CDR_C_CALLED_ID (CALLED_ID),
	INDEX I_CDR_C_START_T (SUBSCR_ID,START_TIMESTAMP),
	INDEX I_CDR_C_STOP_T (SUBSCR_ID,STOP_TIMESTAMP),
	INDEX I_CDR_C_START_TIME (START_TIMESTAMP),
	INDEX I_CDR_C_STOP_TIME (STOP_TIMESTAMP)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- cdr chunks

create	table VPBX_CDRS_ARCHIVE
(
	SERVER_ID			VARCHAR(100) not null,
	CALL_ID				VARCHAR(32),
	CALL_TYPE			VARCHAR(15),
    
    SUBSCR_ID			INT(16)     not null,
	CALLER_ID			VARCHAR(100),
	CALLED_ID			VARCHAR(255),
	CNAM				VARCHAR(255),
	CALL_ID_SIP			VARCHAR(255),

	START_TIMESTAMP		DECIMAL(15,5),
	STOP_TIMESTAMP		DECIMAL(15,5),
	CREATE_TIMESTAMP	DECIMAL(15,5),

	COST				FLOAT	not null default 0,

	SYS_COST			FLOAT	not null default 0,
	CURRENCY_ID			INT(16)	not null default 1,
	PROCESS_TIMESTAMP	DECIMAL(15,5),

	DATA				TEXT(2048),

	STOP_DATE			DATETIME,

	INDEX I_CDR_C_CALL_TYPE (CALL_TYPE),
	INDEX I_CDR_C_CALLER_ID (CALLER_ID),
	INDEX I_CDR_C_CALLED_ID (CALLED_ID),
	INDEX I_CDR_C_STOP_T (SUBSCR_ID,STOP_TIMESTAMP)
)	ENGINE=INNODB DEFAULT CHARSET=utf8

	PARTITION BY HASH(MONTH(STOP_DATE)) 
	PARTITIONS 12;

CREATE TRIGGER cdr_cleanup_triger BEFORE DELETE ON VPBX_CDRS FOR EACH ROW
	INSERT INTO VPBX_CDRS_ARCHIVE
		( 
			SERVER_ID,
			CALL_ID,
			CALL_TYPE,
  		  	SUBSCR_ID,
			CALLER_ID,
			CALLED_ID,
			CNAM,
			START_TIMESTAMP,
			STOP_TIMESTAMP,
			CREATE_TIMESTAMP,
			COST,
			SYS_COST,
			CURRENCY_ID,
			PROCESS_TIMESTAMP,
			DATA,
			STOP_DATE,
			CALL_ID_SIP
		)
	VALUES
		( 
			OLD.SERVER_ID,
			OLD.CALL_ID,
			OLD.CALL_TYPE,
  		  	OLD.SUBSCR_ID,
			OLD.CALLER_ID,
			OLD.CALLED_ID,
			OLD.CNAM,
			OLD.START_TIMESTAMP,
			OLD.STOP_TIMESTAMP,
			OLD.CREATE_TIMESTAMP,
			OLD.COST,
			OLD.SYS_COST,
			OLD.CURRENCY_ID,
			OLD.PROCESS_TIMESTAMP,
			OLD.DATA,
			FROM_UNIXTIME(OLD.STOP_TIMESTAMP),
			OLD.CALL_ID_SIP
		);

create or replace view VPBX_CDRS_ALL 
	(SERVER_ID,CALL_ID,CALL_TYPE,SUBSCR_ID,CALLER_ID,CALLED_ID,CNAM,START_TIMESTAMP,STOP_TIMESTAMP,CREATE_TIMESTAMP,COST,SYS_COST,CURRENCY_ID,CALL_ID_SIP,PROCESS_TIMESTAMP,DATA)
	as
select 
	SERVER_ID,CALL_ID,CALL_TYPE,SUBSCR_ID,CALLER_ID,CALLED_ID,CNAM,START_TIMESTAMP,STOP_TIMESTAMP,CREATE_TIMESTAMP,COST,SYS_COST,CURRENCY_ID,CALL_ID_SIP,PROCESS_TIMESTAMP,DATA
from
	VPBX_CDRS
union
select 
	SERVER_ID,CALL_ID,CALL_TYPE,SUBSCR_ID,CALLER_ID,CALLED_ID,CNAM,START_TIMESTAMP,STOP_TIMESTAMP,CREATE_TIMESTAMP,COST,SYS_COST,CURRENCY_ID,CALL_ID_SIP,PROCESS_TIMESTAMP,DATA
from
	VPBX_CDRS_ARCHIVE;

-- end of cdr chunks

create	table VPBX_CDRS_ACTIVITY
(
	SERVER_ID			VARCHAR(100) not null,
	CALL_ID				VARCHAR(32),
    
    SUBSCR_ID			INT(16)     not null,
	CALLER_ID			VARCHAR(100),
	CALLED_ID			VARCHAR(255),

	TYPE				VARCHAR(25),
	EXT_NUMBER			VARCHAR(255) not null,

	START_TIMESTAMP		DECIMAL(15,5),
	STOP_TIMESTAMP		DECIMAL(15,5),
	CREATE_TIMESTAMP	DECIMAL(15,5),

	DATA				TEXT(2048),

	unique(CALL_ID,TYPE,START_TIMESTAMP),

    CONSTRAINT FK_VPBX_CDRS_A_NODES FOREIGN KEY (SERVER_ID) REFERENCES VPBX_NODES(NODE_ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_CDRS_A_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID),

	INDEX I_CDR_A_EXT_NUMBER (EXT_NUMBER,SUBSCR_ID),
	INDEX I_CDR_A_TYPE (TYPE,SUBSCR_ID),
	INDEX I_CDR_A_CALL_ID (CALL_ID),
	INDEX I_CDR_A_CALLER_ID (CALLER_ID),
	INDEX I_CDR_A_START_T (SUBSCR_ID,START_TIMESTAMP),
	INDEX I_CDR_A_STOP_T (SUBSCR_ID,STOP_TIMESTAMP)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- cdr-activity chunks

create	table VPBX_CDRS_ACTIVITY_ARCHIVE
(
	SERVER_ID			VARCHAR(100) not null,
	CALL_ID				VARCHAR(32),
    
    SUBSCR_ID			INT(16)     not null,
	CALLER_ID			VARCHAR(100),
	CALLED_ID			VARCHAR(255),

	TYPE				VARCHAR(25),
	EXT_NUMBER			VARCHAR(255) not null,

	START_TIMESTAMP		DECIMAL(15,5),
	STOP_TIMESTAMP		DECIMAL(15,5),
	CREATE_TIMESTAMP	DECIMAL(15,5),

	DATA				TEXT(2048),
	STOP_DATE			DATETIME,

	INDEX I_CDR_A_EXT_NUMBER (EXT_NUMBER,SUBSCR_ID),
	INDEX I_CDR_A_TYPE (TYPE,SUBSCR_ID),
	INDEX I_CDR_A_CALL_ID (CALL_ID),
	INDEX I_CDR_A_CALLER_ID (CALLER_ID),
	INDEX I_CDR_A_START_T (START_TIMESTAMP,SUBSCR_ID),
	INDEX I_CDR_A_STOP_T (STOP_TIMESTAMP,SUBSCR_ID)
)	ENGINE=INNODB DEFAULT CHARSET=utf8

	PARTITION BY HASH(MONTH(STOP_DATE)) 
	PARTITIONS 12;

CREATE TRIGGER cdr_a_cleanup_triger BEFORE DELETE ON VPBX_CDRS_ACTIVITY FOR EACH ROW
	INSERT INTO VPBX_CDRS_ACTIVITY_ARCHIVE
		( 
			SERVER_ID,
			CALL_ID,
			SUBSCR_ID,
			CALLER_ID,
			CALLED_ID,
			TYPE,
			EXT_NUMBER,
			START_TIMESTAMP,
			STOP_TIMESTAMP,
			CREATE_TIMESTAMP,
			DATA,
			STOP_DATE
		)
	VALUES
		( 
			OLD.SERVER_ID,
			OLD.CALL_ID,
			OLD.SUBSCR_ID,
			OLD.CALLER_ID,
			OLD.CALLED_ID,
			OLD.TYPE,
			OLD.EXT_NUMBER,
			OLD.START_TIMESTAMP,
			OLD.STOP_TIMESTAMP,
			OLD.CREATE_TIMESTAMP,
			OLD.DATA,
			FROM_UNIXTIME(OLD.STOP_TIMESTAMP)
		);

create or replace view VPBX_CDRS_ACTIVITY_ALL 
	(
			SERVER_ID,
			CALL_ID,
			SUBSCR_ID,
			CALLER_ID,
			CALLED_ID,
			TYPE,
			EXT_NUMBER,
			START_TIMESTAMP,
			STOP_TIMESTAMP,
			CREATE_TIMESTAMP,
			DATA
		)
	as
select 
	SERVER_ID,
	CALL_ID,
	SUBSCR_ID,
	CALLER_ID,
	CALLED_ID,
	TYPE,
	EXT_NUMBER,
	START_TIMESTAMP,
	STOP_TIMESTAMP,
	CREATE_TIMESTAMP,
	DATA
from
	VPBX_CDRS_ACTIVITY
union
select 
	SERVER_ID,
	CALL_ID,
	SUBSCR_ID,
	CALLER_ID,
	CALLED_ID,
	TYPE,
	EXT_NUMBER,
	START_TIMESTAMP,
	STOP_TIMESTAMP,
	CREATE_TIMESTAMP,
	DATA
from
	VPBX_CDRS_ACTIVITY_ARCHIVE;

-- end of cdr-activity chunks

create	table VPBX_JOURNAL
(
    SUBSCR_ID			INT(16)     not null,
	EXT_NUMBER			VARCHAR(255)	not null,
	ACTION				VARCHAR(100)	not null,
	CREATE_TIMESTAMP	INT(16),
	CID					VARCHAR(255),
	DESCRIPTION			TEXT(2048),

    CONSTRAINT FK_VPBX_J_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
	
	INDEX I_JOURNAL_EXT_NUMBER (EXT_NUMBER,SUBSCR_ID),
	INDEX I_JOURNALS_START_T (CREATE_TIMESTAMP,SUBSCR_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_CID_FILTERS
(
	DATA_ID				INT(16)	    not null AUTO_INCREMENT,
	ID					INT(16)		not null,
	CID_LIST_TYPE		INT(1)		not null default 1,
	CID_TYPE			INT(1)		not null default 1,
	CID					VARCHAR(255)	not null,
	DESCRIPTION			VARCHAR(255),

    CONSTRAINT FK_VPBX_BL_VB FOREIGN KEY (ID) REFERENCES VPBX_VBOXES_CORE(ID) ON DELETE CASCADE,
	CONSTRAINT PK_VPBX_CID_DATA PRIMARY KEY (DATA_ID),
	INDEX I_FILTERS (ID,CID_LIST_TYPE,CID_TYPE),
	INDEX I_FILTERS_CID (CID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create table VPBX_ONLINE_CALLS
(

	SERVER_ID			VARCHAR(100) not null,
	CALL_ID				VARCHAR(32),
	CALL_TYPE			VARCHAR(15),
    SUBSCR_ID			INT(16) not null,
	CALLER_ID			VARCHAR(100),
	CALLED_ID			VARCHAR(255),
	ACCESS_CODE			VARCHAR(100) not null,
	START_TIMESTAMP		INT(16),
	AST_ID  			VARCHAR(100),
	STATUS				INT(1) not null default 0,
	CNAM				VARCHAR(255),

	unique(AST_ID,CALL_ID),
	
	INDEX I_OC_SERVER_ID (SERVER_ID),
	INDEX I_OC_CALL_ID (CALL_ID),
	INDEX I_OC_SUBSCRIBER_ID (SUBSCR_ID),
	INDEX I_OC_ACCESS_CODE (ACCESS_CODE)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

create	table VPBX_CRM_CUSTOMERS
(
	DATA_ID				INT(16)	not null AUTO_INCREMENT,
    SUBSCR_ID			INT(16) not null,
	
	C_NAME				VARCHAR(255),
	C_VARS				VARCHAR(255),
	C_NOTE				TEXT(2048),

	CREATE_TIMESTAMP	INT(16),
	
	PRIMARY KEY (DATA_ID),

	CONSTRAINT FK_VPBX_CUSTOMER_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create  table VPBX_CRM_NOTES
(
	DATA_ID             INT(16) not null AUTO_INCREMENT,
	SUBSCR_ID           INT(16) not null,
	CUSTOMER_ID         INT(16) not null,
	
	CALL_ID             VARCHAR(32),
	CALL_DETAIL         TEXT(512),
	CALL_STATUS			INT(1) default 0,
	NOTE                TEXT(4096),
	TYPE                VARCHAR(50),
	FILE_NAME			VARCHAR(255),

	CREATE_TIMESTAMP	INT(16),

	CONSTRAINT FK_VPBX_CRM_NOTE_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE,
	CONSTRAINT FK_VPBX_CRM_NOTE_CUSTOMER FOREIGN KEY (CUSTOMER_ID) REFERENCES VPBX_CRM_CUSTOMERS(DATA_ID) ON DELETE CASCADE,

	CONSTRAINT PK_VPBX_CRM_NOTE_DATA PRIMARY KEY (DATA_ID),

	INDEX I_CRM_N_CALL_ID (CALL_ID)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

create	table VPBX_GEO_INFO
(
	F_N 		BIGINT(64),
	L_N 		BIGINT(64),
	RNG 		int(10),
	OP 			VARCHAR(255),
	DSC 		VARCHAR(255)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

create table VPBX_ROLES
(
	DATA_ID						INT(16)		    not null AUTO_INCREMENT,
	SUBSCR_ID					INT(16),
	LOGIN						VARCHAR(100),
	PASSWORD					VARCHAR(100),
	DESCRIPTION					VARCHAR(255),
	LANG_ID						INT(16)	not null default 0,
	PERMIT_WEB					VARCHAR(100),

	ACTION_ACT_LIST_ALL			INT(1) default 1,
	ACTION_ACT_LIST				INT(1) default 1,
	ACTION_AGENT_STATUS			INT(1) default 1,
	ACTION_BACKUP				INT(1) default 1,
	ACTION_C2C_ADD				INT(1) default 1,
	ACTION_C2C_DEL				INT(1) default 1,
	ACTION_C2C_LIST				INT(1) default 1,
	ACTION_C2C_UPDATE			INT(1) default 1,
	ACTION_CALLBLAST_ADD		INT(1) default 1,
	ACTION_CALLBLAST_DEL_CACHE	INT(1) default 1,
	ACTION_CALLBLAST_DEL		INT(1) default 1,
	ACTION_CALLBLAST_UPDATE		INT(1) default 1,
	ACTION_CALLOUT_CLEAN		INT(1) default 1,
	ACTION_CALLS_HANGUP			INT(1) default 1,
	ACTION_CALLS_LIST			INT(1) default 1,
	ACTION_CDR_LIST				INT(1) default 1,
	ACTION_CID_ADD				INT(1) default 1,
	ACTION_CID_DEL				INT(1) default 1,
	ACTION_CID_LIST				INT(1) default 1,
	ACTION_CID_UPDATE			INT(1) default 1,
	ACTION_CRM_ADD				INT(1) default 1,
	ACTION_CRM_DEL				INT(1) default 1,
	ACTION_CRM_INFO				INT(1) default 1,
	ACTION_CRM_LIST				INT(1) default 1,
	ACTION_CRM_N_ADD			INT(1) default 1,
	ACTION_CRM_N_DEL			INT(1) default 1,
	ACTION_CRM_N_UPDATE			INT(1) default 1,
	ACTION_CRM_UPDATE			INT(1) default 1,
	ACTION_DASHBOARD_LIST		INT(1) default 1,
	ACTION_DASHBOARD_LOAD_LIST	INT(1) default 1,
	ACTION_DIR_ADD				INT(1) default 1,
	ACTION_DIR_DEL				INT(1) default 1,
	ACTION_DIR_UPDATE			INT(1) default 1,
	ACTION_EXT_BACKUP			INT(1) default 1,
	ACTION_EXTENDED_STAT		INT(1) default 1,
	ACTION_EXT_RESTORE			INT(1) default 1,
	ACTION_EXT_STAT				INT(1) default 1,
	ACTION_FBSHARE				INT(1) default 1,
	ACTION_GET_ITUNES_ALL		INT(1) default 1,
	ACTION_GET_ITUNES			INT(1) default 1,
	ACTION_GET_RSS_ALL			INT(1) default 1,
	ACTION_GET_RSS				INT(1) default 1,
	ACTION_GOTOIF_ADD			INT(1) default 1,
	ACTION_GOTOIF_DEL			INT(1) default 1,
	ACTION_GOTOIF_UPDATE		INT(1) default 1,
	ACTION_INTEGRATION_LIST		INT(1) default 1,
	ACTION_IVRFLOW_LIST			INT(1) default 1,
	ACTION_J_LIST				INT(1) default 1,
	ACTION_LIST_GET				INT(1) default 1,
	ACTION_MACROS_ADD			INT(1) default 1,
	ACTION_MACROS_DEL			INT(1) default 1,
	ACTION_MACROS_LIST			INT(1) default 1,
	ACTION_MACROS_UPDATE		INT(1) default 1,
	ACTION_MENU					INT(1) default 1,
	ACTION_MSG_CLEANUP			INT(1) default 1,
	ACTION_MSG_DELETE			INT(1) default 1,
	ACTION_MSG_DOWNLOAD			INT(1) default 1,
	ACTION_MSG_LIST_ALL			INT(1) default 1,
	ACTION_MSG_LIST				INT(1) default 1,
	ACTION_MSG_STATUS			INT(1) default 1,
	ACTION_MSG_UPLOAD			INT(1) default 1,
	ACTION_MULTIDIALOUT_ADD		INT(1) default 1,
	ACTION_MULTIDIALOUT_DEL		INT(1) default 1,
	ACTION_MULTIDIALOUT_RESET	INT(1) default 1,
	ACTION_MULTIDIALOUT_UPDATE	INT(1) default 1,
	ACTION_PBOOK_ADD			INT(1) default 1,
	ACTION_PBOOK_DEL			INT(1) default 1,
	ACTION_PBOOK_LIST			INT(1) default 1,
	ACTION_PBOOK_UPDATE			INT(1) default 1,
	ACTION_PEER_ADD				INT(1) default 1,
	ACTION_PEER_DEL				INT(1) default 1,
	ACTION_PEER_LIST			INT(1) default 1,
	ACTION_PEER_UPDATE			INT(1) default 1,
	ACTION_PHONE_ADD			INT(1) default 1,
	ACTION_PHONE_DEL			INT(1) default 1,
	ACTION_PHONE_INFO			INT(1) default 1,
	ACTION_PHONE_LIST			INT(1) default 1,
	ACTION_PHONE_UPDATE			INT(1) default 1,
	ACTION_RESTORE				INT(1) default 1,
	ACTION_ROLE_ADD				INT(1) default 0,
	ACTION_ROLE_DEL				INT(1) default 0,
	ACTION_ROLE_LIST			INT(1) default 0,
	ACTION_ROLE_INFO			INT(1) default 0,
	ACTION_ROLE_UPDATE			INT(1) default 0,
	ACTION_ROUTE_ADD			INT(1) default 1,
	ACTION_ROUTE_DEL			INT(1) default 1,
	ACTION_ROUTE_LIST			INT(1) default 1,
	ACTION_ROUTE_UPDATE			INT(1) default 1,
	ACTION_SCHEDULE_ADD			INT(1) default 1,
	ACTION_SCHEDULE_DEL			INT(1) default 1,
	ACTION_SCHEDULE_UPDATE		INT(1) default 1,
	ACTION_START				INT(1) default 1,
	ACTION_SV_UPDATE			INT(1) default 1,
	ACTION_SYSMEDIA_ADD			INT(1) default 1,
	ACTION_SYSMEDIA_DEL			INT(1) default 1,
	ACTION_SYSMEDIA_LIST		INT(1) default 1,
	ACTION_USER_INFO			INT(1) default 1,
	ACTION_USER_UPDATE			INT(1) default 1,
	ACTION_VB_ADD				INT(1) default 1,
	ACTION_VB_CHANGE_TYPE		INT(1) default 1,
	ACTION_VB_CLONE				INT(1) default 1,
	ACTION_VB_DEL				INT(1) default 1,
	ACTION_VB_LIST				INT(1) default 1,
	ACTION_VB_UPDATE			INT(1) default 1,
	ACTION_VB_VIEW				INT(1) default 1,
	ACTION_VOTING_CLEAN			INT(1) default 1,
	ACTION_DEFAULT				INT(1) default 1,
	ACTION_REPORT_LIST			INT(1) default 1, 
	ACTION_REPORT_RUN			INT(1) default 1,
	
	ACTION_PERM_HIDE_NUMBERS	INT(1) default 0,
	ACTION_PERM_CSV_DUMP		INT(1) default 1,
	ACTION_PERM_ROOT_ACCESS		INT(1) default 0,
	ACTION_PERM_CDR_STAT		INT(1) default 1,
	
	IS_TEMPLATE					INT(1) default 0,

	unique(SUBSCR_ID,LOGIN),
    CONSTRAINT PK_VPBX_ROLES PRIMARY KEY (DATA_ID),
    CONSTRAINT FK_VPBX_ROLES_LANG FOREIGN KEY (LANG_ID) REFERENCES VPBX_LANG(ID) ON UPDATE CASCADE,
    CONSTRAINT FK_VPBX_ROLES_SUBSCR FOREIGN KEY (SUBSCR_ID) REFERENCES VPBX_ACCOUNTS(ID) ON DELETE CASCADE
) ENGINE=INNODB DEFAULT CHARSET=utf8;

-- End Virtual PBX

-- Data

-- CID ACTIONS
INSERT INTO VPBX_CID_ACTIONS(ID, DESCRIPTION) VALUES(0, 'Say Extensions not found');
INSERT INTO VPBX_CID_ACTIONS(ID, DESCRIPTION) VALUES(1, 'Say User Busy');
INSERT INTO VPBX_CID_ACTIONS(ID, DESCRIPTION) VALUES(2, 'HungUp');
INSERT INTO VPBX_CID_ACTIONS(ID, DESCRIPTION) VALUES(3, 'Start voicemail');
INSERT INTO VPBX_CID_ACTIONS(ID, DESCRIPTION) VALUES(4, 'Go To next extension');
INSERT INTO VPBX_CID_ACTIONS(ID, DESCRIPTION) VALUES(5, 'Busy signal');
INSERT INTO VPBX_CID_ACTIONS(ID, DESCRIPTION) VALUES(6, 'Go To i extension');
-- CID TYPE
INSERT INTO VPBX_CID_TYPE(ID, DESCRIPTION) VALUES(0, 'No CID filters');
INSERT INTO VPBX_CID_TYPE(ID, DESCRIPTION) VALUES(1, 'Black list - extension');
INSERT INTO VPBX_CID_TYPE(ID, DESCRIPTION) VALUES(2, 'Black list - common');
INSERT INTO VPBX_CID_TYPE(ID, DESCRIPTION) VALUES(4, 'Black list - common & extension');
INSERT INTO VPBX_CID_TYPE(ID, DESCRIPTION) VALUES(8, 'White list - extension');
INSERT INTO VPBX_CID_TYPE(ID, DESCRIPTION) VALUES(16, 'White list - common');
INSERT INTO VPBX_CID_TYPE(ID, DESCRIPTION) VALUES(32, 'White list - common & extension');
-- Lang
INSERT INTO VPBX_LANG(ID,LANG_NAME, DESCRIPTION, LANG_VOICE, LANG_LOCALE, LANG_TTS_ENGINE) VALUES(0,'xvb.EN-Female','Default','cmu_us_slt_arctic_clunits','en_US.UTF-8','Festival');
INSERT INTO VPBX_LANG(ID,LANG_NAME, DESCRIPTION, LANG_VOICE, LANG_LOCALE, LANG_TTS_ENGINE) VALUES(1,'xvb.RU-Male','Russian (Male+TTS)','msu_ru_nsh_clunits','ru_RU.UTF-8','Festival');
INSERT INTO VPBX_LANG(ID,LANG_NAME, DESCRIPTION, LANG_VOICE, LANG_LOCALE, LANG_TTS_ENGINE) VALUES(2,'xvb.EN-Female','English (Female+TTS)','cmu_us_slt_arctic_clunits','en_US.UTF-8','Festival');
INSERT INTO VPBX_LANG(ID,LANG_NAME, DESCRIPTION, LANG_VOICE, LANG_LOCALE, LANG_TTS_ENGINE) VALUES(3,'xvb.EN-Male','English (Male+TTS)','cmu_us_awb_arctic_clunits','en_US.UTF-8','Festival');
INSERT INTO VPBX_LANG(ID,LANG_NAME, DESCRIPTION, LANG_VOICE, LANG_LOCALE, LANG_TTS_ENGINE) VALUES(6,'xvb.RU-Female','Russian (Female+TTS)','anna','ru_RU.UTF-8','RHVoice');
-- VB Types
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(1, 'Playback', 'Playback only');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(2, 'Record', 'VoiceMail');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(3, 'Dialout', 'Find Me');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(4, 'Directory', 'Company directory');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(5, 'Schedule', 'Schedule');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(6, 'WebRequest', 'WEB-Request');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(7, 'Conference', 'Chat-Room');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(8, 'FaxRX', 'Fax2Mail');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(9, 'DtmfRX', 'Dtmf2Email');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(10, 'Voting', 'Voting');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(11, 'DISA', 'DISA');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(12, 'Podcast', 'Podcast');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(13, 'Queue', 'Queue');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(14, 'Callback', 'Callback');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(15, 'DateTime', 'Date/Time');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(16, 'FaxTX', 'Fax on Demand');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(17, 'BBS', 'Bulletin board system');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(18, 'CallBlast', 'CallBlast');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(19, 'UserVar', 'User variable');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(20, 'WebVar', 'Web variables');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(21, 'GotoIf', 'Goto If');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(22, 'DBVar', 'Stored variable');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(23, 'AlarmClock', 'Alarm Clock');
-- INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(24, 'GoogleCalendarSchedule', 'Google Calendar - Schedule');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(25, 'RoboText', 'RoboText');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(26, 'Streaming', 'MP3-Streaming');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(27, 'Parking', 'Call parking');
-- INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(28, 'GoogleCalendarExplorer', 'Google Calendar - Events');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(29, 'Intercom', 'Paging / Intercom');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(30, 'DtmfTX', 'Play DTMF Tones');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(31, 'MultiDialout', 'MultiDialout');
INSERT INTO VPBX_VBOX_TYPE(ID, NAME, DESCRIPTION) VALUES(32, 'Pause', 'Pause');
-- Ring strategi
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(1, 'ring all', 'ring all');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(2, 'hunt', 'hunt');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(3, 'random', 'random');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(4, 'leastrecent', 'leastrecent');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(5, 'fewestcalls', 'fewestcalls');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(6, 'RoundRobin', 'round robin');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(7, 'LeastDuration', 'least duration');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(8, 'Fastest', 'fastest');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(9, 'memoryhunt', 'memoryhunt');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(10, 'random3', 'random 3');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(11, 'mostduration', 'most duration');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(12, 'mostcalls', 'mostcalls');
INSERT INTO VPBX_VBOXES_DIALOUT_TYPE(ID, NAME, DESCRIPTION) VALUES(13, 'random1', 'random 1');
--  MOH CLASS
INSERT INTO VPBX_MOH(ID,MOH_CLASS,DESCRIPTION) VALUES(-1,'alwaysringing','Always ringing');
INSERT INTO VPBX_MOH(ID,MOH_CLASS,DESCRIPTION) VALUES(0,'none','Disable');
INSERT INTO VPBX_MOH(ID,MOH_CLASS,DESCRIPTION) VALUES(1,'xvb-rock','AlisA');
INSERT INTO VPBX_MOH(ID,MOH_CLASS,DESCRIPTION) VALUES(2,'xvb-pop','Dont Worry, be Happy');
INSERT INTO VPBX_MOH(ID,MOH_CLASS,DESCRIPTION) VALUES(3,'xvb-classic','Vanessa Mae - Contradanza');
INSERT INTO VPBX_MOH(ID,MOH_CLASS,DESCRIPTION) VALUES(9999,'custom','Custom');
-- System MOH static realtime
INSERT INTO VPBX_AST_CONFIG(filename,category,var_name,var_val) VALUES('musiconhold.conf','xvb-rock','mode','files');
INSERT INTO VPBX_AST_CONFIG(filename,category,var_name,var_val) VALUES('musiconhold.conf','xvb-rock','directory','/opt/VirtualPBX/contrib/moh/rock');
INSERT INTO VPBX_AST_CONFIG(filename,category,var_name,var_val) VALUES('musiconhold.conf','xvb-pop','mode','files');
INSERT INTO VPBX_AST_CONFIG(filename,category,var_name,var_val) VALUES('musiconhold.conf','xvb-pop','directory','/opt/VirtualPBX/contrib/moh/pop');
INSERT INTO VPBX_AST_CONFIG(filename,category,var_name,var_val) VALUES('musiconhold.conf','xvb-classic','mode','files');
INSERT INTO VPBX_AST_CONFIG(filename,category,var_name,var_val) VALUES('musiconhold.conf','xvb-classic','directory','/opt/VirtualPBX/contrib/moh/classic');
--  Version
INSERT INTO VPBX_DB_INFO(VERSION,TIME) VALUES('999999',0);
--  Message types
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(1, 'NAME', 'User name');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(2, 'GREET', 'User greeting');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(3, 'ANNOUNCEMENT', 'Announcement to callee');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(4, 'RETRYDIAL', 'RetryDial Announcement');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(5, 'MOH', 'Music on hold');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(6, 'FAX', 'Fax on Demand');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(7, 'ANNOUNCEMENT_CALLER', 'Announcement to caller');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(30, 'NEW', 'VoiceMail');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(40, 'OLD', 'VoiceMail');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(41, 'MONITOR', 'Call recording');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(42, 'RXFAX', 'Fax message');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(43, 'DTMF', 'DTMF input');
INSERT INTO VPBX_VBOXES_RECORD_FTYPE(ID, NAME, DESCRIPTION) VALUES(50, 'TRASH', 'User trash');
-- DTMF PATTERN
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 0, 'none','none');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 1,'time','time hh*mm');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 2,'date','date dd*mm*yyyy');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 3,'datetime','date time dd*mm*yyyy*hh*mm');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 4,'phone','phone ( 11 digits )');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 5,'ip','ip addr (127*0*0*1)');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 6,'card','card number (any)');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 7,'card-0','MasterCard number');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 8,'card-1','Visa number');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 9,'card-2','enRoute number');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 10,'card-3','Discover number');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 11,'card-4','Deners Club/Carte Blanche number');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 12,'card-5','American Express number');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 13,'card-6','Japan Credit Bureau number');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 14,'boolean','Boolean');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 15,'currency','Currency');
insert into VPBX_DTMF_PATTERN(ID,DTMF_PATTERN,DESCRIPTION) VALUES( 16,'extension','Extension / id (1*1,2,etc)');
-- SAY PATTERN
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 0, 'char','characters');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 1, 'number','number');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 2, 'percent','percent');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 3, 'time','time');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 4, 'date1','date 1');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 5, 'date2','date 2');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 6, 'duration','duration (s:m:h)');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 7, 'money','money (rub,usd,eur)');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 8, 'degree','degree (C,F,K)');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 9, 'datetime1','datetime 1');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 10, 'datetime2','datetime 2');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 11, 'phone','phone');
insert into VPBX_SAY_PATTERN(ID,SAY_PATTERN,DESCRIPTION) VALUES( 12, 'text','text');
-- Time Zones
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(0, 'Default');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(1, 'Africa/Abidjan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(2, 'Africa/Accra');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(3, 'Africa/Addis_Ababa');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(4, 'Africa/Algiers');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(5, 'Africa/Asmara');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(6, 'Africa/Asmera');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(7, 'Africa/Bamako');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(8, 'Africa/Bangui');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(9, 'Africa/Banjul');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(10, 'Africa/Bissau');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(11, 'Africa/Blantyre');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(12, 'Africa/Brazzaville');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(13, 'Africa/Bujumbura');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(14, 'Africa/Cairo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(15, 'Africa/Casablanca');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(16, 'Africa/Ceuta');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(17, 'Africa/Conakry');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(18, 'Africa/Dakar');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(19, 'Africa/Dar_es_Salaam');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(20, 'Africa/Djibouti');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(21, 'Africa/Douala');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(22, 'Africa/El_Aaiun');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(23, 'Africa/Freetown');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(24, 'Africa/Gaborone');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(25, 'Africa/Harare');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(26, 'Africa/Johannesburg');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(27, 'Africa/Kampala');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(28, 'Africa/Khartoum');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(29, 'Africa/Kigali');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(30, 'Africa/Kinshasa');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(31, 'Africa/Lagos');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(32, 'Africa/Libreville');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(33, 'Africa/Lome');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(34, 'Africa/Luanda');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(35, 'Africa/Lubumbashi');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(36, 'Africa/Lusaka');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(37, 'Africa/Malabo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(38, 'Africa/Maputo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(39, 'Africa/Maseru');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(40, 'Africa/Mbabane');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(41, 'Africa/Mogadishu');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(42, 'Africa/Monrovia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(43, 'Africa/Nairobi');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(44, 'Africa/Ndjamena');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(45, 'Africa/Niamey');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(46, 'Africa/Nouakchott');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(47, 'Africa/Ouagadougou');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(48, 'Africa/Porto-Novo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(49, 'Africa/Sao_Tome');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(50, 'Africa/Timbuktu');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(51, 'Africa/Tripoli');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(52, 'Africa/Tunis');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(53, 'Africa/Windhoek');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(54, 'America/Adak');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(55, 'America/Anchorage');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(56, 'America/Anguilla');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(57, 'America/Antigua');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(58, 'America/Araguaina');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(59, 'America/Argentina/Buenos_Aires');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(60, 'America/Argentina/Catamarca');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(61, 'America/Argentina/ComodRivadavia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(62, 'America/Argentina/Cordoba');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(63, 'America/Argentina/Jujuy');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(64, 'America/Argentina/La_Rioja');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(65, 'America/Argentina/Mendoza');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(66, 'America/Argentina/Rio_Gallegos');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(67, 'America/Argentina/Salta');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(68, 'America/Argentina/San_Juan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(69, 'America/Argentina/San_Luis');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(70, 'America/Argentina/Tucuman');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(71, 'America/Argentina/Ushuaia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(72, 'America/Aruba');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(73, 'America/Asuncion');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(74, 'America/Atikokan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(75, 'America/Atka');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(76, 'America/Bahia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(77, 'America/Barbados');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(78, 'America/Belem');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(79, 'America/Belize');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(80, 'America/Blanc-Sablon');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(81, 'America/Boa_Vista');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(82, 'America/Bogota');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(83, 'America/Boise');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(84, 'America/Buenos_Aires');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(85, 'America/Cambridge_Bay');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(86, 'America/Campo_Grande');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(87, 'America/Cancun');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(88, 'America/Caracas');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(89, 'America/Catamarca');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(90, 'America/Cayenne');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(91, 'America/Cayman');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(92, 'America/Chicago');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(93, 'America/Chihuahua');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(94, 'America/Coral_Harbour');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(95, 'America/Cordoba');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(96, 'America/Costa_Rica');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(97, 'America/Cuiaba');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(98, 'America/Curacao');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(99, 'America/Danmarkshavn');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(100, 'America/Dawson');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(101, 'America/Dawson_Creek');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(102, 'America/Denver');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(103, 'America/Detroit');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(104, 'America/Dominica');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(105, 'America/Edmonton');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(106, 'America/Eirunepe');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(107, 'America/El_Salvador');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(108, 'America/Ensenada');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(109, 'America/Fortaleza');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(110, 'America/Fort_Wayne');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(111, 'America/Glace_Bay');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(112, 'America/Godthab');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(113, 'America/Goose_Bay');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(114, 'America/Grand_Turk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(115, 'America/Grenada');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(116, 'America/Guadeloupe');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(117, 'America/Guatemala');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(118, 'America/Guayaquil');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(119, 'America/Guyana');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(120, 'America/Halifax');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(121, 'America/Havana');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(122, 'America/Hermosillo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(123, 'America/Indiana/Indianapolis');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(124, 'America/Indiana/Knox');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(125, 'America/Indiana/Marengo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(126, 'America/Indiana/Petersburg');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(127, 'America/Indianapolis');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(128, 'America/Indiana/Tell_City');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(129, 'America/Indiana/Vevay');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(130, 'America/Indiana/Vincennes');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(131, 'America/Indiana/Winamac');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(132, 'America/Inuvik');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(133, 'America/Iqaluit');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(134, 'America/Jamaica');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(135, 'America/Jujuy');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(136, 'America/Juneau');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(137, 'America/Kentucky/Louisville');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(138, 'America/Kentucky/Monticello');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(139, 'America/Knox_IN');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(140, 'America/La_Paz');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(141, 'America/Lima');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(142, 'America/Los_Angeles');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(143, 'America/Louisville');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(144, 'America/Maceio');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(145, 'America/Managua');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(146, 'America/Manaus');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(147, 'America/Marigot');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(148, 'America/Martinique');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(149, 'America/Mazatlan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(150, 'America/Mendoza');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(151, 'America/Menominee');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(152, 'America/Merida');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(153, 'America/Mexico_City');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(154, 'America/Miquelon');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(155, 'America/Moncton');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(156, 'America/Monterrey');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(157, 'America/Montevideo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(158, 'America/Montreal');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(159, 'America/Montserrat');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(160, 'America/Nassau');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(161, 'America/New_York');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(162, 'America/Nipigon');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(163, 'America/Nome');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(164, 'America/Noronha');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(165, 'America/North_Dakota/Center');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(166, 'America/North_Dakota/New_Salem');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(167, 'America/Panama');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(168, 'America/Pangnirtung');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(169, 'America/Paramaribo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(170, 'America/Phoenix');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(171, 'America/Port-au-Prince');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(172, 'America/Porto_Acre');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(173, 'America/Port_of_Spain');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(174, 'America/Porto_Velho');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(175, 'America/Puerto_Rico');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(176, 'America/Rainy_River');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(177, 'America/Rankin_Inlet');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(178, 'America/Recife');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(179, 'America/Regina');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(180, 'America/Resolute');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(181, 'America/Rio_Branco');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(182, 'America/Rosario');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(183, 'America/Santarem');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(184, 'America/Santiago');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(185, 'America/Santo_Domingo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(186, 'America/Sao_Paulo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(187, 'America/Scoresbysund');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(188, 'America/Shiprock');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(189, 'America/St_Barthelemy');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(190, 'America/St_Johns');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(191, 'America/St_Kitts');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(192, 'America/St_Lucia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(193, 'America/St_Thomas');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(194, 'America/St_Vincent');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(195, 'America/Swift_Current');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(196, 'America/Tegucigalpa');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(197, 'America/Thule');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(198, 'America/Thunder_Bay');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(199, 'America/Tijuana');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(200, 'America/Toronto');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(201, 'America/Tortola');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(202, 'America/Vancouver');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(203, 'America/Virgin');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(204, 'America/Whitehorse');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(205, 'America/Winnipeg');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(206, 'America/Yakutat');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(207, 'America/Yellowknife');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(208, 'Antarctica/Casey');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(209, 'Antarctica/Davis');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(210, 'Antarctica/DumontDUrville');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(211, 'Antarctica/Mawson');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(212, 'Antarctica/McMurdo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(213, 'Antarctica/Palmer');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(214, 'Antarctica/Rothera');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(215, 'Antarctica/South_Pole');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(216, 'Antarctica/Syowa');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(217, 'Antarctica/Vostok');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(218, 'Arctic/Longyearbyen');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(219, 'Asia/Aden');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(220, 'Asia/Almaty');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(221, 'Asia/Amman');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(222, 'Asia/Anadyr');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(223, 'Asia/Aqtau');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(224, 'Asia/Aqtobe');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(225, 'Asia/Ashgabat');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(226, 'Asia/Ashkhabad');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(227, 'Asia/Baghdad');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(228, 'Asia/Bahrain');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(229, 'Asia/Baku');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(230, 'Asia/Bangkok');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(231, 'Asia/Beirut');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(232, 'Asia/Bishkek');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(233, 'Asia/Brunei');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(234, 'Asia/Calcutta');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(235, 'Asia/Choibalsan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(236, 'Asia/Chongqing');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(237, 'Asia/Chungking');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(238, 'Asia/Colombo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(239, 'Asia/Dacca');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(240, 'Asia/Damascus');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(241, 'Asia/Dhaka');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(242, 'Asia/Dili');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(243, 'Asia/Dubai');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(244, 'Asia/Dushanbe');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(245, 'Asia/Gaza');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(246, 'Asia/Harbin');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(247, 'Asia/Ho_Chi_Minh');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(248, 'Asia/Hong_Kong');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(249, 'Asia/Hovd');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(250, 'Asia/Irkutsk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(251, 'Asia/Istanbul');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(252, 'Asia/Jakarta');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(253, 'Asia/Jayapura');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(254, 'Asia/Jerusalem');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(255, 'Asia/Kabul');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(256, 'Asia/Kamchatka');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(257, 'Asia/Karachi');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(258, 'Asia/Kashgar');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(259, 'Asia/Katmandu');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(260, 'Asia/Kolkata');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(261, 'Asia/Krasnoyarsk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(262, 'Asia/Kuala_Lumpur');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(263, 'Asia/Kuching');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(264, 'Asia/Kuwait');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(265, 'Asia/Macao');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(266, 'Asia/Macau');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(267, 'Asia/Magadan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(268, 'Asia/Makassar');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(269, 'Asia/Manila');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(270, 'Asia/Muscat');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(271, 'Asia/Nicosia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(272, 'Asia/Novosibirsk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(273, 'Asia/Omsk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(274, 'Asia/Oral');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(275, 'Asia/Phnom_Penh');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(276, 'Asia/Pontianak');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(277, 'Asia/Pyongyang');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(278, 'Asia/Qatar');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(279, 'Asia/Qyzylorda');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(280, 'Asia/Rangoon');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(281, 'Asia/Riyadh');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(282, 'Asia/Riyadh87');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(283, 'Asia/Riyadh88');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(284, 'Asia/Riyadh89');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(285, 'Asia/Saigon');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(286, 'Asia/Sakhalin');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(287, 'Asia/Samarkand');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(288, 'Asia/Seoul');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(289, 'Asia/Shanghai');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(290, 'Asia/Singapore');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(291, 'Asia/Taipei');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(292, 'Asia/Tashkent');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(293, 'Asia/Tbilisi');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(294, 'Asia/Tehran');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(295, 'Asia/Tel_Aviv');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(296, 'Asia/Thimbu');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(297, 'Asia/Thimphu');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(298, 'Asia/Tokyo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(299, 'Asia/Ujung_Pandang');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(300, 'Asia/Ulaanbaatar');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(301, 'Asia/Ulan_Bator');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(302, 'Asia/Urumqi');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(303, 'Asia/Vientiane');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(304, 'Asia/Vladivostok');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(305, 'Asia/Yakutsk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(306, 'Asia/Yekaterinburg');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(307, 'Asia/Yerevan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(308, 'Atlantic/Azores');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(309, 'Atlantic/Bermuda');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(310, 'Atlantic/Canary');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(311, 'Atlantic/Cape_Verde');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(312, 'Atlantic/Faeroe');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(313, 'Atlantic/Faroe');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(314, 'Atlantic/Jan_Mayen');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(315, 'Atlantic/Madeira');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(316, 'Atlantic/Reykjavik');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(317, 'Atlantic/South_Georgia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(318, 'Atlantic/Stanley');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(319, 'Atlantic/St_Helena');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(320, 'Australia/ACT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(321, 'Australia/Adelaide');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(322, 'Australia/Brisbane');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(323, 'Australia/Broken_Hill');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(324, 'Australia/Canberra');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(325, 'Australia/Currie');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(326, 'Australia/Darwin');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(327, 'Australia/Eucla');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(328, 'Australia/Hobart');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(329, 'Australia/LHI');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(330, 'Australia/Lindeman');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(331, 'Australia/Lord_Howe');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(332, 'Australia/Melbourne');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(333, 'Australia/North');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(334, 'Australia/NSW');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(335, 'Australia/Perth');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(336, 'Australia/Queensland');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(337, 'Australia/South');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(338, 'Australia/Sydney');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(339, 'Australia/Tasmania');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(340, 'Australia/Victoria');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(341, 'Australia/West');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(342, 'Australia/Yancowinna');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(343, 'Brazil/Acre');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(344, 'Brazil/DeNoronha');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(345, 'Brazil/East');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(346, 'Brazil/West');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(347, 'Canada/Atlantic');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(348, 'Canada/Central');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(349, 'Canada/Eastern');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(350, 'Canada/East-Saskatchewan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(351, 'Canada/Mountain');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(352, 'Canada/Newfoundland');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(353, 'Canada/Pacific');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(354, 'Canada/Saskatchewan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(355, 'Canada/Yukon');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(356, 'CET');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(357, 'Chile/Continental');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(358, 'Chile/EasterIsland');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(359, 'CST6CDT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(360, 'Cuba');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(361, 'EET');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(362, 'Egypt');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(363, 'Eire');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(364, 'EST');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(365, 'EST5EDT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(366, 'Etc/GMT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(367, 'Etc/GMT0');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(368, 'Etc/GMT-0');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(369, 'Etc/GMT+0');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(370, 'Etc/GMT-1');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(371, 'Etc/GMT+1');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(372, 'Etc/GMT-10');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(373, 'Etc/GMT+10');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(374, 'Etc/GMT-11');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(375, 'Etc/GMT+11');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(376, 'Etc/GMT-12');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(377, 'Etc/GMT+12');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(378, 'Etc/GMT-13');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(379, 'Etc/GMT-14');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(380, 'Etc/GMT-2');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(381, 'Etc/GMT+2');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(382, 'Etc/GMT-3');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(383, 'Etc/GMT+3');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(384, 'Etc/GMT-4');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(385, 'Etc/GMT+4');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(386, 'Etc/GMT-5');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(387, 'Etc/GMT+5');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(388, 'Etc/GMT-6');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(389, 'Etc/GMT+6');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(390, 'Etc/GMT-7');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(391, 'Etc/GMT+7');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(392, 'Etc/GMT-8');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(393, 'Etc/GMT+8');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(394, 'Etc/GMT-9');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(395, 'Etc/GMT+9');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(396, 'Etc/Greenwich');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(397, 'Etc/UCT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(398, 'Etc/Universal');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(399, 'Etc/UTC');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(400, 'Etc/Zulu');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(401, 'Europe/Amsterdam');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(402, 'Europe/Andorra');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(403, 'Europe/Athens');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(404, 'Europe/Belfast');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(405, 'Europe/Belgrade');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(406, 'Europe/Berlin');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(407, 'Europe/Bratislava');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(408, 'Europe/Brussels');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(409, 'Europe/Bucharest');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(410, 'Europe/Budapest');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(411, 'Europe/Chisinau');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(412, 'Europe/Copenhagen');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(413, 'Europe/Dublin');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(414, 'Europe/Gibraltar');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(415, 'Europe/Guernsey');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(416, 'Europe/Helsinki');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(417, 'Europe/Isle_of_Man');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(418, 'Europe/Istanbul');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(419, 'Europe/Jersey');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(420, 'Europe/Kaliningrad');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(421, 'Europe/Kiev');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(422, 'Europe/Lisbon');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(423, 'Europe/Ljubljana');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(424, 'Europe/London');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(425, 'Europe/Luxembourg');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(426, 'Europe/Madrid');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(427, 'Europe/Malta');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(428, 'Europe/Mariehamn');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(429, 'Europe/Minsk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(430, 'Europe/Monaco');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(431, 'Europe/Moscow');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(432, 'Europe/Nicosia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(433, 'Europe/Oslo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(434, 'Europe/Paris');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(435, 'Europe/Podgorica');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(436, 'Europe/Prague');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(437, 'Europe/Riga');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(438, 'Europe/Rome');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(439, 'Europe/Samara');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(440, 'Europe/San_Marino');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(441, 'Europe/Sarajevo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(442, 'Europe/Simferopol');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(443, 'Europe/Skopje');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(444, 'Europe/Sofia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(445, 'Europe/Stockholm');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(446, 'Europe/Tallinn');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(447, 'Europe/Tirane');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(448, 'Europe/Tiraspol');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(449, 'Europe/Uzhgorod');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(450, 'Europe/Vaduz');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(451, 'Europe/Vatican');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(452, 'Europe/Vienna');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(453, 'Europe/Vilnius');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(454, 'Europe/Volgograd');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(455, 'Europe/Warsaw');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(456, 'Europe/Zagreb');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(457, 'Europe/Zaporozhye');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(458, 'Europe/Zurich');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(459, 'Factory');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(460, 'GB');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(461, 'GB-Eire');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(462, 'GMT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(463, 'GMT0');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(464, 'GMT-0');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(465, 'GMT+0');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(466, 'Greenwich');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(467, 'Hongkong');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(468, 'HST');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(469, 'Iceland');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(470, 'Indian/Antananarivo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(471, 'Indian/Chagos');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(472, 'Indian/Christmas');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(473, 'Indian/Cocos');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(474, 'Indian/Comoro');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(475, 'Indian/Kerguelen');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(476, 'Indian/Mahe');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(477, 'Indian/Maldives');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(478, 'Indian/Mauritius');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(479, 'Indian/Mayotte');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(480, 'Indian/Reunion');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(481, 'Iran');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(482, 'Israel');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(483, 'Jamaica');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(484, 'Japan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(485, 'Kwajalein');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(486, 'Libya');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(487, 'MET');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(488, 'Mexico/BajaNorte');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(489, 'Mexico/BajaSur');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(490, 'Mexico/General');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(491, 'Mideast/Riyadh87');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(492, 'Mideast/Riyadh88');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(493, 'Mideast/Riyadh89');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(494, 'MST');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(495, 'MST7MDT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(496, 'Navajo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(497, 'NZ');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(498, 'NZ-CHAT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(499, 'Pacific/Apia');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(500, 'Pacific/Auckland');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(501, 'Pacific/Chatham');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(502, 'Pacific/Easter');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(503, 'Pacific/Efate');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(504, 'Pacific/Enderbury');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(505, 'Pacific/Fakaofo');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(506, 'Pacific/Fiji');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(507, 'Pacific/Funafuti');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(508, 'Pacific/Galapagos');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(509, 'Pacific/Gambier');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(510, 'Pacific/Guadalcanal');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(511, 'Pacific/Guam');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(512, 'Pacific/Honolulu');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(513, 'Pacific/Johnston');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(514, 'Pacific/Kiritimati');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(515, 'Pacific/Kosrae');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(516, 'Pacific/Kwajalein');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(517, 'Pacific/Majuro');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(518, 'Pacific/Marquesas');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(519, 'Pacific/Midway');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(520, 'Pacific/Nauru');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(521, 'Pacific/Niue');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(522, 'Pacific/Norfolk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(523, 'Pacific/Noumea');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(524, 'Pacific/Pago_Pago');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(525, 'Pacific/Palau');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(526, 'Pacific/Pitcairn');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(527, 'Pacific/Ponape');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(528, 'Pacific/Port_Moresby');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(529, 'Pacific/Rarotonga');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(530, 'Pacific/Saipan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(531, 'Pacific/Samoa');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(532, 'Pacific/Tahiti');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(533, 'Pacific/Tarawa');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(534, 'Pacific/Tongatapu');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(535, 'Pacific/Truk');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(536, 'Pacific/Wake');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(537, 'Pacific/Wallis');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(538, 'Pacific/Yap');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(539, 'Poland');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(540, 'Portugal');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(541, 'PRC');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(542, 'PST8PDT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(543, 'ROC');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(544, 'ROK');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(545, 'Singapore');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(546, 'Turkey');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(547, 'UCT');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(548, 'Universal');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(549, 'US/Alaska');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(550, 'US/Aleutian');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(551, 'US/Arizona');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(552, 'US/Central');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(553, 'US/Eastern');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(554, 'US/East-Indiana');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(555, 'US/Hawaii');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(556, 'US/Indiana-Starke');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(557, 'US/Michigan');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(558, 'US/Mountain');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(559, 'US/Pacific');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(560, 'US/Samoa');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(561, 'UTC');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(562, 'WET');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(563, 'W-SU');
INSERT INTO VPBX_TZ(ID,TZ_NAME) VALUES(564, 'Zulu');

INSERT INTO VPBX_CURRENCY(CUR_ID,DESCRIPTION,CONVERSION_RATE) VALUES(1, 'Rur', 1 );
INSERT INTO VPBX_CURRENCY(CUR_ID,DESCRIPTION,CONVERSION_RATE) VALUES(2, 'Usd', 32 );
INSERT INTO VPBX_CURRENCY(CUR_ID,DESCRIPTION,CONVERSION_RATE) VALUES(3, 'Eur', 46 );

INSERT INTO VPBX_TARIFF(ID,NAME,MONTHLY_PRICE,DAILY_PRICE) VALUES(1,'Free',0,0);

INSERT INTO VPBX_DATE_FORMAT(ID,DATE_FORMAT_STR,DESCRIPTION) VALUES(1,'%Y/%m/%d %H:%M:%S', '2009/09/23 16:07:32');
INSERT INTO VPBX_DATE_FORMAT(ID,DATE_FORMAT_STR,DESCRIPTION) VALUES(2,'%d/%m/%Y %H:%M:%S', '23/09/2009 16:07:32');
INSERT INTO VPBX_DATE_FORMAT(ID,DATE_FORMAT_STR,DESCRIPTION) VALUES(3,'%m/%d/%Y %H:%M:%S', '09/23/2009 16:07:32');
INSERT INTO VPBX_DATE_FORMAT(ID,DATE_FORMAT_STR,DESCRIPTION) VALUES(4,'%m/%d/%Y %r', '09/23/2009 04:07:32 PM');
INSERT INTO VPBX_DATE_FORMAT(ID,DATE_FORMAT_STR,DESCRIPTION) VALUES(5,'%d/%m/%y %H:%M', '23/09/09 16:07');
INSERT INTO VPBX_DATE_FORMAT(ID,DATE_FORMAT_STR,DESCRIPTION) VALUES(6,'%a, %d %b %Y %H:%M:%S %Z', 'Wed, 23 Sep 2009 16:07:32 MSD');

INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('VirtualPBX DB version',1,unix_timestamp(),"select VERSION, FROM_UNIXTIME(TIME) 'LAST UPDATE' from VPBX_DB_INFO",240);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('Extensions type summary',1,unix_timestamp(),"select t.DESCRIPTION '=Type', count(*) 'Count=' from VPBX_VBOX_TYPE t, VPBX_VBOXES_CORE v where v.TYPE = t.ID group by t.DESCRIPTION",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('Messages size group by nodes',1,unix_timestamp(),"select SERVER_ID '=Node', round(sum(FILE_SIZE)/1024/1024,2) 'Size MB=' from VPBX_VBOXES_RECORD_FILES group by SERVER_ID",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('Tariffs stat',1,unix_timestamp(),"select t.NAME '=Tariff',count(*) 'Accounts=' from VPBX_TARIFF t, VPBX_ACCOUNTS u, VPBX_GROUPS g where u.GROUP_ID = g.GROUP_ID and t.ID = g.TARIFF_ID group by t.NAME",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('Languages stat',1,unix_timestamp(),"select l.LANG_NAME '=Language',l.DESCRIPTION '=Description',count(*) 'Accounts=' from VPBX_LANG l, VPBX_ACCOUNTS u where u.LANG = l.ID group by l.LANG_NAME",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('VoiceNumbers stat',1,unix_timestamp(),"select VOICENUMBER 'Voicenumber=',count(*) 'Accounts=' from VPBX_ACCOUNTS group by VOICENUMBER",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('Groups stat',1,unix_timestamp(),"select g.GROUP_NAME 'GroupName=',count(*) 'Accounts=' from VPBX_ACCOUNTS u, VPBX_GROUPS g where u.GROUP_ID = g.GROUP_ID group by g.GROUP_NAME",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Daily summary (previous day)',1,unix_timestamp(),"select date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d') Date, SERVER_ID NODE, count(*) 'Calls=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=', round(sum(SYS_COST),2) 'Cost (in units)=' from VPBX_CDRS where START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] group by date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d'),SERVER_ID",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Unknown calls',1,unix_timestamp(),"select date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d') Date, SERVER_ID NODE, count(*) 'Calls=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from VPBX_CDRS where SUBSCR_ID = 0 and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] group by date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d'), SERVER_ID", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Call type summary (previous day)',1,unix_timestamp(),"select CALL_TYPE '=Call Type', count(*) 'Calls=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from VPBX_CDRS where START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] group by CALL_TYPE order by CALL_TYPE", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Phone call direction (previous day)',1,unix_timestamp(),"select  'phone' GW,  count(*) 'Calls=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from  VPBX_CDRS  where   CALL_TYPE = 'internal' and  START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] group by  GW UNION select  'peer' GW,  count(*) 'Calls=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from  VPBX_CDRS  where   CALL_TYPE = 'transit' and  START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] and  DATA not like '%, GW=system%' group by  GW UNION select  'system' GW,  count(*) 'Calls=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from  VPBX_CDRS  where   CALL_TYPE = 'transit' and  START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] and  DATA like '%, GW=system%' group by  GW", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('IVR outgoing call direction (previous day)',1,unix_timestamp(),"select  'phone' GW,  count(*) 'Calls=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from  VPBX_CDRS_ACTIVITY where   TYPE in ( 'MultiDialout', 'Dialout', 'DISA', 'Transfer', 'Queue' ) and  START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] and  DATA like '%, GW=phone, %' group by  GW UNION select  'peer' GW,  count(*) 'Calls=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from  VPBX_CDRS_ACTIVITY where   TYPE in ( 'MultiDialout', 'Dialout', 'DISA', 'Transfer', 'Queue' ) and  START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] and  DATA like '%, GW=%' and   DATA not like '%, GW=direct, %' and DATA not like '%, GW=phone, %' and  DATA not like '%, GW=system, %' group by  GW UNION select  'direct' GW,  count(*) 'Calls=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from  VPBX_CDRS_ACTIVITY where   TYPE in ( 'MultiDialout', 'Dialout', 'DISA', 'Transfer', 'Queue' ) and  START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] and  DATA like '%, GW=direct, %' group by  GW UNION select  'system' GW,  count(*) 'Calls=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=',  round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from  VPBX_CDRS_ACTIVITY  where   TYPE in ( 'MultiDialout', 'Dialout', 'DISA', 'Transfer', 'Queue' ) and  START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] and  DATA like '%, GW=system, %' group by  GW", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Known calls',1,unix_timestamp(),"select date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d') Date, SERVER_ID NODE, count(*) 'Calls=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from VPBX_CDRS where SUBSCR_ID != 0 and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] group by date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d'), SERVER_ID", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Top 10 users (previous day)',1,unix_timestamp(),"select a.ACCESS_CODE, count(*) as Calls, round((sum(c.STOP_TIMESTAMP-c.START_TIMESTAMP))/60,1) 'Minutes=', round((sum(c.STOP_TIMESTAMP-c.START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from VPBX_CDRS c,  VPBX_ACCOUNTS a where a.ID = c.SUBSCR_ID and c.START_TIMESTAMP > [% DATE_START %] and c.START_TIMESTAMP < [% DATE_STOP %] group by a.ACCESS_CODE order by Calls desc limit 10", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Activities (previous day)',1,unix_timestamp(), "select TYPE Activities, count(*) as Count, round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from VPBX_CDRS_ACTIVITY where START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] group by TYPE order by Count desc",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('DID statistic (previous day)',1,unix_timestamp(), "select SUBSTRING_INDEX( c.CALLED_ID , '*', 1 ) AS DID, count(*) as Calls, round((sum(c.STOP_TIMESTAMP-c.START_TIMESTAMP))/60,1) 'Minutes=', round((sum(c.STOP_TIMESTAMP-c.START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=' from VPBX_CDRS c where c.CALL_TYPE = 'incoming' and c.START_TIMESTAMP > [% DATE_START %] and c.START_TIMESTAMP < [% DATE_STOP %] group by SUBSTRING_INDEX( c.CALLED_ID, '*', 1 ) order by Calls desc",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Billing - Top 10 users (previous day)',1,unix_timestamp(),"select a.ACCESS_CODE, count(*) as Calls, round((sum(c.STOP_TIMESTAMP-c.START_TIMESTAMP))/60,1) 'Minutes=', round(sum(SYS_COST),2) 'Cost (in units)=' from VPBX_CDRS c,  VPBX_ACCOUNTS a where a.ID = c.SUBSCR_ID and c.START_TIMESTAMP > [% DATE_START %] and c.START_TIMESTAMP < [% DATE_STOP %] group by a.ACCESS_CODE order by round(sum(SYS_COST),2) desc limit 10", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('DB summary',1,unix_timestamp(),"select TABLE_NAME as '=TABLE',TABLE_ROWS as 'ROWS=',AVG_ROW_LENGTH as 'AVG ROW LENGTH=',round((DATA_LENGTH/1024/1024),2) as 'DATA LENGTH (MB)=' ,round((INDEX_LENGTH/1024/1024),2)  'INDEX LENGTH (MB)=',AUTO_INCREMENT as 'AUTO INCREMENT=' from information_schema.TABLES where TABLE_SCHEMA='xvb'",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('System summary',1,unix_timestamp(),"select 'Accounts (all)' as '=param', count(*) as 'value=' from VPBX_ACCOUNTS union select 'Accounts ( with active status )', count(*) from VPBX_ACCOUNTS where STATUS=1 union select 'Extensions', count(*) from VPBX_VBOXES_CORE union select 'Messages cnt', count(*) from VPBX_VBOXES_RECORD_FILES union select 'Messages size (MB)', CONCAT(round(sum(FILE_SIZE)/1024/1024,2),' ') from VPBX_VBOXES_RECORD_FILES union select 'Phones (all)', count(*) from VPBX_SIPPEERS where PEER_TYPE=0 union select 'Phones (online)', count(*) from VPBX_SIPPEERS where PEER_TYPE=0 and unix_timestamp() < regseconds union select 'SIP Peers (all)', count(*) from VPBX_SIPPEERS where PEER_TYPE=1 union select 'SIP Peers (with registration)', count(*) from VPBX_SIPPEERS where PEER_TYPE=1 and NEED_REG=1 union select 'DIDs cnt', count(*) from VPBX_DIDS union select 'Shared DIDs cnt', count(DISTINCT VOICENUMBER) from VPBX_ACCOUNTS union select 'Balalnce (units)', round(sum(BALANCE),2) from VPBX_BALANCE union select 'CDR cnt', count(*) from VPBX_CDRS union select 'Activity records', count(*) from VPBX_CDRS_ACTIVITY union select 'Uniq Caller ID (incoming)', count(DISTINCT CALLER_ID) from VPBX_CDRS where CALL_TYPE='incoming' union select 'Uniq Called ID (transit)', count(DISTINCT CALLED_ID) from VPBX_CDRS where CALL_TYPE='transit' union select 'Journal records', count(*) from VPBX_JOURNAL union SELECT 'Data Base Size (MB)', round((sum( data_length + index_length ) / 1024 / 1024),2) FROM information_schema.TABLES where table_schema ='xvb' union SELECT 'Data Base Free space (MB)', round((sum(data_free) / 1024 / 1024),2) FROM information_schema.TABLES where table_schema ='xvb'",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Dropped calls /c-limit/ (previous day)',1,unix_timestamp(),"select date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d') Date, SERVER_ID NODE, count(*) 'Calls=' from VPBX_CDRS where DATA like '%TERM=PBX (c-limit)%' and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] group by date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d'),SERVER_ID",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('Phones UA',1,unix_timestamp(),"select useragent '=User agent',count(*) accounts from VPBX_SIPPEERS  where PEER_TYPE=0 group by useragent order by accounts desc",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Call terminated',1,unix_timestamp(),"select 'PBX (die)' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=PBX (die)%'  and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'PBX (unauthorized)' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=PBX (unauthorized)%'  and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'PBX (c-limit)' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=PBX (c-limit)%' and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'PBX (u-c-limit)' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=PBX (u-c-limit)%'  and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'PBX (locked)' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=PBX (locked)%' and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'PBX' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=PBX'  and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'in - IVR' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=IVR%'  and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'out - SRC' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=SRC%'  and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'out - DST' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=DST%' and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] union select 'in - USER' as '=Term', count(*) as 'count=' from VPBX_CDRS where DATA like '%TERM=USER%' and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %]",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Calls by groups',1,unix_timestamp(),"select g.GROUP_NAME 'Group', date_format(FROM_UNIXTIME(c.START_TIMESTAMP),'%Y-%m-%d') 'Date', count(*) 'Calls=', round((sum(c.STOP_TIMESTAMP-c.START_TIMESTAMP))/60,1) 'Minutes=', round((sum(c.STOP_TIMESTAMP-c.START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=', round(sum(c.SYS_COST),2) 'Cost (in units)=' from VPBX_CDRS c, VPBX_GROUPS g, VPBX_ACCOUNTS a where c.START_TIMESTAMP > [% DATE_START %] and c.START_TIMESTAMP < [% DATE_STOP %] and c.SUBSCR_ID = a.ID and a.GROUP_ID = g.GROUP_ID group by g.GROUP_NAME,date_format(FROM_UNIXTIME(c.START_TIMESTAMP),'%Y-%m-%d')",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Calls by hours (previous day)',1,unix_timestamp(),"select date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d-%H') Date, SERVER_ID NODE, count(*) 'Calls=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP))/60,1) 'Minutes=', round((sum(STOP_TIMESTAMP-START_TIMESTAMP)/count(*))/60,1) 'Minutes AVG=', round(sum(SYS_COST),2) 'Cost (in units)=' from VPBX_CDRS where START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] group by date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d-%H'),SERVER_ID",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER) values('Concurrent calls by hours/types',1,unix_timestamp(),"select START_TIMESTAMP,STOP_TIMESTAMP,CALL_TYPE from VPBX_CDRS cdr_h_s where STOP_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %]",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))","sub { my $in_data = shift; my $interval_substr = 13; my $ts = []; my $names = { all => 0, local => 1, transit => 2, internal => 3, callback => 4, callblast => 5, click2call => 6, alarmclock => 7, service => 8, incoming => 9, unknown => 10 }; unless ( scalar(@$in_data) ) { return ( [], ['Period','Calls','MaxCallsDate'] ); } my $min_start = int($in_data->[0]->{'START_TIMESTAMP'}); for ( my $i = 0; $i <= $#$in_data; $i++ ) { my $ref = $in_data->[$i]; foreach ( int($ref->{'START_TIMESTAMP'}) .. int($ref->{'STOP_TIMESTAMP'}) ) { if ( $_-$min_start > 0 ) { $ts->[$_-$min_start]->[0]++; $ts->[$_-$min_start]->[ $names->{ $ref->{'CALL_TYPE'} } || $names->{'unknown'} ]++; } } } my $rep_result = {}; my $time_format = sub { my @times = localtime( shift ); $times[5]+=1900; $times[4]+=1; return sprintf('%4.4d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d',$times[5],$times[4],$times[3],$times[2],$times[1],$times[0]); }; for ( my $i = 0; $i <= $#$ts; $i++ ) { my $key = substr(&$time_format($min_start+$i), 0, $interval_substr); if ( defined $ts->[$i] and $rep_result->{$key}->[1] < $ts->[$i]->[0] ) { $rep_result->{$key} = [ $min_start+$i ]; for ( 0 .. 10 ) { push @{$rep_result->{$key}}, ($ts->[$i]->[$_] || 0); } } } my $out_data = []; foreach my $k ( sort keys %$rep_result ) { push @$out_data, { Period => $k, MaxCallsDate => scalar(&$time_format($rep_result->{$k}->[0])), all => $rep_result->{$k}->[1], local => $rep_result->{$k}->[2], transit => $rep_result->{$k}->[3], internal => $rep_result->{$k}->[4], callback => $rep_result->{$k}->[5], callblast => $rep_result->{$k}->[6], click2call => $rep_result->{$k}->[7], alarmclock => $rep_result->{$k}->[8], service => $rep_result->{$k}->[9], incoming => $rep_result->{$k}->[10], unknown => $rep_result->{$k}->[11] }; } return ( $out_data, ['Period','MaxCallsDate','all','incoming','local','transit','internal','callback','callblast','click2call','alarmclock','service','unknown'] ); };");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER) values('Concurrent calls by hours',1,unix_timestamp(),"select START_TIMESTAMP,STOP_TIMESTAMP from VPBX_CDRS cdr_h where STOP_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %]",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))","sub { my $in_data = shift; my $interval_substr = 13; my $ts = []; unless ( scalar(@$in_data) ) { return ( [], ['Period','Calls','MaxCallsDate'] ); } my $min_start = int($in_data->[0]->{'START_TIMESTAMP'}); for ( my $i = 0; $i <= $#$in_data; $i++ ) { my $ref = $in_data->[$i]; foreach ( int($ref->{'START_TIMESTAMP'}) .. int($ref->{'STOP_TIMESTAMP'}) ) { if ( $_-$min_start > 0 ) { $ts->[$_-$min_start]++; } } } my $rep_result = {}; my $time_format = sub { my @times = localtime( shift ); $times[5]+=1900; $times[4]+=1; return sprintf('%4.4d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d',$times[5],$times[4],$times[3],$times[2],$times[1],$times[0]); }; for ( my $i = 0; $i <= $#$ts; $i++ ) { my $key = substr(&$time_format($min_start+$i), 0, $interval_substr); if ( defined $ts->[$i] and $rep_result->{ $key }->[0] < $ts->[$i] ) { $rep_result->{ $key } = [ $ts->[$i], $min_start+$i ]; } } my $out_data = []; foreach my $k ( sort keys %$rep_result ) { push @$out_data, { Period => $k, MaxCallsDate => scalar(&$time_format($rep_result->{$k}->[1])), Calls => $rep_result->{$k}->[0] }; } return ( $out_data, ['Period','Calls','MaxCallsDate'] ); };");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER) values('Concurrent calls by days',1,unix_timestamp(),"select START_TIMESTAMP,STOP_TIMESTAMP from VPBX_CDRS cdr_d where STOP_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %]",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))","sub { my $in_data = shift; my $interval_substr = 10; my $ts = []; unless ( scalar(@$in_data) ) { return ( [], ['Period','Calls','MaxCallsDate'] ); } my $min_start = int($in_data->[0]->{'START_TIMESTAMP'}); for ( my $i = 0; $i <= $#$in_data; $i++ ) { my $ref = $in_data->[$i]; foreach ( int($ref->{'START_TIMESTAMP'}) .. int($ref->{'STOP_TIMESTAMP'}) ) { if ( $_-$min_start > 0 ) { $ts->[$_-$min_start]++; } } } my $rep_result = {}; my $time_format = sub { my @times = localtime( shift ); $times[5]+=1900; $times[4]+=1; return sprintf('%4.4d-%2.2d-%2.2d %2.2d:%2.2d:%2.2d',$times[5],$times[4],$times[3],$times[2],$times[1],$times[0]); }; for ( my $i = 0; $i <= $#$ts; $i++ ) { my $key = substr(&$time_format($min_start+$i), 0, $interval_substr); if ( defined $ts->[$i] and $rep_result->{ $key }->[0] < $ts->[$i] ) { $rep_result->{ $key } = [ $ts->[$i], $min_start+$i ]; } } my $out_data = []; foreach my $k ( sort keys %$rep_result ) { push @$out_data, { Period => $k, MaxCallsDate => scalar(&$time_format($rep_result->{$k}->[1])), Calls => $rep_result->{$k}->[0] }; } return ( $out_data, ['Period','Calls','MaxCallsDate'] ); };");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Daily call cost summary',1,unix_timestamp(), "select date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d') Date, round(sum(SYS_COST),2) 'Cost=' from  VPBX_CDRS c where c.START_TIMESTAMP > [% DATE_START %] and c.START_TIMESTAMP < [% DATE_STOP %] group by date_format(FROM_UNIXTIME(START_TIMESTAMP),'%Y-%m-%d')", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,POST_FILTER) values('SIP Phones',1,unix_timestamp(),"select a.ACCESS_CODE, a.FIRST_NAME, a.LAST_NAME, sp.regseconds from VPBX_SIPPEERS sp, VPBX_ACCOUNTS a where a.ID = sp.SUBSCR_ID and  PEER_TYPE=0",3600,"sub {my $in_data = shift;my $result = {};unless ( scalar(@$in_data) ) {return ( [], ['ACCESS_CODE=','=FNAME','=LNAME','PHONES=','ONLINE='] );}for ( my $i = 0; $i <= $#$in_data; $i++ ) {my $ref = $in_data->[$i];unless ( exists $result->{ $ref->{'ACCESS_CODE'} } ) {$result->{ $ref->{'ACCESS_CODE'} } = {'ACCESS_CODE=' => $ref->{'ACCESS_CODE'},'=FNAME' => $ref->{'FIRST_NAME'},'=LNAME' => $ref->{'LAST_NAME'},'PHONES=' => 0,'ONLINE=' => 0 };}$result->{ $ref->{'ACCESS_CODE'} }->{'PHONES='}++;if ( $ref->{'regseconds'} > time ) {$result->{ $ref->{'ACCESS_CODE'} }->{'ONLINE='}++;}}my $out_data = [];foreach my $k ( sort keys %$result ) {push @$out_data, { %{$result->{$k}} };} return ( $out_data, ['ACCESS_CODE=','=FNAME','=LNAME','PHONES=','ONLINE='] );}");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('Disk utilisation. Top 200 tenants',1,unix_timestamp(),"select a.ACCESS_CODE, a.FIRST_NAME as '=FNAME', a.LAST_NAME as '=LNAME', count(*) as 'Files=', round((sum(f.FILE_SIZE)/1024/1024),3) as 'Size (MB)=' from VPBX_ACCOUNTS a, VPBX_VBOXES_RECORD_FILES f, VPBX_VBOXES_CORE v where a.ID = v.SUBSCR_ID and v.ID = f.ID group by a.ACCESS_CODE order by `Size (MB)=` desc limit 200",300);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER) values('Incoming calls by region',1,unix_timestamp(), "select DATA from VPBX_CDRS cdr_d where (START_TIMESTAMP > [% DATE_START %] or STOP_TIMESTAMP > [% DATE_START %] ) and START_TIMESTAMP < [% DATE_STOP %] and CALL_TYPE = 'incoming'",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))", "sub { my $in_data = shift; unless ( scalar(@$in_data) ) { return ( [], ['=Region','Calls'] ); } my %result; for ( my $i = 0; $i <= $#$in_data; $i++ ) { my $ref = $in_data->[$i]; my $data = $ref->{'DATA'}; if ( $data =~ /REGION=([^,]+)/ ) { my @chunks = split(/\\s*\\/\\s*/,$1); $result{ $chunks[$#chunks] }++; } else { $result{'unknown'}++; } } my $out_data = []; foreach my $k ( sort keys %result ) { push @$out_data, { '=Region' => $k, Calls => $result{$k} }; } return ( $out_data, ['=Region','Calls'] ); };" );
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER) values('Transit calls by region',1,unix_timestamp(), "select DATA from VPBX_CDRS cdr_d where (START_TIMESTAMP > [% DATE_START %] or STOP_TIMESTAMP > [% DATE_START %] ) and START_TIMESTAMP < [% DATE_STOP %] and CALL_TYPE = 'transit'",3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))", "sub { my $in_data = shift; unless ( scalar(@$in_data) ) { return ( [], ['=Region','Calls'] ); } my %result; for ( my $i = 0; $i <= $#$in_data; $i++ ) { my $ref = $in_data->[$i]; my $data = $ref->{'DATA'}; if ( $data =~ /REGION=([^,]+)/ ) { my @chunks = split(/\\s*\\/\\s*/,$1); $result{ $chunks[$#chunks] }++; } else { $result{'unknown'}++; } } my $out_data = []; foreach my $k ( sort keys %result ) { push @$out_data, { '=Region' => $k, Calls => $result{$k} }; } return ( $out_data, ['=Region','Calls'] ); };" );
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL) values('Audio files by size',1,unix_timestamp(), "select '< 0.5 M / ~  1 min' as 'File size=', count(*) 'Files=', round(sum(f.FILE_SIZE)/1024/1024,2) 'Total size MB=' from VPBX_VBOXES_RECORD_FILES f where f.FILE_SIZE <= 524288 and f.IS_VOICE = 1 union select '< 1.0 M / ~  2 min' as 'File size=', count(*) 'Files=', round(sum(f.FILE_SIZE)/1024/1024,2) 'Total size MB=' from VPBX_VBOXES_RECORD_FILES f where f.FILE_SIZE <= 1048576 and f.FILE_SIZE > 524288 and f.IS_VOICE = 1 union select '< 2.5 M / ~ 5 min' as 'File size=', count(*) 'Files=', round(sum(f.FILE_SIZE)/1024/1024,2) 'Total size MB=' from VPBX_VBOXES_RECORD_FILES f where f.FILE_SIZE <= 2621440 and f.FILE_SIZE > 1048576 and f.IS_VOICE = 1 union select '< 5.0 M / ~ 10 min' as 'File size=', count(*) 'Files=', round(sum(f.FILE_SIZE)/1024/1024,2) 'Total size MB=' from VPBX_VBOXES_RECORD_FILES f where f.FILE_SIZE < 5242880 and f.FILE_SIZE > 2621440 and f.IS_VOICE = 1 union select '> 5.0 M' as 'File size=', count(*) 'Files=', round(sum(f.FILE_SIZE)/1024/1024,2) 'Total size MB=' from VPBX_VBOXES_RECORD_FILES f where f.FILE_SIZE > 5242880 and f.IS_VOICE = 1", 3600 );
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Journal summary',1,unix_timestamp(), "select ACTION '=Action', count(*) as Amount from VPBX_JOURNAL where CREATE_TIMESTAMP > [% DATE_START %] and CREATE_TIMESTAMP < [% DATE_STOP %] group by ACTION", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Activity summary',1,unix_timestamp(), "select TYPE '=Activity', count(*) as Amount from VPBX_CDRS_ACTIVITY where CREATE_TIMESTAMP > [% DATE_START %] and CREATE_TIMESTAMP < [% DATE_STOP %] group by TYPE", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Journal actions. Top 10 tenants.',1,unix_timestamp(), "select a.ACCESS_CODE, a.FIRST_NAME, a.LAST_NAME, count(*) as 'Amount of actions=' from VPBX_ACCOUNTS a, VPBX_CDRS_ACTIVITY c  where a.ID = c.SUBSCR_ID and c.CREATE_TIMESTAMP > [% DATE_START %] and c.CREATE_TIMESTAMP < [% DATE_STOP %] group by a.ACCESS_CODE order by `Amount of actions=` desc limit 10", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP) values('Activity. Top 10 tenants.',1,unix_timestamp(), "select a.ACCESS_CODE, a.FIRST_NAME, a.LAST_NAME, count(*) as 'Amount of activities=' from VPBX_ACCOUNTS a, VPBX_JOURNAL c  where a.ID = c.SUBSCR_ID and c.CREATE_TIMESTAMP > [% DATE_START %] and c.CREATE_TIMESTAMP < [% DATE_STOP %]  group by a.ACCESS_CODE order by `Amount of activities=` desc limit 10", 3600,"UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),'%Y-%m-%d'))","UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),'%Y-%m-%d'))");
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER,ACCESS_ACCOUNTS) VALUES ('cdr-detailed',0,unix_timestamp(),'select CALLER_ID,CALLED_ID,STOP_TIMESTAMP,START_TIMESTAMP,FROM_UNIXTIME(START_TIMESTAMP,\'%d/%m/%Y %h:%i:%s\') DATE,DATA from VPBX_CDRS where  CREATE_TIMESTAMP > [% DATE_START %] and CREATE_TIMESTAMP < [% DATE_STOP %] and SUBSCR_ID = [% SUBSCR_ID %] order by START_TIMESTAMP limit 40000',180,'UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),\'%Y-%m-%d\'))','UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),\'%Y-%m-%d\'))','sub {\n    my $in_data = shift;\n\n    unless ( scalar(@$in_data) ) {\n        return ( [], [\'Date\',\'Caller-ID\',\'Called-ID\',\'RingTime\',\'TalkTime\',\'TotalTime\',\'Status\'] );\n    }\n\n    my $result = [];\n\n    for ( my $i = 0; $i <= $#$in_data; $i++ ) {\n\n        my $ref = $in_data->[$i];\n\n        my $status = \'\';\n        my ( $ring_time, $talk_time, $total_time );\n\n        if ( $ref->{\'DATA\'} =~ /STATUS=([^\\s,]+)/ ) {\n            $status = $1;\n        }\n\n        if ( $status =~ /ANSWER/ ) {\n            if ( $ref->{\'DATA\'} =~ /DURATION=([\\d.]+),/ ) {\n                $talk_time = $1;\n                $ring_time = int($ref->{\'STOP_TIMESTAMP\'} - $ref->{\'START_TIMESTAMP\'} - $1);\n            } else {\n                $ring_time = int($ref->{\'STOP_TIMESTAMP\'} - $ref->{\'START_TIMESTAMP\'});\n                $talk_time = 0;\n            }\n        } else {\n            $ring_time = int($ref->{\'STOP_TIMESTAMP\'} - $ref->{\'START_TIMESTAMP\'});\n        }\n        push @{$result}, {  Date => $ref->{\'DATE\'},\n                        \'Caller-ID=\' => $ref->{\'CALLER_ID\'},\n                        \'Called-ID=\' => $ref->{\'CALLED_ID\'},\n                        \'RingTime=\' => int($ring_time),\n                        \'TalkTime=\' => int($talk_time),\n                        \'TotalTime=\' => int($ring_time+$talk_time),\n                        \'Status\' => ($status||\'Unknown\')\n                        };\n    }\n    return ( $result, [\'Date\',\'Caller-ID=\',\'Called-ID=\',\'RingTime=\',\'TalkTime=\',\'TotalTime=\',\'Status\'] );\n};','0');
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER,ACCESS_ACCOUNTS) VALUES ('uniq-did',0,unix_timestamp(),'select CALLED_ID,START_TIMESTAMP, STOP_TIMESTAMP, DATA,FROM_UNIXTIME(START_TIMESTAMP,\'%d/%m/%Y %h:%i:%s\') DATE  from VPBX_CDRS where CALL_TYPE = \'transit\'  and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] and SUBSCR_ID = [% SUBSCR_ID %] limit 40000',180,'UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),\'%Y-%m-%d\'))','UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),\'%Y-%m-%d\'))','sub {\n    my $in_data = shift;\n\n    unless ( scalar(@$in_data) ) {\n        return ( [], [\'Called=\', \'Date\', \'Calls=\',\'Answered=\',\'TotalTime=\'] );\n    }\n    my %result;\n\n    for ( my $i = 0; $i <= $#$in_data; $i++ ) {\n        my $ref = $in_data->[$i];\n        unless ( exists $result{ $ref->{\'CALLED_ID\'} } ) {\n            $result{ $ref->{\'CALLED_ID\'} } = {\n                    \'Called=\' => $ref->{\'CALLED_ID\'},\n                    \'Calls=\'  => 0,\n                    \'Answered=\' => 0,\n                    \'Date\' => $ref->{\'DATE\'},\n                    \'TotalTime\' => 0\n            }\n        }\n\n        my $data = $ref->{\'DATA\'};\n\n        $result{ $ref->{\'CALLED_ID\'} }->{\'Calls=\'}++;\n\n        if ( $data =~ /STATUS=ANSWER/ ) {\n            $result{ $ref->{\'CALLED_ID\'} }->{\'Answered=\'}++;\n        }\n        $result{ $ref->{\'CALLED_ID\'} }->{\'TotalTime\'} += $ref->{\'STOP_TIMESTAMP\'} - $ref->{\'START_TIMESTAMP\'};\n    }\n\n    my $out_data = [];\n\n    my $t_fmt = sub {\n        my $duration = $_[0] || 0;\n\n        my $h = int($duration/3600);\n        my $m = int($duration%3600/60);\n        my $s = int($duration%60);\n        $duration = sprintf(\'%2.2d:%2.2d:%2.2d\', $h, $m, $s );\n\n        return $duration;\n    };\n\n    foreach my $k ( sort keys %result ) {\n        $result{$k}->{\'TotalTime\'} = &$t_fmt(int($result{$k}->{\'TotalTime\'}));\n        push @$out_data, $result{$k};\n    }\n    return ( $out_data, [\'Called=\', \'Date\', \'Calls=\',\'Answered=\',\'TotalTime\'] );\n};','0');
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER,ACCESS_ACCOUNTS) VALUES ('GW usage by caller',0,unix_timestamp(),'select CALLER_ID, DATA from VPBX_CDRS where CALL_TYPE = \'transit\'  and START_TIMESTAMP > [% DATE_START %] and START_TIMESTAMP < [% DATE_STOP %] and SUBSCR_ID = [% SUBSCR_ID %] limit 40000',60,'UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),\'%Y-%m-%d\'))','UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),\'%Y-%m-%d\'))','sub {\r\n    my $in_data = shift;\r\n\r\n    unless ( scalar(@$in_data) ) {\r\n        return ( [], [\'Caller=\',\'Calls=\',\'GW=\',\'Minutes=\',\'ASR=\',\'ACD=\'] );\r\n    }\r\n    my %result;\r\n\r\n    for ( my $i = 0; $i <= $#$in_data; $i++ ) {\r\n        my $ref = $in_data->[$i];\r\n                \r\n            my $duration = 0;\r\n           my ( $gw, $is_answered );\r\n\r\n               if ( $ref->{\'DATA\'} =~ /GW=([^,]+)/ ) {\r\n                   $gw = $1;\r\n           }\r\n           if ( $ref->{\'DATA\'} =~ /DURATION=(\\d+)/ ) {\r\n                      $duration = $1;\r\n             }\r\n           if ( $ref->{\'DATA\'} =~ /STATUS=ANSWER/ ) {\r\n                        $is_answered = 1;\r\n           } else {\r\n                    $is_answered = 0;\r\n           }\r\n\r\n        unless ( exists $result{ $ref->{\'CALLER_ID\'} .\'-\'. $gw } ) {\r\n            $result{ $ref->{\'CALLER_ID\'}.\'-\'. $gw } = {\r\n                    \'Caller=\' => $ref->{\'CALLER_ID\'},\r\n                    \'Calls=\'  => 0,\r\n                    \'ASR=\' => 0,\r\n                    \'ACD=\' => 0,\r\n                                  \'Minutes=\' => 0,\r\n                    \'GW=\' => $gw,\r\n                                   \'Answered\' => 0\r\n            }\r\n        }\r\n\r\n         $result{ $ref->{\'CALLER_ID\'}.\'-\'. $gw }->{\'Calls=\'}++;\r\n\r\n        if ( $is_answered ) {\r\n                   $result{ $ref->{\'CALLER_ID\'}.\'-\'. $gw }->{\'Answered\'}++;\r\n                      $result{ $ref->{\'CALLER_ID\'}.\'-\'. $gw }->{\'Minutes=\'} += int($duration);\r\n        }\r\n    }\r\n\r\n    my $out_data = [];\r\n\r\n    my $t_fmt = sub {\r\n        my $duration = $_[0] || 0;\r\n\r\n        my $h = int($duration/3600);\r\n        my $m = int($duration%3600/60);\r\n        my $s = int($duration%60);\r\n        $duration = sprintf(\'%2.2d:%2.2d:%2.2d\', $h, $m, $s );\r\n\r\n        return $duration;\r\n    };\r\n\r\n    foreach my $k ( sort keys %result ) {\r\n          if ($result{$k}->{\'Answered\'}) {\r\n          $result{$k}->{\'ACD=\'} = &$t_fmt(int($result{$k}->{\'Minutes=\'} / $result{$k}->{\'Answered\'}));\r\n          }\r\n           if ($result{$k}->{\'Calls=\'}) {\r\n            $result{$k}->{\'ASR=\'} = int($result{$k}->{\'Answered\'} / $result{$k}->{\'Calls=\'} * 100);\r\n               }\r\n           $result{$k}->{\'Minutes=\'} = &$t_fmt(int($result{$k}->{\'Minutes=\'}));\r\n\r\n        push @$out_data, $result{$k};\r\n    }\r\n      return ( $out_data, [\'Caller=\',\'Calls=\',\'GW=\',\'Minutes=\',\'ASR=\',\'ACD=\'] );\r\n};',0);
INSERT INTO VPBX_REPORTS (NAME,TYPE,CREATE_TIMESTAMP,QUERY,TTL,DATE_START,DATE_STOP,POST_FILTER,ACCESS_ACCOUNTS) VALUES ('Outbound stat',0,unix_timestamp(),'select CALLER_ID,CNAM,CALLED_ID,STOP_TIMESTAMP-START_TIMESTAMP DURATION,DATA from VPBX_CDRS where CALL_TYPE = \'transit\'  and CREATE_TIMESTAMP > [% DATE_START %] and CREATE_TIMESTAMP < [% DATE_STOP %] and SUBSCR_ID = [% SUBSCR_ID %]',60,'UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 1 day),\'%Y-%m-%d\'))','UNIX_TIMESTAMP(date_format(date_sub(curdate(),interval 0 day),\'%Y-%m-%d\'))','sub {\n    my $in_data = shift;\n\n    unless ( scalar(@$in_data) ) {\n            return ( [], [\'=Agent\',\'=Name\',\'Calls\',\'UniqCalls\',\'RingTime\',\'TalkTime\',\'TotalTime\',\'Answer\',\'Calls-3-10\',\'Calls-10\',\'NoAnswer\'] );\n    }\n    my %result;\n    my %uniq_calls;\n\n    for ( my $i = 0; $i <= $#$in_data; $i++ ) {\n        my $ref = $in_data->[$i];\n        unless ( exists $result{ $ref->{\'CALLER_ID\'} } ) {\n                   $uniq_calls{ $ref->{\'CALLER_ID\'} } = {};\n            $result{ $ref->{\'CALLER_ID\'} } = {\n                    \'=Agent\' => $ref->{\'CALLER_ID\'},\n                    \'=Name\' => $ref->{\'CNAM\'},\n                    \'Calls\'  => 0,\n                    \'UniqCalls\'  => 0,\n                    \'Calls-3-10\'  => 0,\n                    \'Calls-10\'  => 0,\n                    \'RingTime\' => 0,\n                    \'TalkTime\' => 0,\n                    \'TotalTime\' => 0,\n                    \'Answer\' => 0,\n                    \'NoAnswer\' => 0\n            }\n        }\n\n        my $data = $ref->{\'DATA\'};\n                        \n              if ( not exists $uniq_calls{ $ref->{\'CALLER_ID\'} }->{ $ref->{\'CALLED_ID\'} } ) {     \n                      $result{ $ref->{\'CALLER_ID\'} }->{\'UniqCalls\'}++;\n                  $uniq_calls{ $ref->{\'CALLER_ID\'} }->{ $ref->{\'CALLED_ID\'} } = 1;    \n              }\n\n        if ( $data =~ /STATUS=ANSWER/ ) {\n            $result{ $ref->{\'CALLER_ID\'} }->{\'Answer\'}++;\n            if ( $data =~ /DURATION=([\\d.]+),/ ) {\n                            if ( $1 >=180 and $1 < 600 ) {\n                        $result{ $ref->{\'CALLER_ID\'} }->{\'Calls-3-10\'}++;\n                         } elsif ( $1 >= 600 ) {\n                       $result{ $ref->{\'CALLER_ID\'} }->{\'Calls-10\'}++;\n                           }\n                $result{ $ref->{\'CALLER_ID\'} }->{\'TalkTime\'} += $1;\n                $result{ $ref->{\'CALLER_ID\'} }->{\'RingTime\'} += ($ref->{\'DURATION\'} - $1);\n            } else {\n                $result{ $ref->{\'CALLER_ID\'} }->{\'RingTime\'} += $ref->{\'DURATION\'};\n            }\n        } else {\n            $result{ $ref->{\'CALLER_ID\'} }->{\'NoAnswer\'}++;\n            $result{ $ref->{\'CALLER_ID\'} }->{\'RingTime\'} += $ref->{\'DURATION\'};\n        }\n        $result{ $ref->{\'CALLER_ID\'} }->{\'TotalTime\'} += $ref->{\'DURATION\'};\n        $result{ $ref->{\'CALLER_ID\'} }->{\'Calls\'}++;\n    }\n\n    my $out_data = [];\n\n    my $t_fmt = sub {\n        my $duration = $_[0] || 0;\n\n        my $h = int($duration/3600);\n        my $m = int($duration%3600/60);\n        my $s = int($duration%60);\n        $duration = sprintf(\'%2.2d:%2.2d:%2.2d\', $h, $m, $s );\n\n        return $duration;\n    };\n\n    foreach my $k ( sort keys %result ) {\n        $result{$k}->{\'TalkTime\'} = &$t_fmt($result{$k}->{\'TalkTime\'});\n        $result{$k}->{\'RingTime\'} = &$t_fmt($result{$k}->{\'RingTime\'});\n        $result{$k}->{\'TotalTime\'} = &$t_fmt($result{$k}->{\'TotalTime\'});\n        push @$out_data, $result{$k};\n    }\n    return ( $out_data, [\'=Agent\',\'=Name\',\'Calls\',\'UniqCalls\',\'RingTime\',\'TalkTime\',\'TotalTime\',\'Answer\',\'Calls-3-10\',\'Calls-10\',\'NoAnswer\'] );\n};\n',0);

INSERT INTO VPBX_NODES (NODE_ID,NODE_IP,DOWNLOAD_IP,NODE_DESC) values('DEFAULT_NODE','127.0.0.1','https://127.0.0.1','Default node');
INSERT INTO VPBX_GROUPS (GROUP_ID,GROUP_NAME,SERVER_ID,CUSTOM_ROUTE,CUSTOM_FILES) values(1,'default','DEFAULT_NODE',1,1);
INSERT INTO VPBX_GROUPS (GROUP_ID,GROUP_NAME,SERVER_ID,CUSTOM_ROUTE,CUSTOM_FILES,ALLOW_MACROS,MAX_EXTENSIONS,SUB_TEMPLATE_DIR) values(2,'SVB-Free','DEFAULT_NODE',0,0,0,1,'single');

INSERT INTO VPBX_ACCOUNTS(ID,GROUP_ID,VOICENUMBER,ACCESS_CODE,STATUS) values(0,1,'ANY0NE','ANY0NE',0);
UPDATE VPBX_ACCOUNTS set ID=0 where ACCESS_CODE='ANY0NE' and VOICENUMBER='ANY0NE';

insert into VPBX_SEQUENCES(SEC_NAME,SEC_VAL) values('ACCESS_CODE',10000+(ROUND(RAND()*1000)));
insert into VPBX_SEQUENCES(SEC_NAME,SEC_VAL) values('PHONEID',unix_timestamp());

INSERT INTO VPBX_NOTIFY_TYPE(NOTIFY_ID,DESCRIPTION,NAME) VALUES(0, 'Not send', 'none' );
INSERT INTO VPBX_NOTIFY_TYPE(NOTIFY_ID,DESCRIPTION,NAME) VALUES(1, 'Email', 'Email' );
INSERT INTO VPBX_NOTIFY_TYPE(NOTIFY_ID,DESCRIPTION,NAME) VALUES(2, 'Twitter', 'Twitter' );

insert into VPBX_DIRECTORY_LANG(ID,DESCRIPTION) VALUES( 0, 'All');
insert into VPBX_DIRECTORY_LANG(ID,DESCRIPTION,CH_2,CH_3,CH_4,CH_5,CH_6,CH_7,CH_8,CH_9) VALUES( 1, 'English', 'abc','def','ghi','jkl','mno','pqrs','tuv','wxyz' );
insert into VPBX_DIRECTORY_LANG(ID,DESCRIPTION,CH_2,CH_3,CH_4,CH_5,CH_6,CH_7,CH_8,CH_9) VALUES( 2, 'Russian', 'абвгАБВГ','дежзДЕЖЗ','ийклИЙКЛ','мноМНО','прсПРС','туфхТУФХ','цчшщъЦЧШЩЪ','ыьэюяЫЬЭЮЯ' );

insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('sbc.megafon.ru','Multiphon',0,"$_[0]->{'REG_EXPIRE'}='60'; $_[0]->{'REG_USERNAME'} = $_[0]->{'username'}.'@multifon.ru'; $_[0]->{'fromdomain'}='multifon.ru'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='inband'; $_[0]->{'disallow'}='all'; $_[0]->{'allow'}='ulaw'; $_[0]->{'port'}='5060'; $_[0]->{'insecure'}='port,invite';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('voice.telphin.com','Telphin',0,"$_[0]->{'fromdomain'}='voice.telphin.com'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'allow'}='alaw,ulaw'; $_[0]->{'port'}='5068';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('sipproxy.telphin.com','Telphin.Office',0,"$_[0]->{'fromdomain'}='sipproxy.telphin.com'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'allow'}='alaw,ulaw'; $_[0]->{'port'}='5068';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('sipnet.ru','Sipnet',0,"$_[0]->{'fromdomain'}='sipnet.ru'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'allow'}='alaw,ulaw'; $_[0]->{'port'}='5060';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('sip.skype.com','Skype Connect',0,"$_[0]->{'fromdomain'}='sip.skype.com'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'insecure'}='port,invite'; $_[0]->{'allow'}='ulaw,alaw'; $_[0]->{'port'}='5060';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('voip.mtt.ru','YouMagic MTT',0,"$_[0]->{'fromdomain'}='voip.mtt.ru'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'insecure'}='port,invite'; $_[0]->{'allow'}='ulaw,alaw'; $_[0]->{'port'}='5060';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('sip.zadarma.com','Zadarma',0,"$_[0]->{'fromdomain'}='sip.zadarma.com'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'insecure'}='invite'; $_[0]->{'allow'}='ulaw,alaw'; $_[0]->{'nat'}='yes'; $_[0]->{'port'}='5060';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('pbx.zadarma.com','ZadarmaPBX',0,"$_[0]->{'fromdomain'}='pbx.zadarma.com'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'insecure'}='invite'; $_[0]->{'allow'}='ulaw,alaw'; $_[0]->{'nat'}='yes'; $_[0]->{'port'}='5060';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('voip.domru.ru','DOM.RU',0,"$_[0]->{'fromdomain'}='voip.domru.ru'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; my $suff_lenght = 7; if ( $_[0]->{'DESCRIPTION'} =~ m#/(\\d+)$# ) { $suff_lenght = $1 }; $suff_lenght = -1 * $suff_lenght; $_[0]->{'REG_AUTHNAME'} = substr($_[0]->{'username'},$suff_lenght); $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'insecure'}='port,invite'; $_[0]->{'allow'}='alaw,ulaw'; $_[0]->{'nat'}='yes'; $_[0]->{'port'}='5060';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('mpbx.sip.beeline.ru','BeeLine-OLD',1,"$_[0]->{'REG_EXPIRE'}='60'; $_[0]->{'REG_USERNAME'} = $_[0]->{'username'}.'@mpbx.sip.beeline.ru'; $_[0]->{'fromdomain'}='mpbx.sip.beeline.ru'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'allow'}='ulaw,alaw'; $_[0]->{'port'}='5060'; $_[0]->{'insecure'}='port,invite';");
insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('ip.beeline.ru','Beeline',0,"$_[0]->{'REG_EXPIRE'}='60'; $_[0]->{'REG_USERNAME'} = $_[0]->{'username'}.'@ip.beeline.ru';$_[0]->{'fromdomain'}='ip.beeline.ru';$_[0]->{'videosupport'}='no';$_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'allow'}='ulaw,alaw'; $_[0]->{'port'}='5060'; $_[0]->{'insecure'}='port,invite';");
-- insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('.vpbx.mts.ru','MTS FMC',1,"$_[0]->{'REG_EXPIRE'}='1200';$_[0]->{'REG_USERNAME'}=$_[0]->{'username'}.'@'.$_[0]->{'fromdomain'};$_[0]->{'REG_AUTHNAME'}=$_[0]->{'defaultuser'}=$_[0]->{'fromuser'};$_[0]->{'videosupport'}='no';$_[0]->{'dtmfmode'}='rfc2833';$_[0]->{'disallow'}='all'; $_[0]->{'allow'}='ulaw,alaw'; $_[0]->{'port'}='5060'; $_[0]->{'insecure'}='port,invite';");
-- insert into VPBX_SIPPEERS_TEMPLATES(HOST,NAME,HIDE,DATA) VALUES('vpbx.sipout.net','SipOut.Net',0,"$_[0]->{'fromdomain'}='vpbx.sipout.net'; $_[0]->{'videosupport'}='no'; $_[0]->{'fromuser'}=$_[0]->{'defaultuser'}=$_[0]->{'username'}; $_[0]->{'dtmfmode'}='rfc2833'; $_[0]->{'disallow'}='all'; $_[0]->{'allow'}='g722,ulaw,alaw'; $_[0]->{'nat'}='yes'; $_[0]->{'port'}='5060';");

insert into VPBX_ROUTES_TEMPLATES(PATTERN,NAME) values('[87]9\\d{9}','call 2 cell');
insert into VPBX_ROUTES_TEMPLATES(PATTERN,NAME) values('810.*','call 2 internationals');
insert into VPBX_ROUTES_TEMPLATES(PATTERN,NAME) values('[87]\\d{10}','call 2 inter city');
insert into VPBX_ROUTES_TEMPLATES(PATTERN,NAME) values('[87]800\\d{7}','call 2 toll free');
insert into VPBX_ROUTES_TEMPLATES(PATTERN,NAME) values('[87]809\\d{7}','call 2 toll');
insert into VPBX_ROUTES_TEMPLATES(PATTERN,NAME) values('\\d{7}','call 2 7digits');
insert into VPBX_ROUTES_TEMPLATES(PATTERN,NAME) values('\\d{6}','call 2 6digits');
insert into VPBX_ROUTES_TEMPLATES(PATTERN,NAME) values('[87]954\\d{9}','ru-satellite');

insert into VPBX_DIDS_ATTR(DID,LANG_ID) VALUES( '613', 0 );

insert into VPBX_SIPPEERS(DATA_ID,name,context,SUBSCR_ID,DESCRIPTION,PEER_TYPE) values(-1,'%SYSTEM%','default',0,'system',1);

-- roles template
INSERT INTO VPBX_ROLES(IS_TEMPLATE, LANG_ID, LOGIN, PASSWORD, DESCRIPTION, ACTION_ACT_LIST_ALL, ACTION_ACT_LIST, ACTION_AGENT_STATUS, ACTION_BACKUP, ACTION_C2C_ADD, ACTION_C2C_DEL, ACTION_C2C_LIST, ACTION_C2C_UPDATE, ACTION_CALLBLAST_ADD, ACTION_CALLBLAST_DEL_CACHE, ACTION_CALLBLAST_DEL, ACTION_CALLBLAST_UPDATE, ACTION_CALLOUT_CLEAN, ACTION_CALLS_HANGUP, ACTION_CALLS_LIST, ACTION_CDR_LIST, ACTION_CID_ADD, ACTION_CID_DEL, ACTION_CID_LIST, ACTION_CID_UPDATE, ACTION_CRM_ADD, ACTION_CRM_DEL, ACTION_CRM_INFO, ACTION_CRM_LIST, ACTION_CRM_N_ADD, ACTION_CRM_N_DEL, ACTION_CRM_N_UPDATE, ACTION_CRM_UPDATE, ACTION_DASHBOARD_LIST, ACTION_DASHBOARD_LOAD_LIST, ACTION_DIR_ADD, ACTION_DIR_DEL, ACTION_DIR_UPDATE, ACTION_EXT_BACKUP, ACTION_EXTENDED_STAT, ACTION_EXT_RESTORE, ACTION_EXT_STAT, ACTION_FBSHARE, ACTION_GET_ITUNES_ALL, ACTION_GET_ITUNES, ACTION_GET_RSS_ALL, ACTION_GET_RSS, ACTION_GOTOIF_ADD, ACTION_GOTOIF_DEL, ACTION_GOTOIF_UPDATE, ACTION_INTEGRATION_LIST, ACTION_IVRFLOW_LIST, ACTION_J_LIST, ACTION_LIST_GET, ACTION_MACROS_ADD, ACTION_MACROS_DEL, ACTION_MACROS_LIST, ACTION_MACROS_UPDATE, ACTION_MENU, ACTION_MSG_CLEANUP, ACTION_MSG_DELETE, ACTION_MSG_DOWNLOAD, ACTION_MSG_LIST_ALL, ACTION_MSG_LIST, ACTION_MSG_STATUS, ACTION_MSG_UPLOAD, ACTION_MULTIDIALOUT_ADD, ACTION_MULTIDIALOUT_DEL, ACTION_MULTIDIALOUT_RESET, ACTION_MULTIDIALOUT_UPDATE, ACTION_PBOOK_ADD, ACTION_PBOOK_DEL, ACTION_PBOOK_LIST, ACTION_PBOOK_UPDATE, ACTION_PEER_ADD, ACTION_PEER_DEL, ACTION_PEER_LIST, ACTION_PEER_UPDATE, ACTION_PHONE_ADD, ACTION_PHONE_DEL, ACTION_PHONE_INFO, ACTION_PHONE_LIST, ACTION_PHONE_UPDATE, ACTION_RESTORE, ACTION_ROLE_ADD, ACTION_ROLE_DEL, ACTION_ROLE_LIST, ACTION_ROLE_INFO, ACTION_ROLE_UPDATE, ACTION_ROUTE_ADD, ACTION_ROUTE_DEL, ACTION_ROUTE_LIST, ACTION_ROUTE_UPDATE, ACTION_SCHEDULE_ADD, ACTION_SCHEDULE_DEL, ACTION_SCHEDULE_UPDATE, ACTION_START, ACTION_SV_UPDATE, ACTION_SYSMEDIA_ADD, ACTION_SYSMEDIA_DEL, ACTION_SYSMEDIA_LIST, ACTION_USER_INFO, ACTION_USER_UPDATE, ACTION_VB_ADD, ACTION_VB_CHANGE_TYPE, ACTION_VB_CLONE, ACTION_VB_DEL, ACTION_VB_LIST, ACTION_VB_UPDATE, ACTION_VB_VIEW, ACTION_VOTING_CLEAN, ACTION_PERM_ROOT_ACCESS, ACTION_DEFAULT, ACTION_REPORT_LIST, ACTION_REPORT_RUN, ACTION_PERM_CDR_STAT ) VALUES (1,0,'admin',       '','admin role',       1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
INSERT INTO VPBX_ROLES(IS_TEMPLATE, LANG_ID, LOGIN, PASSWORD, DESCRIPTION, ACTION_ACT_LIST_ALL, ACTION_ACT_LIST, ACTION_AGENT_STATUS, ACTION_BACKUP, ACTION_C2C_ADD, ACTION_C2C_DEL, ACTION_C2C_LIST, ACTION_C2C_UPDATE, ACTION_CALLBLAST_ADD, ACTION_CALLBLAST_DEL_CACHE, ACTION_CALLBLAST_DEL, ACTION_CALLBLAST_UPDATE, ACTION_CALLOUT_CLEAN, ACTION_CALLS_HANGUP, ACTION_CALLS_LIST, ACTION_CDR_LIST, ACTION_CID_ADD, ACTION_CID_DEL, ACTION_CID_LIST, ACTION_CID_UPDATE, ACTION_CRM_ADD, ACTION_CRM_DEL, ACTION_CRM_INFO, ACTION_CRM_LIST, ACTION_CRM_N_ADD, ACTION_CRM_N_DEL, ACTION_CRM_N_UPDATE, ACTION_CRM_UPDATE, ACTION_DASHBOARD_LIST, ACTION_DASHBOARD_LOAD_LIST, ACTION_DIR_ADD, ACTION_DIR_DEL, ACTION_DIR_UPDATE, ACTION_EXT_BACKUP, ACTION_EXTENDED_STAT, ACTION_EXT_RESTORE, ACTION_EXT_STAT, ACTION_FBSHARE, ACTION_GET_ITUNES_ALL, ACTION_GET_ITUNES, ACTION_GET_RSS_ALL, ACTION_GET_RSS, ACTION_GOTOIF_ADD, ACTION_GOTOIF_DEL, ACTION_GOTOIF_UPDATE, ACTION_INTEGRATION_LIST, ACTION_IVRFLOW_LIST, ACTION_J_LIST, ACTION_LIST_GET, ACTION_MACROS_ADD, ACTION_MACROS_DEL, ACTION_MACROS_LIST, ACTION_MACROS_UPDATE, ACTION_MENU, ACTION_MSG_CLEANUP, ACTION_MSG_DELETE, ACTION_MSG_DOWNLOAD, ACTION_MSG_LIST_ALL, ACTION_MSG_LIST, ACTION_MSG_STATUS, ACTION_MSG_UPLOAD, ACTION_MULTIDIALOUT_ADD, ACTION_MULTIDIALOUT_DEL, ACTION_MULTIDIALOUT_RESET, ACTION_MULTIDIALOUT_UPDATE, ACTION_PBOOK_ADD, ACTION_PBOOK_DEL, ACTION_PBOOK_LIST, ACTION_PBOOK_UPDATE, ACTION_PEER_ADD, ACTION_PEER_DEL, ACTION_PEER_LIST, ACTION_PEER_UPDATE, ACTION_PHONE_ADD, ACTION_PHONE_DEL, ACTION_PHONE_INFO, ACTION_PHONE_LIST, ACTION_PHONE_UPDATE, ACTION_RESTORE, ACTION_ROLE_ADD, ACTION_ROLE_DEL, ACTION_ROLE_LIST, ACTION_ROLE_INFO, ACTION_ROLE_UPDATE, ACTION_ROUTE_ADD, ACTION_ROUTE_DEL, ACTION_ROUTE_LIST, ACTION_ROUTE_UPDATE, ACTION_SCHEDULE_ADD, ACTION_SCHEDULE_DEL, ACTION_SCHEDULE_UPDATE, ACTION_START, ACTION_SV_UPDATE, ACTION_SYSMEDIA_ADD, ACTION_SYSMEDIA_DEL, ACTION_SYSMEDIA_LIST, ACTION_USER_INFO, ACTION_USER_UPDATE, ACTION_VB_ADD, ACTION_VB_CHANGE_TYPE, ACTION_VB_CLONE, ACTION_VB_DEL, ACTION_VB_LIST, ACTION_VB_UPDATE, ACTION_VB_VIEW, ACTION_VOTING_CLEAN, ACTION_PERM_ROOT_ACCESS, ACTION_DEFAULT, ACTION_REPORT_LIST, ACTION_REPORT_RUN, ACTION_PERM_CDR_STAT ) VALUES (1,0,'ivr-builder', '','ivr builder role', 0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,0,0);
INSERT INTO VPBX_ROLES(IS_TEMPLATE, LANG_ID, LOGIN, PASSWORD, DESCRIPTION, ACTION_ACT_LIST_ALL, ACTION_ACT_LIST, ACTION_AGENT_STATUS, ACTION_BACKUP, ACTION_C2C_ADD, ACTION_C2C_DEL, ACTION_C2C_LIST, ACTION_C2C_UPDATE, ACTION_CALLBLAST_ADD, ACTION_CALLBLAST_DEL_CACHE, ACTION_CALLBLAST_DEL, ACTION_CALLBLAST_UPDATE, ACTION_CALLOUT_CLEAN, ACTION_CALLS_HANGUP, ACTION_CALLS_LIST, ACTION_CDR_LIST, ACTION_CID_ADD, ACTION_CID_DEL, ACTION_CID_LIST, ACTION_CID_UPDATE, ACTION_CRM_ADD, ACTION_CRM_DEL, ACTION_CRM_INFO, ACTION_CRM_LIST, ACTION_CRM_N_ADD, ACTION_CRM_N_DEL, ACTION_CRM_N_UPDATE, ACTION_CRM_UPDATE, ACTION_DASHBOARD_LIST, ACTION_DASHBOARD_LOAD_LIST, ACTION_DIR_ADD, ACTION_DIR_DEL, ACTION_DIR_UPDATE, ACTION_EXT_BACKUP, ACTION_EXTENDED_STAT, ACTION_EXT_RESTORE, ACTION_EXT_STAT, ACTION_FBSHARE, ACTION_GET_ITUNES_ALL, ACTION_GET_ITUNES, ACTION_GET_RSS_ALL, ACTION_GET_RSS, ACTION_GOTOIF_ADD, ACTION_GOTOIF_DEL, ACTION_GOTOIF_UPDATE, ACTION_INTEGRATION_LIST, ACTION_IVRFLOW_LIST, ACTION_J_LIST, ACTION_LIST_GET, ACTION_MACROS_ADD, ACTION_MACROS_DEL, ACTION_MACROS_LIST, ACTION_MACROS_UPDATE, ACTION_MENU, ACTION_MSG_CLEANUP, ACTION_MSG_DELETE, ACTION_MSG_DOWNLOAD, ACTION_MSG_LIST_ALL, ACTION_MSG_LIST, ACTION_MSG_STATUS, ACTION_MSG_UPLOAD, ACTION_MULTIDIALOUT_ADD, ACTION_MULTIDIALOUT_DEL, ACTION_MULTIDIALOUT_RESET, ACTION_MULTIDIALOUT_UPDATE, ACTION_PBOOK_ADD, ACTION_PBOOK_DEL, ACTION_PBOOK_LIST, ACTION_PBOOK_UPDATE, ACTION_PEER_ADD, ACTION_PEER_DEL, ACTION_PEER_LIST, ACTION_PEER_UPDATE, ACTION_PHONE_ADD, ACTION_PHONE_DEL, ACTION_PHONE_INFO, ACTION_PHONE_LIST, ACTION_PHONE_UPDATE, ACTION_RESTORE, ACTION_ROLE_ADD, ACTION_ROLE_DEL, ACTION_ROLE_LIST, ACTION_ROLE_INFO, ACTION_ROLE_UPDATE, ACTION_ROUTE_ADD, ACTION_ROUTE_DEL, ACTION_ROUTE_LIST, ACTION_ROUTE_UPDATE, ACTION_SCHEDULE_ADD, ACTION_SCHEDULE_DEL, ACTION_SCHEDULE_UPDATE, ACTION_START, ACTION_SV_UPDATE, ACTION_SYSMEDIA_ADD, ACTION_SYSMEDIA_DEL, ACTION_SYSMEDIA_LIST, ACTION_USER_INFO, ACTION_USER_UPDATE, ACTION_VB_ADD, ACTION_VB_CHANGE_TYPE, ACTION_VB_CLONE, ACTION_VB_DEL, ACTION_VB_LIST, ACTION_VB_UPDATE, ACTION_VB_VIEW, ACTION_VOTING_CLEAN, ACTION_PERM_ROOT_ACCESS, ACTION_DEFAULT, ACTION_REPORT_LIST, ACTION_REPORT_RUN, ACTION_PERM_CDR_STAT ) VALUES (1,0,'supervisor',  '','supervisor role',  1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1);
INSERT INTO VPBX_ROLES(IS_TEMPLATE, LANG_ID, LOGIN, PASSWORD, DESCRIPTION, ACTION_ACT_LIST_ALL, ACTION_ACT_LIST, ACTION_AGENT_STATUS, ACTION_BACKUP, ACTION_C2C_ADD, ACTION_C2C_DEL, ACTION_C2C_LIST, ACTION_C2C_UPDATE, ACTION_CALLBLAST_ADD, ACTION_CALLBLAST_DEL_CACHE, ACTION_CALLBLAST_DEL, ACTION_CALLBLAST_UPDATE, ACTION_CALLOUT_CLEAN, ACTION_CALLS_HANGUP, ACTION_CALLS_LIST, ACTION_CDR_LIST, ACTION_CID_ADD, ACTION_CID_DEL, ACTION_CID_LIST, ACTION_CID_UPDATE, ACTION_CRM_ADD, ACTION_CRM_DEL, ACTION_CRM_INFO, ACTION_CRM_LIST, ACTION_CRM_N_ADD, ACTION_CRM_N_DEL, ACTION_CRM_N_UPDATE, ACTION_CRM_UPDATE, ACTION_DASHBOARD_LIST, ACTION_DASHBOARD_LOAD_LIST, ACTION_DIR_ADD, ACTION_DIR_DEL, ACTION_DIR_UPDATE, ACTION_EXT_BACKUP, ACTION_EXTENDED_STAT, ACTION_EXT_RESTORE, ACTION_EXT_STAT, ACTION_FBSHARE, ACTION_GET_ITUNES_ALL, ACTION_GET_ITUNES, ACTION_GET_RSS_ALL, ACTION_GET_RSS, ACTION_GOTOIF_ADD, ACTION_GOTOIF_DEL, ACTION_GOTOIF_UPDATE, ACTION_INTEGRATION_LIST, ACTION_IVRFLOW_LIST, ACTION_J_LIST, ACTION_LIST_GET, ACTION_MACROS_ADD, ACTION_MACROS_DEL, ACTION_MACROS_LIST, ACTION_MACROS_UPDATE, ACTION_MENU, ACTION_MSG_CLEANUP, ACTION_MSG_DELETE, ACTION_MSG_DOWNLOAD, ACTION_MSG_LIST_ALL, ACTION_MSG_LIST, ACTION_MSG_STATUS, ACTION_MSG_UPLOAD, ACTION_MULTIDIALOUT_ADD, ACTION_MULTIDIALOUT_DEL, ACTION_MULTIDIALOUT_RESET, ACTION_MULTIDIALOUT_UPDATE, ACTION_PBOOK_ADD, ACTION_PBOOK_DEL, ACTION_PBOOK_LIST, ACTION_PBOOK_UPDATE, ACTION_PEER_ADD, ACTION_PEER_DEL, ACTION_PEER_LIST, ACTION_PEER_UPDATE, ACTION_PHONE_ADD, ACTION_PHONE_DEL, ACTION_PHONE_INFO, ACTION_PHONE_LIST, ACTION_PHONE_UPDATE, ACTION_RESTORE, ACTION_ROLE_ADD, ACTION_ROLE_DEL, ACTION_ROLE_LIST, ACTION_ROLE_INFO, ACTION_ROLE_UPDATE, ACTION_ROUTE_ADD, ACTION_ROUTE_DEL, ACTION_ROUTE_LIST, ACTION_ROUTE_UPDATE, ACTION_SCHEDULE_ADD, ACTION_SCHEDULE_DEL, ACTION_SCHEDULE_UPDATE, ACTION_START, ACTION_SV_UPDATE, ACTION_SYSMEDIA_ADD, ACTION_SYSMEDIA_DEL, ACTION_SYSMEDIA_LIST, ACTION_USER_INFO, ACTION_USER_UPDATE, ACTION_VB_ADD, ACTION_VB_CHANGE_TYPE, ACTION_VB_CLONE, ACTION_VB_DEL, ACTION_VB_LIST, ACTION_VB_UPDATE, ACTION_VB_VIEW, ACTION_VOTING_CLEAN, ACTION_PERM_ROOT_ACCESS, ACTION_DEFAULT, ACTION_REPORT_LIST, ACTION_REPORT_RUN, ACTION_PERM_CDR_STAT ) VALUES (1,0,'cdrviewer',   '','cdrviewer role',   1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1);
INSERT INTO VPBX_ROLES(IS_TEMPLATE, LANG_ID, LOGIN, PASSWORD, DESCRIPTION, ACTION_ACT_LIST_ALL, ACTION_ACT_LIST, ACTION_AGENT_STATUS, ACTION_BACKUP, ACTION_C2C_ADD, ACTION_C2C_DEL, ACTION_C2C_LIST, ACTION_C2C_UPDATE, ACTION_CALLBLAST_ADD, ACTION_CALLBLAST_DEL_CACHE, ACTION_CALLBLAST_DEL, ACTION_CALLBLAST_UPDATE, ACTION_CALLOUT_CLEAN, ACTION_CALLS_HANGUP, ACTION_CALLS_LIST, ACTION_CDR_LIST, ACTION_CID_ADD, ACTION_CID_DEL, ACTION_CID_LIST, ACTION_CID_UPDATE, ACTION_CRM_ADD, ACTION_CRM_DEL, ACTION_CRM_INFO, ACTION_CRM_LIST, ACTION_CRM_N_ADD, ACTION_CRM_N_DEL, ACTION_CRM_N_UPDATE, ACTION_CRM_UPDATE, ACTION_DASHBOARD_LIST, ACTION_DASHBOARD_LOAD_LIST, ACTION_DIR_ADD, ACTION_DIR_DEL, ACTION_DIR_UPDATE, ACTION_EXT_BACKUP, ACTION_EXTENDED_STAT, ACTION_EXT_RESTORE, ACTION_EXT_STAT, ACTION_FBSHARE, ACTION_GET_ITUNES_ALL, ACTION_GET_ITUNES, ACTION_GET_RSS_ALL, ACTION_GET_RSS, ACTION_GOTOIF_ADD, ACTION_GOTOIF_DEL, ACTION_GOTOIF_UPDATE, ACTION_INTEGRATION_LIST, ACTION_IVRFLOW_LIST, ACTION_J_LIST, ACTION_LIST_GET, ACTION_MACROS_ADD, ACTION_MACROS_DEL, ACTION_MACROS_LIST, ACTION_MACROS_UPDATE, ACTION_MENU, ACTION_MSG_CLEANUP, ACTION_MSG_DELETE, ACTION_MSG_DOWNLOAD, ACTION_MSG_LIST_ALL, ACTION_MSG_LIST, ACTION_MSG_STATUS, ACTION_MSG_UPLOAD, ACTION_MULTIDIALOUT_ADD, ACTION_MULTIDIALOUT_DEL, ACTION_MULTIDIALOUT_RESET, ACTION_MULTIDIALOUT_UPDATE, ACTION_PBOOK_ADD, ACTION_PBOOK_DEL, ACTION_PBOOK_LIST, ACTION_PBOOK_UPDATE, ACTION_PEER_ADD, ACTION_PEER_DEL, ACTION_PEER_LIST, ACTION_PEER_UPDATE, ACTION_PHONE_ADD, ACTION_PHONE_DEL, ACTION_PHONE_INFO, ACTION_PHONE_LIST, ACTION_PHONE_UPDATE, ACTION_RESTORE, ACTION_ROLE_ADD, ACTION_ROLE_DEL, ACTION_ROLE_LIST, ACTION_ROLE_INFO, ACTION_ROLE_UPDATE, ACTION_ROUTE_ADD, ACTION_ROUTE_DEL, ACTION_ROUTE_LIST, ACTION_ROUTE_UPDATE, ACTION_SCHEDULE_ADD, ACTION_SCHEDULE_DEL, ACTION_SCHEDULE_UPDATE, ACTION_START, ACTION_SV_UPDATE, ACTION_SYSMEDIA_ADD, ACTION_SYSMEDIA_DEL, ACTION_SYSMEDIA_LIST, ACTION_USER_INFO, ACTION_USER_UPDATE, ACTION_VB_ADD, ACTION_VB_CHANGE_TYPE, ACTION_VB_CLONE, ACTION_VB_DEL, ACTION_VB_LIST, ACTION_VB_UPDATE, ACTION_VB_VIEW, ACTION_VOTING_CLEAN, ACTION_PERM_ROOT_ACCESS, ACTION_DEFAULT, ACTION_REPORT_LIST, ACTION_REPORT_RUN, ACTION_PERM_CDR_STAT ) VALUES (1,0,'phones-admin','','phones-admin role',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0);
INSERT INTO VPBX_ROLES(IS_TEMPLATE, LANG_ID, LOGIN, PASSWORD, DESCRIPTION, ACTION_ACT_LIST_ALL, ACTION_ACT_LIST, ACTION_AGENT_STATUS, ACTION_BACKUP, ACTION_C2C_ADD, ACTION_C2C_DEL, ACTION_C2C_LIST, ACTION_C2C_UPDATE, ACTION_CALLBLAST_ADD, ACTION_CALLBLAST_DEL_CACHE, ACTION_CALLBLAST_DEL, ACTION_CALLBLAST_UPDATE, ACTION_CALLOUT_CLEAN, ACTION_CALLS_HANGUP, ACTION_CALLS_LIST, ACTION_CDR_LIST, ACTION_CID_ADD, ACTION_CID_DEL, ACTION_CID_LIST, ACTION_CID_UPDATE, ACTION_CRM_ADD, ACTION_CRM_DEL, ACTION_CRM_INFO, ACTION_CRM_LIST, ACTION_CRM_N_ADD, ACTION_CRM_N_DEL, ACTION_CRM_N_UPDATE, ACTION_CRM_UPDATE, ACTION_DASHBOARD_LIST, ACTION_DASHBOARD_LOAD_LIST, ACTION_DIR_ADD, ACTION_DIR_DEL, ACTION_DIR_UPDATE, ACTION_EXT_BACKUP, ACTION_EXTENDED_STAT, ACTION_EXT_RESTORE, ACTION_EXT_STAT, ACTION_FBSHARE, ACTION_GET_ITUNES_ALL, ACTION_GET_ITUNES, ACTION_GET_RSS_ALL, ACTION_GET_RSS, ACTION_GOTOIF_ADD, ACTION_GOTOIF_DEL, ACTION_GOTOIF_UPDATE, ACTION_INTEGRATION_LIST, ACTION_IVRFLOW_LIST, ACTION_J_LIST, ACTION_LIST_GET, ACTION_MACROS_ADD, ACTION_MACROS_DEL, ACTION_MACROS_LIST, ACTION_MACROS_UPDATE, ACTION_MENU, ACTION_MSG_CLEANUP, ACTION_MSG_DELETE, ACTION_MSG_DOWNLOAD, ACTION_MSG_LIST_ALL, ACTION_MSG_LIST, ACTION_MSG_STATUS, ACTION_MSG_UPLOAD, ACTION_MULTIDIALOUT_ADD, ACTION_MULTIDIALOUT_DEL, ACTION_MULTIDIALOUT_RESET, ACTION_MULTIDIALOUT_UPDATE, ACTION_PBOOK_ADD, ACTION_PBOOK_DEL, ACTION_PBOOK_LIST, ACTION_PBOOK_UPDATE, ACTION_PEER_ADD, ACTION_PEER_DEL, ACTION_PEER_LIST, ACTION_PEER_UPDATE, ACTION_PHONE_ADD, ACTION_PHONE_DEL, ACTION_PHONE_INFO, ACTION_PHONE_LIST, ACTION_PHONE_UPDATE, ACTION_RESTORE, ACTION_ROLE_ADD, ACTION_ROLE_DEL, ACTION_ROLE_LIST, ACTION_ROLE_INFO, ACTION_ROLE_UPDATE, ACTION_ROUTE_ADD, ACTION_ROUTE_DEL, ACTION_ROUTE_LIST, ACTION_ROUTE_UPDATE, ACTION_SCHEDULE_ADD, ACTION_SCHEDULE_DEL, ACTION_SCHEDULE_UPDATE, ACTION_START, ACTION_SV_UPDATE, ACTION_SYSMEDIA_ADD, ACTION_SYSMEDIA_DEL, ACTION_SYSMEDIA_LIST, ACTION_USER_INFO, ACTION_USER_UPDATE, ACTION_VB_ADD, ACTION_VB_CHANGE_TYPE, ACTION_VB_CLONE, ACTION_VB_DEL, ACTION_VB_LIST, ACTION_VB_UPDATE, ACTION_VB_VIEW, ACTION_VOTING_CLEAN, ACTION_PERM_ROOT_ACCESS, ACTION_DEFAULT, ACTION_REPORT_LIST, ACTION_REPORT_RUN, ACTION_PERM_CDR_STAT ) VALUES (1,0,'monitoring',  '','monitoring role',  1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1);

-- KAMAILIO
CREATE TABLE version (
    table_name VARCHAR(32) NOT NULL,
    table_version INT UNSIGNED DEFAULT 0 NOT NULL,
    CONSTRAINT table_name_idx UNIQUE (table_name)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

INSERT INTO version (table_name, table_version) values( 'subscriber', 6 );
CREATE OR replace view subscriber  ( id, username, domain, password, email_address, ha1, ha1b, rpid )
	as
select
	DATA_ID, 
	name,
	'virtual-pbx',
	secret,
	'',
	md5(concat(name,':virtual-pbx:',secret)),
	md5(concat(name,'@virtual-pbx:virtual-pbx:',secret)),
	NULL
from
	VPBX_SIPPEERS
where type='friend' and PEER_TYPE = 0;

INSERT INTO version (table_name, table_version) values( 'location', 8 );
CREATE TABLE location (
    id INT(10) UNSIGNED AUTO_INCREMENT PRIMARY KEY NOT NULL,
    ruid VARCHAR(64) DEFAULT '' NOT NULL,
    username VARCHAR(64) DEFAULT '' NOT NULL,
    domain VARCHAR(64) DEFAULT NULL,
    contact VARCHAR(255) DEFAULT '' NOT NULL,
    received VARCHAR(128) DEFAULT NULL,
    path VARCHAR(512) DEFAULT NULL,
    expires DATETIME DEFAULT '2030-05-28 21:32:15' NOT NULL,
    q FLOAT(10,2) DEFAULT 1.0 NOT NULL,
    callid VARCHAR(255) DEFAULT 'Default-Call-ID' NOT NULL,
    cseq INT(11) DEFAULT 1 NOT NULL,
    last_modified DATETIME DEFAULT '1900-01-01 00:00:01' NOT NULL,
    flags INT(11) DEFAULT 0 NOT NULL,
    cflags INT(11) DEFAULT 0 NOT NULL,
    user_agent VARCHAR(255) DEFAULT '' NOT NULL,
    socket VARCHAR(64) DEFAULT NULL,
    methods INT(11) DEFAULT NULL,
    instance VARCHAR(255) DEFAULT NULL,
    reg_id INT(11) DEFAULT 0 NOT NULL,
	server_id INT(11) DEFAULT 0 NOT NULL,
	connection_id INT(11) DEFAULT 0 NOT NULL,
	keepalive INT(11) DEFAULT 0 NOT NULL,
	`partition` INT(11) DEFAULT 0 NOT NULL,
    CONSTRAINT ruid_idx UNIQUE (ruid)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

CREATE INDEX account_contact_idx ON location (username, domain, contact);
CREATE INDEX expires_idx ON location (expires);

INSERT INTO version (table_name, table_version) values ('location_attrs',1);
CREATE TABLE location_attrs (
    id INT(10) UNSIGNED AUTO_INCREMENT PRIMARY KEY NOT NULL,
    ruid VARCHAR(64) DEFAULT '' NOT NULL,
    username VARCHAR(64) DEFAULT '' NOT NULL,
    domain VARCHAR(64) DEFAULT NULL,
    aname VARCHAR(64) DEFAULT '' NOT NULL,
    atype INT(11) DEFAULT 0 NOT NULL,
    avalue VARCHAR(255) DEFAULT '' NOT NULL,
    last_modified DATETIME DEFAULT '1900-01-01 00:00:01' NOT NULL
) ENGINE=INNODB DEFAULT CHARSET=utf8;

CREATE INDEX account_record_idx ON location_attrs (username, domain, ruid);
CREATE INDEX last_modified_idx ON location_attrs (last_modified);

INSERT INTO version (table_name, table_version) values ('presentity','4');
CREATE TABLE presentity (
	id INT(10) UNSIGNED AUTO_INCREMENT PRIMARY KEY NOT NULL,
	username VARCHAR(64) NOT NULL,
	domain VARCHAR(64) NOT NULL,
	event VARCHAR(64) NOT NULL,
	etag VARCHAR(64) NOT NULL,
	expires INT(11) NOT NULL,
	received_time INT(11) NOT NULL,
	body BLOB NOT NULL,
	sender VARCHAR(128) NOT NULL,
	priority INT(11) DEFAULT 0 NOT NULL,
	CONSTRAINT presentity_idx UNIQUE (username, domain, event, etag)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

CREATE INDEX presentity_expires ON presentity (expires);
CREATE INDEX account_idx ON presentity (username, domain, event);

INSERT INTO version (table_name, table_version) values ('active_watchers','11');
CREATE TABLE active_watchers (
    id INT(10) UNSIGNED AUTO_INCREMENT PRIMARY KEY NOT NULL,
    presentity_uri VARCHAR(128) NOT NULL,
    watcher_username VARCHAR(64) NOT NULL,
    watcher_domain VARCHAR(64) NOT NULL,
    to_user VARCHAR(64) NOT NULL,
    to_domain VARCHAR(64) NOT NULL,
    event VARCHAR(64) DEFAULT 'presence' NOT NULL,
    event_id VARCHAR(64),
    to_tag VARCHAR(64) NOT NULL,
    from_tag VARCHAR(64) NOT NULL,
    callid VARCHAR(255) NOT NULL,
    local_cseq INT(11) NOT NULL,
    remote_cseq INT(11) NOT NULL,
    contact VARCHAR(128) NOT NULL,
    record_route TEXT,
    expires INT(11) NOT NULL,
    status INT(11) DEFAULT 2 NOT NULL,
    reason VARCHAR(64) NOT NULL,
    version INT(11) DEFAULT 0 NOT NULL,
    socket_info VARCHAR(64) NOT NULL,
    local_contact VARCHAR(128) NOT NULL,
    from_user VARCHAR(64) NOT NULL,
    from_domain VARCHAR(64) NOT NULL,
    updated INT(11) NOT NULL,
    updated_winfo INT(11) NOT NULL,
    CONSTRAINT active_watchers_idx UNIQUE (callid, to_tag, from_tag)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

CREATE INDEX active_watchers_expires ON active_watchers (expires);
CREATE INDEX active_watchers_pres ON active_watchers (presentity_uri, event);
CREATE INDEX updated_idx ON active_watchers (updated);
CREATE INDEX updated_winfo_idx ON active_watchers (updated_winfo, presentity_uri);

INSERT INTO version (table_name, table_version) values ('watchers','3');
CREATE TABLE watchers (
    id INT(10) UNSIGNED AUTO_INCREMENT PRIMARY KEY NOT NULL,
    presentity_uri VARCHAR(128) NOT NULL,
    watcher_username VARCHAR(64) NOT NULL,
    watcher_domain VARCHAR(64) NOT NULL,
    event VARCHAR(64) DEFAULT 'presence' NOT NULL,
    status INT(11) NOT NULL,
    reason VARCHAR(64),
    inserted_time INT(11) NOT NULL,
    CONSTRAINT watcher_idx UNIQUE (presentity_uri, watcher_username, watcher_domain, event)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

INSERT INTO version (table_name, table_version) values ('xcap','4');
CREATE TABLE xcap (
    id INT(10) UNSIGNED AUTO_INCREMENT PRIMARY KEY NOT NULL,
    username VARCHAR(64) NOT NULL,
    domain VARCHAR(64) NOT NULL,
    doc MEDIUMBLOB NOT NULL,
    doc_type INT(11) NOT NULL,
    etag VARCHAR(64) NOT NULL,
    source INT(11) NOT NULL,
    doc_uri VARCHAR(255) NOT NULL,
    port INT(11) NOT NULL,
    CONSTRAINT doc_uri_idx UNIQUE (doc_uri)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

CREATE INDEX account_doc_type_idx ON xcap (username, domain, doc_type);
CREATE INDEX account_doc_type_uri_idx ON xcap (username, domain, doc_type, doc_uri);
CREATE INDEX account_doc_uri_idx ON xcap (username, domain, doc_uri);

INSERT INTO version (table_name, table_version) values ('pua','7');
CREATE TABLE pua (
    id INT(10) UNSIGNED AUTO_INCREMENT PRIMARY KEY NOT NULL,
    pres_uri VARCHAR(128) NOT NULL,
    pres_id VARCHAR(255) NOT NULL,
    event INT(11) NOT NULL,
    expires INT(11) NOT NULL,
    desired_expires INT(11) NOT NULL,
    flag INT(11) NOT NULL,
    etag VARCHAR(64) NOT NULL,
    tuple_id VARCHAR(64),
    watcher_uri VARCHAR(128) NOT NULL,
    call_id VARCHAR(255) NOT NULL,
    to_tag VARCHAR(64) NOT NULL,
    from_tag VARCHAR(64) NOT NULL,
    cseq INT(11) NOT NULL,
    record_route TEXT,
    contact VARCHAR(128) NOT NULL,
    remote_contact VARCHAR(128) NOT NULL,
    version INT(11) NOT NULL,
    extra_headers TEXT NOT NULL,
    CONSTRAINT pua_idx UNIQUE (etag, tuple_id, call_id, from_tag)
) ENGINE=INNODB DEFAULT CHARSET=utf8;

CREATE INDEX expires_idx ON pua (expires);
CREATE INDEX dialog1_idx ON pua (pres_id, pres_uri);
CREATE INDEX dialog2_idx ON pua (call_id, from_tag);
CREATE INDEX record_idx ON pua (pres_id);

-- phone last reg time /asterisk
delimiter //
CREATE 
DEFINER='xvb'@'localhost'
trigger ins_reg_time BEFORE UPDATE ON VPBX_SIPPEERS 
FOR EACH ROW
BEGIN
	IF NEW.regseconds is not null THEN
		IF NEW.regseconds > 0 THEN
			SET NEW.REG_TIME = UNIX_TIMESTAMP();
			SET NEW.REG_NODE = (SELECT SUBSTRING_INDEX(host, ':', 1) AS client_host FROM information_schema.processlist WHERE ID = connection_id());
		ELSE
			SET NEW.useragent = OLD.useragent;
			SET NEW.ipaddr = OLD.ipaddr;
		END IF;
	END IF;
END;
//
delimiter ;

-- phone last reg time kamailio
delimiter //
CREATE 
DEFINER='xvb'@'localhost'
trigger ins_reg_time_kam_upd AFTER UPDATE ON location
FOR EACH ROW
BEGIN
	UPDATE VPBX_SIPPEERS 
		SET 
			VPBX_SIPPEERS.useragent = new.user_agent, 
			VPBX_SIPPEERS.REG_TIME=UNIX_TIMESTAMP(), 
			regseconds=UNIX_TIMESTAMP(NEW.expires) 
		where VPBX_SIPPEERS.name=NEW.username; 
END;
//
delimiter ;
delimiter //
CREATE 
DEFINER='xvb'@'localhost'
trigger ins_reg_time_kam_ins AFTER INSERT ON location
FOR EACH ROW
BEGIN
	UPDATE VPBX_SIPPEERS 
		SET 
			VPBX_SIPPEERS.useragent = new.user_agent, 
			VPBX_SIPPEERS.REG_TIME=UNIX_TIMESTAMP(), 
			regseconds=UNIX_TIMESTAMP(NEW.expires) 
		where VPBX_SIPPEERS.name=NEW.username; 
END;
//
delimiter ;

-- grants
grant all on *.* to 'xvb'@'localhost';

