use xvb;

-- 27/03/2023

-- drop index I_CDR_C_STOP_T on VPBX_CDRS;
-- drop index I_CDR_C_START_T on VPBX_CDRS;

create index I_CDR_C_STOP_T2 on VPBX_CDRS(SUBSCR_ID,STOP_TIMESTAMP);
create index I_CDR_C_START_T2 on VPBX_CDRS(SUBSCR_ID,STOP_TIMESTAMP);
create index I_CDR_C_STOP_TIME2 on VPBX_CDRS(STOP_TIMESTAMP);
create index I_CDR_C_START_TIME2 on VPBX_CDRS(STOP_TIMESTAMP);

create index I_CDR_C_STOP_T2 on VPBX_CDRS_ARCHIVE(SUBSCR_ID,STOP_TIMESTAMP);

-- drop index I_CDR_A_STOP_T on VPBX_CDRS_ACTIVITY;
-- drop index I_CDR_A_START_T on VPBX_CDRS_ACTIVITY;

create index I_CDR_A_STOP_T2 on VPBX_CDRS_ACTIVITY(SUBSCR_ID,STOP_TIMESTAMP);
create index I_CDR_A_START_T2 on VPBX_CDRS_ACTIVITY(SUBSCR_ID,STOP_TIMESTAMP);

-- cdr archive
ALTER TABLE VPBX_CDRS_ARCHIVE ADD COLUMN CALL_ID_SIP VARCHAR(255);
DROP TRIGGER cdr_cleanup_triger;
CREATE TRIGGER cdr_cleanup_triger BEFORE DELETE ON VPBX_CDRS FOR EACH ROW
INSERT INTO VPBX_CDRS_ARCHIVE
	( 
			SERVER_ID,
			CALL_ID,
			CALL_TYPE,
  		  	SUBSCR_ID,
			CALLER_ID,
			CALLED_ID,
			CNAM,
			START_TIMESTAMP,
			STOP_TIMESTAMP,
			CREATE_TIMESTAMP,
			COST,
			SYS_COST,
			CURRENCY_ID,
			PROCESS_TIMESTAMP,
			DATA,
			STOP_DATE,
			CALL_ID_SIP
	)
	VALUES
	( 
			OLD.SERVER_ID,
			OLD.CALL_ID,
			OLD.CALL_TYPE,
  		  	OLD.SUBSCR_ID,
			OLD.CALLER_ID,
			OLD.CALLED_ID,
			OLD.CNAM,
			OLD.START_TIMESTAMP,
			OLD.STOP_TIMESTAMP,
			OLD.CREATE_TIMESTAMP,
			OLD.COST,
			OLD.SYS_COST,
			OLD.CURRENCY_ID,
			OLD.PROCESS_TIMESTAMP,
			OLD.DATA,
			FROM_UNIXTIME(OLD.STOP_TIMESTAMP),
			OLD.CALL_ID_SIP
	);

create or replace view VPBX_CDRS_ALL 
	(SERVER_ID,CALL_ID,CALL_TYPE,SUBSCR_ID,CALLER_ID,CALLED_ID,CNAM,START_TIMESTAMP,STOP_TIMESTAMP,CREATE_TIMESTAMP,COST,SYS_COST,CURRENCY_ID,CALL_ID_SIP,PROCESS_TIMESTAMP,DATA)
	as
select 
	SERVER_ID,CALL_ID,CALL_TYPE,SUBSCR_ID,CALLER_ID,CALLED_ID,CNAM,START_TIMESTAMP,STOP_TIMESTAMP,CREATE_TIMESTAMP,COST,SYS_COST,CURRENCY_ID,CALL_ID_SIP,PROCESS_TIMESTAMP,DATA
from
	VPBX_CDRS
union
select 
	SERVER_ID,CALL_ID,CALL_TYPE,SUBSCR_ID,CALLER_ID,CALLED_ID,CNAM,START_TIMESTAMP,STOP_TIMESTAMP,CREATE_TIMESTAMP,COST,SYS_COST,CURRENCY_ID,CALL_ID_SIP,PROCESS_TIMESTAMP,DATA
from
	VPBX_CDRS_ARCHIVE;

